/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.parser;

import com.android.tools.idea.gradle.editor.entity.ExternalDependencyGradleEditorEntity;
import com.android.tools.idea.gradle.editor.entity.GradleEditorEntity;
import com.android.tools.idea.gradle.editor.entity.GradleEditorSourceBinding;
import com.android.tools.idea.gradle.editor.metadata.GradleEditorEntityMetaData;
import com.android.tools.idea.gradle.editor.metadata.StdGradleEditorEntityMetaData;
import com.android.tools.idea.gradle.editor.parser.GradleEditorModelParseContext;
import com.android.tools.idea.gradle.editor.parser.GradleEditorModelUtil;
import com.android.tools.idea.gradle.editor.value.GradleEditorEntityValueManager;
import com.android.tools.idea.gradle.editor.value.LibraryVersionsManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleEditorDependencyParser {
    private static final Pattern EXTERNAL_DEPENDENCY_PATTERN = Pattern.compile("([^:\\s]+):([^:\\s()]+):([^:()]+)");

    @Nullable
    public GradleEditorEntity parse(@NotNull GradleEditorModelParseContext.Assignment assignment, @NotNull GradleEditorModelParseContext context) {
        Matcher matcher;
        if (assignment == null) {
            GradleEditorDependencyParser.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GradleEditorDependencyParser.$$$reportNull$$$0(1);
        }
        if (assignment.value == null) {
            return null;
        }
        String dependencyText = assignment.value.value;
        if (dependencyText.isEmpty() && assignment.rValueString != null) {
            dependencyText = assignment.rValueString;
        }
        if (!(matcher = EXTERNAL_DEPENDENCY_PATTERN.matcher(dependencyText)).matches()) {
            return null;
        }
        GradleEditorSourceBinding scopeSourceBinding = GradleEditorModelUtil.buildSourceBinding(assignment.lValueLocation, context.getProject());
        if (scopeSourceBinding == null) {
            return null;
        }
        DependencyDimension group = GradleEditorDependencyParser.parseDimension(TextRange.create((int)matcher.start(1), (int)matcher.end(1)), assignment, dependencyText, context);
        if (group == null) {
            return null;
        }
        DependencyDimension artifact = GradleEditorDependencyParser.parseDimension(TextRange.create((int)matcher.start(2), (int)matcher.end(2)), assignment, dependencyText, context);
        if (artifact == null) {
            return null;
        }
        DependencyDimension version2 = GradleEditorDependencyParser.parseDimension(TextRange.create((int)matcher.start(3), (int)matcher.end(3)), assignment, dependencyText, context);
        if (version2 == null) {
            return null;
        }
        GradleEditorSourceBinding entityLocation = GradleEditorModelUtil.buildSourceBinding(assignment, context.getProject());
        if (entityLocation == null) {
            return null;
        }
        HashSet metaData = Sets.newHashSet();
        metaData.add(StdGradleEditorEntityMetaData.REMOVABLE);
        if (context.getTargetFile().equals(assignment.lValueLocation.file)) {
            String s;
            if (!assignment.codeStructure.isEmpty() && ("allprojects".equals(s = assignment.codeStructure.get(0)) || "subprojects".equals(s))) {
                metaData.add(StdGradleEditorEntityMetaData.OUTGOING);
            }
        } else {
            metaData.add(StdGradleEditorEntityMetaData.INJECTED);
        }
        GradleEditorEntityValueManager versionValueManager = group.value.isEmpty() || artifact.value.isEmpty() ? GradleEditorEntityValueManager.NO_OP : new LibraryVersionsManager(group.value, artifact.value);
        return new ExternalDependencyGradleEditorEntity(assignment.lValue.name, Arrays.asList(scopeSourceBinding), group.value, group.sourceBindings, artifact.value, artifact.sourceBindings, version2.value, version2.sourceBindings, entityLocation, version2.declarationValueLocation, versionValueManager, metaData);
    }

    @Nullable
    private static DependencyDimension parseDimension(@NotNull TextRange dimensionRange, @NotNull GradleEditorModelParseContext.Assignment assignment, @NotNull String dependencyDeclarationString, @NotNull GradleEditorModelParseContext context) {
        Set<GradleEditorEntityMetaData> metaData;
        if (dimensionRange == null) {
            GradleEditorDependencyParser.$$$reportNull$$$0(2);
        }
        if (assignment == null) {
            GradleEditorDependencyParser.$$$reportNull$$$0(3);
        }
        if (dependencyDeclarationString == null) {
            GradleEditorDependencyParser.$$$reportNull$$$0(4);
        }
        if (context == null) {
            GradleEditorDependencyParser.$$$reportNull$$$0(5);
        }
        if (assignment.value == null) {
            return null;
        }
        TextRange dimensionRangeInFile = dimensionRange.shiftRight(assignment.value.location.range.getStartOffset());
        ArrayList dependencies = Lists.newArrayList();
        for (Map.Entry entry : assignment.dependencies.entries()) {
            if (!dimensionRangeInFile.contains(((GradleEditorModelParseContext.Location)entry.getValue()).range)) continue;
            dependencies.add(entry.getKey());
        }
        String dimensionValue = dependencyDeclarationString.substring(dimensionRange.getStartOffset(), dimensionRange.getEndOffset());
        ArrayList sourceBindings = Lists.newArrayList();
        if (dependencies.isEmpty() || dependencies.size() > 1 || !GradleEditorModelUtil.isVariable(dimensionValue, ((GradleEditorModelParseContext.Variable)dependencies.get((int)0)).name)) {
            GradleEditorModelParseContext.Location dimensionLocation;
            GradleEditorSourceBinding sourceBinding;
            TextRange rangeToUse = assignment.value.location.range.cutOut(dimensionRange);
            if (dimensionValue.startsWith("${") && dimensionValue.endsWith("}") && !"${}".equals(dimensionValue)) {
                rangeToUse = TextRange.create((int)(rangeToUse.getStartOffset() + "${".length()), (int)(rangeToUse.getEndOffset() - "}".length()));
                dimensionValue = "";
            }
            if ((sourceBinding = GradleEditorModelUtil.buildSourceBinding(dimensionLocation = new GradleEditorModelParseContext.Location(assignment.value.location.file, rangeToUse), context.getProject())) == null) {
                return null;
            }
            sourceBindings.add(sourceBinding);
        } else {
            dimensionValue = "";
        }
        GradleEditorSourceBinding dimensionLocation = GradleEditorModelUtil.buildSourceBinding(new GradleEditorModelParseContext.Location(assignment.lValueLocation.file, dimensionRangeInFile), context.getProject());
        if (dimensionLocation == null) {
            return null;
        }
        Set<Object> set = metaData = assignment.lValueLocation.file.equals(context.getTargetFile()) ? Collections.emptySet() : Collections.singleton(StdGradleEditorEntityMetaData.INJECTED);
        if (dependencies.isEmpty()) {
            return new DependencyDimension(dimensionValue, sourceBindings, dimensionLocation, metaData);
        }
        GradleEditorModelUtil.EntityInfo entityInfo = GradleEditorModelUtil.collectInfo(dependencies, context, null);
        String valueToUse = sourceBindings.isEmpty() ? entityInfo.value : "";
        sourceBindings.addAll(entityInfo.sourceBindings);
        return new DependencyDimension(valueToUse, sourceBindings, dimensionLocation, metaData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dimensionRange";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyDeclarationString";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/editor/parser/GradleEditorDependencyParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parse";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "parseDimension";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DependencyDimension {
        @NotNull
        public final String value;
        @NotNull
        public final List<GradleEditorSourceBinding> sourceBindings;
        @NotNull
        public final GradleEditorSourceBinding declarationValueLocation;
        @NotNull
        public final Set<GradleEditorEntityMetaData> metaData;

        DependencyDimension(@NotNull String value, @NotNull List<GradleEditorSourceBinding> sourceBindings, @NotNull GradleEditorSourceBinding declarationValueLocation, @NotNull Set<GradleEditorEntityMetaData> metaData) {
            if (value == null) {
                DependencyDimension.$$$reportNull$$$0(0);
            }
            if (sourceBindings == null) {
                DependencyDimension.$$$reportNull$$$0(1);
            }
            if (declarationValueLocation == null) {
                DependencyDimension.$$$reportNull$$$0(2);
            }
            if (metaData == null) {
                DependencyDimension.$$$reportNull$$$0(3);
            }
            this.value = value;
            this.sourceBindings = sourceBindings;
            this.declarationValueLocation = declarationValueLocation;
            this.metaData = metaData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sourceBindings";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "declarationValueLocation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "metaData";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/editor/parser/GradleEditorDependencyParser$DependencyDimension";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

