/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.ui;

import com.android.tools.idea.gradle.editor.entity.GradleEditorEntity;
import com.android.tools.idea.gradle.editor.entity.GradleEditorEntityGroup;
import com.android.tools.idea.gradle.editor.ui.GradleEditorEntityTable;
import com.android.tools.idea.gradle.editor.ui.GradleEditorUiConstants;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class GradleEditorComponent
extends JBScrollPane {
    private final Map<String, GradleEditorEntityTable> myTablesByGroupName;
    private final Map<String, JBPanel> myPanelsByGroupName;
    private final JBPanel myCanvas;
    @NotNull
    private final Project myProject;

    public GradleEditorComponent(@NotNull Project project, @NotNull List<GradleEditorEntityGroup> groups) {
        if (project == null) {
            GradleEditorComponent.$$$reportNull$$$0(0);
        }
        if (groups == null) {
            GradleEditorComponent.$$$reportNull$$$0(1);
        }
        this.myTablesByGroupName = Maps.newHashMap();
        this.myPanelsByGroupName = Maps.newHashMap();
        this.myCanvas = new JBPanel((LayoutManager)new GridBagLayout());
        this.myProject = project;
        this.setViewportView((Component)this.myCanvas);
        this.myCanvas.setBackground(GradleEditorUiConstants.BACKGROUND_COLOR);
        this.setData(groups);
    }

    private void addUiForGroup(@NotNull GradleEditorEntityGroup group) {
        if (group == null) {
            GradleEditorComponent.$$$reportNull$$$0(2);
        }
        JBPanel panel = new JBPanel((LayoutManager)new BorderLayout());
        panel.setBackground(UIUtil.getTableBackground());
        panel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)group.getName()));
        GradleEditorEntityTable table2 = new GradleEditorEntityTable(this.myProject);
        for (GradleEditorEntity entity : group.getEntities()) {
            table2.getModel().add(entity);
        }
        panel.add((Component)((Object)table2));
        this.addUiForGroup(group.getName(), panel, table2);
    }

    private void addUiForGroup(@NotNull String groupName, @NotNull JBPanel component, @NotNull GradleEditorEntityTable table2) {
        if (groupName == null) {
            GradleEditorComponent.$$$reportNull$$$0(3);
        }
        if (component == null) {
            GradleEditorComponent.$$$reportNull$$$0(4);
        }
        if (table2 == null) {
            GradleEditorComponent.$$$reportNull$$$0(5);
        }
        GridBag constraints = new GridBag().weightx(1.0).anchor(17).fillCellHorizontally().coverLine().insets(8, 8, 8, 8);
        this.myCanvas.add((Component)component, (Object)constraints);
        this.myTablesByGroupName.put(groupName, table2);
        this.myPanelsByGroupName.put(groupName, component);
    }

    public void flushChanges() {
        for (GradleEditorEntityTable table2 : this.myTablesByGroupName.values()) {
            if (!table2.isEditing()) continue;
            table2.getCellEditor().stopCellEditing();
        }
    }

    public void setData(@NotNull List<GradleEditorEntityGroup> groups) {
        if (groups == null) {
            GradleEditorComponent.$$$reportNull$$$0(6);
        }
        boolean sameTables = groups.size() == this.myTablesByGroupName.size();
        for (GradleEditorEntityGroup group : groups) {
            GradleEditorEntityTable table2 = this.myTablesByGroupName.get(group.getName());
            if (table2 == null) {
                sameTables = false;
                continue;
            }
            if (table2.isEditing()) {
                table2.getCellEditor().stopCellEditing();
            }
            table2.getModel().setData(group.getEntities());
        }
        if (sameTables) {
            return;
        }
        this.myCanvas.removeAll();
        HashMap tablesByGroupName = Maps.newHashMap(this.myTablesByGroupName);
        this.myTablesByGroupName.clear();
        HashMap panelsByGroupName = Maps.newHashMap(this.myPanelsByGroupName);
        this.myPanelsByGroupName.clear();
        for (GradleEditorEntityGroup group : groups) {
            JBPanel panel = (JBPanel)panelsByGroupName.get(group.getName());
            GradleEditorEntityTable table3 = (GradleEditorEntityTable)((Object)tablesByGroupName.get(group.getName()));
            if (panel != null && table3 != null) {
                this.addUiForGroup(group.getName(), panel, table3);
                continue;
            }
            this.addUiForGroup(group);
        }
        this.myCanvas.add((Component)new JLabel(" "), (Object)new GridBag().weighty(1.0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/editor/ui/GradleEditorComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addUiForGroup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

