/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.parser;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.BuildFileStatement;
import com.android.tools.idea.gradle.parser.BuildFileStatementFactory;
import com.android.tools.idea.gradle.parser.GradleGroovyFile;
import com.android.tools.idea.gradle.parser.UnparseableStatement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public class Repository
extends BuildFileStatement {
    public final String myUrl;
    public final Type myType;

    public static BuildFileStatement parse(@NotNull String s, @NotNull Project project) {
        String methodCallName;
        if (s == null) {
            Repository.$$$reportNull$$$0(0);
        }
        if (project == null) {
            Repository.$$$reportNull$$$0(1);
        }
        if ((methodCallName = s).endsWith("()")) {
            methodCallName = methodCallName.substring(0, methodCallName.length() - 2);
        }
        if (methodCallName.equalsIgnoreCase(Type.MAVEN_CENTRAL.getCallName())) {
            return new Repository(Type.MAVEN_CENTRAL, null);
        }
        if (methodCallName.equalsIgnoreCase(Type.MAVEN_LOCAL.getCallName())) {
            return new Repository(Type.MAVEN_LOCAL, null);
        }
        if (methodCallName.equalsIgnoreCase(Type.JCENTER.getCallName())) {
            return new Repository(Type.JCENTER, null);
        }
        if (methodCallName.equalsIgnoreCase(Type.URL.getCallName())) {
            return new Repository(Type.URL, s);
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return new Repository(Type.URL, s.substring(1, s.length() - 1));
        }
        if (s.indexOf(46) >= 0 && s.indexOf(123) == -1) {
            return new Repository(Type.URL, s);
        }
        return new UnparseableStatement(s, project);
    }

    public Repository(@NotNull Type type, @Nullable String url) {
        if (type == null) {
            Repository.$$$reportNull$$$0(2);
        }
        this.myType = type;
        this.myUrl = url;
    }

    @Override
    @NotNull
    public List<PsiElement> getGroovyElements(@NotNull GroovyPsiElementFactory factory) {
        String extraGroovyCode;
        if (factory == null) {
            Repository.$$$reportNull$$$0(3);
        }
        String callName = this.myType.getCallName();
        switch (this.myType) {
            default: {
                extraGroovyCode = "()";
                break;
            }
            case URL: {
                extraGroovyCode = " { url '" + BuildFileKey.escapeLiteralString(this.myUrl) + "' }";
            }
        }
        ImmutableList immutableList = ImmutableList.of((Object)factory.createStatementFromText((CharSequence)(callName + extraGroovyCode)));
        if (immutableList == null) {
            Repository.$$$reportNull$$$0(4);
        }
        return immutableList;
    }

    public String toString() {
        switch (this.myType) {
            case MAVEN_CENTRAL: 
            case MAVEN_LOCAL: 
            case JCENTER: {
                return this.myType.getCallName();
            }
            case URL: {
                return "'" + this.myUrl + "'";
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Repository that = (Repository)o;
        if (this.myType != that.myType) {
            return false;
        }
        return !(this.myUrl != null ? !this.myUrl.equals(that.myUrl) : that.myUrl != null);
    }

    public int hashCode() {
        int result2 = this.myUrl != null ? this.myUrl.hashCode() : 0;
        result2 = 31 * result2 + (this.myType != null ? this.myType.hashCode() : 0);
        return result2;
    }

    public static Factory getFactory() {
        return new Factory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/parser/Repository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/parser/Repository";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroovyElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getGroovyElements";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory
    extends BuildFileStatementFactory {
        @Override
        @Nullable
        public List<BuildFileStatement> getValues(@NotNull PsiElement statement) {
            if (statement == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (!(statement instanceof GrMethodCall)) {
                return Factory.getUnparseableStatements(statement);
            }
            GrMethodCall methodCall = (GrMethodCall)statement;
            ArrayList list = Lists.newArrayList();
            String callName = GradleGroovyFile.getMethodCallName(methodCall);
            if (Type.MAVEN_CENTRAL.getCallName().equals(callName)) {
                list.add(new Repository(Type.MAVEN_CENTRAL, null));
            } else if (Type.MAVEN_LOCAL.getCallName().equals(callName)) {
                list.add(new Repository(Type.MAVEN_LOCAL, null));
            } else if (Type.JCENTER.getCallName().equals(callName)) {
                list.add(new Repository(Type.JCENTER, null));
            } else if (Type.URL.getCallName().equals(callName)) {
                Iterable<Object> literals = GradleGroovyFile.getLiteralArgumentValues(methodCall);
                if (!Iterables.isEmpty(literals)) {
                    for (Object literal : literals) {
                        list.add(new Repository(Type.URL, literal.toString()));
                    }
                } else {
                    GrClosableBlock cc = GradleGroovyFile.getMethodClosureArgument(methodCall);
                    if (cc != null) {
                        Iterable<GrMethodCall> methodCalls = GradleGroovyFile.getMethodCalls((GrStatementOwner)cc);
                        Iterable<GrMethodCall> urlMethodCalls = GradleGroovyFile.getMethodCalls((GrStatementOwner)cc, "url");
                        if (Iterables.size(methodCalls) != Iterables.size(urlMethodCalls)) {
                            return Factory.getUnparseableStatements(statement);
                        }
                        for (GrMethodCall call : methodCalls) {
                            Iterable<Object> values2 = GradleGroovyFile.getLiteralArgumentValues(call);
                            for (Object value : values2) {
                                list.add(new Repository(Type.URL, value.toString()));
                            }
                        }
                    }
                }
                if (list.isEmpty()) {
                    return Factory.getUnparseableStatements(statement);
                }
            } else {
                return Factory.getUnparseableStatements(statement);
            }
            return list;
        }

        @Override
        @NotNull
        public BuildFileStatement parse(@NotNull String s, Project project) {
            if (s == null) {
                Factory.$$$reportNull$$$0(1);
            }
            BuildFileStatement buildFileStatement = Repository.parse(s, project);
            if (buildFileStatement == null) {
                Factory.$$$reportNull$$$0(2);
            }
            return buildFileStatement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/parser/Repository$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/parser/Repository$Factory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getValues";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "parse";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Type {
        MAVEN_CENTRAL("mavenCentral"),
        MAVEN_LOCAL("mavenLocal"),
        JCENTER("jcenter"),
        URL("maven");

        private final String myCallName;

        private Type(String callName) {
            this.myCallName = callName;
        }

        public String getCallName() {
            return this.myCallName;
        }
    }
}

