/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.parser;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.GradleGroovyFile;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public abstract class ValueFactory<E> {
    @NotNull
    public List<E> getValues(@NotNull GrStatementOwner closure) {
        if (closure == null) {
            ValueFactory.$$$reportNull$$$0(0);
        }
        ArrayList result2 = Lists.newArrayList();
        for (PsiElement element : closure.getChildren()) {
            List<E> values2 = this.getValues(element);
            if (values2 == null || values2.isEmpty()) continue;
            result2.addAll(values2);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            ValueFactory.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public void setValues(@NotNull GrStatementOwner closure, @NotNull List<E> values2, @Nullable KeyFilter filter2) {
        if (closure == null) {
            ValueFactory.$$$reportNull$$$0(2);
        }
        if (values2 == null) {
            ValueFactory.$$$reportNull$$$0(3);
        }
        for (E value : values2) {
            this.setValue(closure, value, filter2);
        }
        for (E existingValue : this.findValuesToDelete(closure, values2)) {
            this.removeValue(closure, existingValue);
        }
        GradleGroovyFile.reformatClosure(closure);
    }

    protected Iterable<E> findValuesToDelete(@NotNull GrStatementOwner closure, final @NotNull List<E> replacementValues) {
        if (closure == null) {
            ValueFactory.$$$reportNull$$$0(4);
        }
        if (replacementValues == null) {
            ValueFactory.$$$reportNull$$$0(5);
        }
        return Iterables.filter(this.getValues(closure), (Predicate)new Predicate<E>(){

            public boolean apply(E input) {
                return !replacementValues.contains(input);
            }
        });
    }

    @NotNull
    public E parse(@NotNull String s, Project project) {
        if (s == null) {
            ValueFactory.$$$reportNull$$$0(6);
        }
        throw new UnsupportedOperationException("parse not implemented");
    }

    protected abstract void setValue(@NotNull GrStatementOwner var1, @NotNull E var2, @Nullable KeyFilter var3);

    @Nullable
    protected abstract List<E> getValues(@NotNull PsiElement var1);

    protected void removeValue(@NotNull GrStatementOwner closure, @NotNull E value) {
        if (closure == null) {
            ValueFactory.$$$reportNull$$$0(7);
        }
        if (value == null) {
            ValueFactory.$$$reportNull$$$0(8);
        }
        throw new UnsupportedOperationException("removeValue not implemented");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/parser/ValueFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacementValues";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/parser/ValueFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setValues";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findValuesToDelete";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface KeyFilter {
        public boolean shouldWriteKey(BuildFileKey var1, Object var2);
    }
}

