/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.BaseArtifact;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.io.FilePaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.GradleOrderEnumeratorHandler;
import org.jetbrains.plugins.gradle.model.ExtIdeaCompilerOutput;

public class AndroidGradleOrderEnumeratorHandlerFactory
extends GradleOrderEnumeratorHandler.FactoryImpl {
    @NotNull
    private static final String CLASSES_FOLDER_NAME = "classes";
    @NotNull
    private static final String RESOURCES_FOLDER_NAME = "resources";
    @NotNull
    private static final String MAIN_FOLDER_NAME = "main";
    @NotNull
    private static final String TEST_FOLDER_NAME = "test";
    @NotNull
    private static final String KOTLIN_FOLDER_NAME = "kotlin";

    public boolean isApplicable(@NotNull Module module) {
        if (module == null) {
            AndroidGradleOrderEnumeratorHandlerFactory.$$$reportNull$$$0(0);
        }
        return IdeInfo.getInstance().isAndroidStudio() || AndroidModuleModel.get(module) != null;
    }

    public GradleOrderEnumeratorHandler createHandler(@NotNull Module module) {
        if (module == null) {
            AndroidGradleOrderEnumeratorHandlerFactory.$$$reportNull$$$0(1);
        }
        return new GradleOrderEnumeratorHandler(module){

            public boolean shouldAddRuntimeDependenciesToTestCompilationClasspath() {
                return false;
            }

            public boolean shouldIncludeTestsFromDependentModulesToTestClasspath() {
                return true;
            }

            public boolean shouldProcessDependenciesRecursively() {
                return true;
            }

            public boolean addCustomModuleRoots(@NotNull OrderRootType type, @NotNull ModuleRootModel rootModel, @NotNull Collection<String> result2, boolean includeProduction, boolean includeTests) {
                if (type == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (rootModel == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!type.equals((Object)OrderRootType.CLASSES)) {
                    return false;
                }
                AndroidModuleModel androidModel = AndroidModuleModel.get(rootModel.getModule());
                if (androidModel != null) {
                    result2.addAll(AndroidGradleOrderEnumeratorHandlerFactory.getAndroidCompilerOutputFolders(androidModel, includeProduction, includeTests));
                    super.addCustomModuleRoots(type, rootModel, result2, includeProduction, includeTests);
                    return true;
                }
                JavaModuleModel javaModel = JavaModuleModel.get(rootModel.getModule());
                if (javaModel != null) {
                    result2.addAll(AndroidGradleOrderEnumeratorHandlerFactory.getJavaCompilerOutputFolders(javaModel, includeProduction, includeTests));
                    result2.addAll(AndroidGradleOrderEnumeratorHandlerFactory.getKotlinCompilerOutputFolders(javaModel, includeProduction, includeTests));
                    super.addCustomModuleRoots(type, rootModel, result2, includeProduction, includeTests);
                    return true;
                }
                return super.addCustomModuleRoots(type, rootModel, result2, includeProduction, includeTests);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rootModel";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/gradle/project/AndroidGradleOrderEnumeratorHandlerFactory$1";
                objectArray[2] = "addCustomModuleRoots";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private static List<String> getAndroidCompilerOutputFolders(@NotNull AndroidModuleModel androidModel, boolean includeProduction, boolean includeTests) {
        if (androidModel == null) {
            AndroidGradleOrderEnumeratorHandlerFactory.$$$reportNull$$$0(2);
        }
        LinkedList<String> toAdd = new LinkedList<String>();
        if (includeProduction) {
            AndroidGradleOrderEnumeratorHandlerFactory.addFoldersFromArtifact((BaseArtifact)androidModel.getSelectedVariant().getMainArtifact(), toAdd);
        }
        if (includeTests && androidModel.getSelectedVariant().getUnitTestArtifact() != null) {
            AndroidGradleOrderEnumeratorHandlerFactory.addFoldersFromArtifact((BaseArtifact)androidModel.getSelectedVariant().getUnitTestArtifact(), toAdd);
        }
        if (includeTests && androidModel.getSelectedVariant().getAndroidTestArtifact() != null) {
            AndroidGradleOrderEnumeratorHandlerFactory.addFoldersFromArtifact((BaseArtifact)androidModel.getSelectedVariant().getAndroidTestArtifact(), toAdd);
        }
        LinkedList<String> linkedList = toAdd;
        if (linkedList == null) {
            AndroidGradleOrderEnumeratorHandlerFactory.$$$reportNull$$$0(3);
        }
        return linkedList;
    }

    private static void addFoldersFromArtifact(@NotNull BaseArtifact artifact, @NotNull List<String> toAdd) {
        if (artifact == null) {
            AndroidGradleOrderEnumeratorHandlerFactory.$$$reportNull$$$0(4);
        }
        if (toAdd == null) {
            AndroidGradleOrderEnumeratorHandlerFactory.$$$reportNull$$$0(5);
        }
        toAdd.add(FilePaths.pathToIdeaUrl((File)artifact.getClassesFolder()));
        artifact.getAdditionalClassesFolders().stream().filter(Objects::nonNull).map(FilePaths::pathToIdeaUrl).forEach(toAdd::add);
        toAdd.add(FilePaths.pathToIdeaUrl((File)artifact.getJavaResourcesFolder()));
        if (artifact instanceof AndroidArtifact) {
            ((AndroidArtifact)artifact).getGeneratedResourceFolders().stream().filter(Objects::nonNull).map(FilePaths::pathToIdeaUrl).forEach(toAdd::add);
        }
    }

    @NotNull
    private static Collection<String> getJavaCompilerOutputFolders(@NotNull JavaModuleModel javaModel, boolean includeProduction, boolean includeTests) {
        if (javaModel == null) {
            AndroidGradleOrderEnumeratorHandlerFactory.$$$reportNull$$$0(6);
        }
        LinkedList<String> toAdd = new LinkedList<String>();
        File mainClassesFolderPath = null;
        File mainResourcesFolderPath = null;
        File testClassesFolderPath = null;
        File testResourcesFolderPath = null;
        ExtIdeaCompilerOutput compilerOutput = javaModel.getCompilerOutput();
        if (compilerOutput != null) {
            mainClassesFolderPath = compilerOutput.getMainClassesDir();
            mainResourcesFolderPath = compilerOutput.getMainResourcesDir();
            testClassesFolderPath = compilerOutput.getTestClassesDir();
            testResourcesFolderPath = compilerOutput.getTestResourcesDir();
        }
        if (javaModel.isBuildable()) {
            File buildFolderPath = javaModel.getBuildFolderPath();
            if (mainClassesFolderPath == null) {
                mainClassesFolderPath = new File(buildFolderPath, FileUtil.join((String[])new String[]{CLASSES_FOLDER_NAME, MAIN_FOLDER_NAME}));
            }
            if (mainResourcesFolderPath == null) {
                mainResourcesFolderPath = new File(buildFolderPath, FileUtil.join((String[])new String[]{RESOURCES_FOLDER_NAME, MAIN_FOLDER_NAME}));
            }
            if (testClassesFolderPath == null) {
                testClassesFolderPath = new File(buildFolderPath, FileUtil.join((String[])new String[]{CLASSES_FOLDER_NAME, TEST_FOLDER_NAME}));
            }
            if (testResourcesFolderPath == null) {
                testResourcesFolderPath = new File(buildFolderPath, FileUtil.join((String[])new String[]{RESOURCES_FOLDER_NAME, TEST_FOLDER_NAME}));
            }
        }
        if (includeProduction && mainClassesFolderPath != null) {
            toAdd.add(FilePaths.pathToIdeaUrl((File)mainClassesFolderPath));
        }
        if (includeProduction && mainResourcesFolderPath != null) {
            toAdd.add(FilePaths.pathToIdeaUrl((File)mainResourcesFolderPath));
        }
        if (includeTests && testClassesFolderPath != null) {
            toAdd.add(FilePaths.pathToIdeaUrl((File)testClassesFolderPath));
        }
        if (includeTests && testResourcesFolderPath != null) {
            toAdd.add(FilePaths.pathToIdeaUrl((File)testResourcesFolderPath));
        }
        LinkedList<String> linkedList = toAdd;
        if (linkedList == null) {
            AndroidGradleOrderEnumeratorHandlerFactory.$$$reportNull$$$0(7);
        }
        return linkedList;
    }

    @NotNull
    private static Collection<String> getKotlinCompilerOutputFolders(@NotNull JavaModuleModel javaModel, boolean includeProduction, boolean includeTests) {
        if (javaModel == null) {
            AndroidGradleOrderEnumeratorHandlerFactory.$$$reportNull$$$0(8);
        }
        LinkedList<String> toAdd = new LinkedList<String>();
        File buildFolder = javaModel.getBuildFolderPath();
        if (buildFolder != null) {
            File kotlinClasses = buildFolder.toPath().resolve(CLASSES_FOLDER_NAME).resolve(KOTLIN_FOLDER_NAME).toFile();
            if (includeProduction) {
                toAdd.add(FilePaths.pathToIdeaUrl((File)new File(kotlinClasses, MAIN_FOLDER_NAME)));
            }
            if (includeTests) {
                toAdd.add(FilePaths.pathToIdeaUrl((File)new File(kotlinClasses, TEST_FOLDER_NAME)));
            }
        }
        LinkedList<String> linkedList = toAdd;
        if (linkedList == null) {
            AndroidGradleOrderEnumeratorHandlerFactory.$$$reportNull$$$0(9);
        }
        return linkedList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/AndroidGradleOrderEnumeratorHandlerFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAdd";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/AndroidGradleOrderEnumeratorHandlerFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidCompilerOutputFolders";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaCompilerOutputFolders";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getKotlinCompilerOutputFolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidCompilerOutputFolders";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addFoldersFromArtifact";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getJavaCompilerOutputFolders";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getKotlinCompilerOutputFolders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

