/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build;

import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.GradleTaskFinder;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.util.BuildMode;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import com.intellij.task.ProjectTaskRunner;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProjectTaskRunner
extends ProjectTaskRunner {
    public void run(@NotNull Project project, @NotNull ProjectTaskContext context, @Nullable ProjectTaskNotification callback, @NotNull Collection<? extends ProjectTask> tasks) {
        if (project == null) {
            AndroidProjectTaskRunner.$$$reportNull$$$0(0);
        }
        if (context == null) {
            AndroidProjectTaskRunner.$$$reportNull$$$0(1);
        }
        if (tasks == null) {
            AndroidProjectTaskRunner.$$$reportNull$$$0(2);
        }
        Map moduleBuildTasksMap = StreamEx.of(tasks).select(ModuleBuildTask.class).partitioningBy(task -> task.isIncrementalBuild());
        MergedProjectTaskNotification aggregatedCallback = callback == null ? null : new MergedProjectTaskNotification(callback, 2);
        this.executeTasks(project, BuildMode.REBUILD, (List)moduleBuildTasksMap.get(Boolean.FALSE), aggregatedCallback);
        this.executeTasks(project, BuildMode.COMPILE_JAVA, (List)moduleBuildTasksMap.get(Boolean.TRUE), aggregatedCallback);
    }

    public boolean canRun(@NotNull ProjectTask projectTask) {
        Module module;
        if (projectTask == null) {
            AndroidProjectTaskRunner.$$$reportNull$$$0(3);
        }
        return projectTask instanceof ModuleBuildTask && (GradleFacet.getInstance(module = ((ModuleBuildTask)projectTask).getModule()) != null || JavaFacet.getInstance(module) != null);
    }

    private void executeTasks(@NotNull Project project, @NotNull BuildMode buildMode, List<ModuleBuildTask> moduleBuildTasks, @Nullable ProjectTaskNotification callback) {
        Module[] modules;
        if (project == null) {
            AndroidProjectTaskRunner.$$$reportNull$$$0(4);
        }
        if (buildMode == null) {
            AndroidProjectTaskRunner.$$$reportNull$$$0(5);
        }
        if ((modules = (Module[])moduleBuildTasks.stream().map(task -> task.getModule()).toArray(Module[]::new)) == null || modules.length == 0) {
            if (callback != null) {
                callback.finished(new ProjectTaskResult(false, 0, 0));
            }
            return;
        }
        String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)modules[0]);
        if (rootProjectPath == null) {
            if (callback != null) {
                callback.finished(new ProjectTaskResult(false, 1, 0));
            }
            return;
        }
        File projectPath = new File(rootProjectPath);
        String projectName = projectPath.isFile() ? projectPath.getParentFile().getName() : projectPath.getName();
        String executionName = "Build " + projectName;
        ListMultimap<Path, String> tasks = GradleTaskFinder.getInstance().findTasksToExecute(projectPath, modules, buildMode, TestCompileType.NONE);
        GradleBuildInvoker gradleBuildInvoker = GradleBuildInvoker.getInstance(project);
        Set rootPaths = tasks.keys().elementSet();
        final MergedProjectTaskNotification aggregatedCallback = callback == null ? null : new MergedProjectTaskNotification(callback, rootPaths.size());
        for (Path projectRootPath : rootPaths) {
            GradleBuildInvoker.Request request = new GradleBuildInvoker.Request(project, projectRootPath.toFile(), tasks.get((Object)projectRootPath));
            BuildSettings.getInstance(project).setBuildMode(buildMode);
            request.waitForCompletion();
            ExternalSystemTaskNotificationListener buildTaskListener = gradleBuildInvoker.createBuildTaskListener(request, executionName);
            Object listenerDelegate = aggregatedCallback == null ? buildTaskListener : new ExternalSystemTaskNotificationListenerAdapter(buildTaskListener){

                public void onSuccess(@NotNull ExternalSystemTaskId id) {
                    if (id == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.onSuccess(id);
                    aggregatedCallback.finished(new ProjectTaskResult(false, 0, 0));
                }

                public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception e) {
                    if (id == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (e == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    super.onFailure(id, e);
                    aggregatedCallback.finished(new ProjectTaskResult(false, 1, 0));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "id";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "e";
                            break;
                        }
                    }
                    objectArray2[1] = "com/android/tools/idea/gradle/project/build/AndroidProjectTaskRunner$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onSuccess";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onFailure";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            request.setTaskListener((ExternalSystemTaskNotificationListener)listenerDelegate);
            gradleBuildInvoker.executeTasks(request);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTask";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildMode";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/build/AndroidProjectTaskRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "executeTasks";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MergedProjectTaskNotification
    implements ProjectTaskNotification {
        private final ProjectTaskNotification myCallback;
        private final AtomicInteger myResultsCounter = new AtomicInteger(0);
        private final int myExpectedResults;
        private boolean myAborted;
        private int myErrors;
        private int myWarnings;

        public MergedProjectTaskNotification(ProjectTaskNotification callback, int expectedResults) {
            this.myCallback = callback;
            this.myExpectedResults = expectedResults;
        }

        public void finished(@NotNull ProjectTaskResult executionResult) {
            if (executionResult == null) {
                MergedProjectTaskNotification.$$$reportNull$$$0(0);
            }
            int finished = this.myResultsCounter.incrementAndGet();
            if (executionResult.isAborted()) {
                this.myAborted = true;
            }
            this.myErrors += executionResult.getErrors();
            this.myWarnings += executionResult.getWarnings();
            if (finished == this.myExpectedResults) {
                this.myCallback.finished(new ProjectTaskResult(this.myAborted, this.myErrors, this.myWarnings));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionResult", "com/android/tools/idea/gradle/project/build/AndroidProjectTaskRunner$MergedProjectTaskNotification", "finished"));
        }
    }
}

