/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker.messages;

import com.android.tools.idea.gradle.project.build.invoker.messages.GradleBuildTreeViewConfiguration;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorViewStructure;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.ide.errorTreeView.SimpleMessageElement;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleBuildTreeStructure
extends ErrorViewStructure {
    private final List<ErrorTreeElement> myMessages;
    private final ListMultimap<ErrorTreeElementKind, ErrorTreeElement> myMessagesByType;
    private final ListMultimap<String, NavigatableMessageElement> myGroupNameToMessagesMap;
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleBuildTreeViewConfiguration myConfiguration;

    GradleBuildTreeStructure(@NotNull Project project, @NotNull GradleBuildTreeViewConfiguration configuration) {
        if (project == null) {
            GradleBuildTreeStructure.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            GradleBuildTreeStructure.$$$reportNull$$$0(1);
        }
        super(project, false);
        this.myMessages = Lists.newCopyOnWriteArrayList();
        this.myMessagesByType = ArrayListMultimap.create();
        this.myGroupNameToMessagesMap = ArrayListMultimap.create();
        this.myProject = project;
        this.myConfiguration = configuration;
    }

    @Nullable
    public ErrorTreeElement getFirstMessage(@NotNull ErrorTreeElementKind kind) {
        List elements;
        if (kind == null) {
            GradleBuildTreeStructure.$$$reportNull$$$0(2);
        }
        return (elements = this.myMessagesByType.get((Object)kind)).isEmpty() ? null : (ErrorTreeElement)elements.get(0);
    }

    public int getChildCount(GroupingElement groupingElement) {
        return this.myGroupNameToMessagesMap.get((Object)groupingElement.getName()).size();
    }

    public ErrorTreeElement[] getChildElements(Object element) {
        if (element instanceof ErrorTreeElement && element.getClass().getName().contains("MyRootElement")) {
            ArrayList messages = Lists.newArrayListWithExpectedSize((int)this.myMessages.size());
            for (ErrorTreeElement message : this.myMessages) {
                if (!this.canShow(message)) continue;
                messages.add(message);
            }
            return messages.toArray(ErrorTreeElement.EMPTY_ARRAY);
        }
        if (element instanceof GroupingElement) {
            List children = this.myGroupNameToMessagesMap.get((Object)((GroupingElement)element).getName());
            ArrayList messages = Lists.newArrayListWithExpectedSize((int)children.size());
            for (NavigatableMessageElement message : children) {
                if (!this.canShow((ErrorTreeElement)message)) continue;
                messages.add(message);
            }
            return messages.toArray(ErrorTreeElement.EMPTY_ARRAY);
        }
        return ErrorTreeElement.EMPTY_ARRAY;
    }

    private boolean canShow(@NotNull ErrorTreeElement element) {
        if (element == null) {
            GradleBuildTreeStructure.$$$reportNull$$$0(3);
        }
        if (element instanceof GroupingElement) {
            List children = this.myGroupNameToMessagesMap.get((Object)((GroupingElement)element).getName());
            for (NavigatableMessageElement child : children) {
                if (!this.canShow((ErrorTreeElement)child)) continue;
                return true;
            }
            return false;
        }
        return this.myConfiguration.canShow(element.getKind());
    }

    public void addMessage(@NotNull ErrorTreeElementKind kind, @NotNull String[] text, @Nullable VirtualFile underFileGroup, @Nullable VirtualFile file, int line, int column, @Nullable Object data) {
        if (kind == null) {
            GradleBuildTreeStructure.$$$reportNull$$$0(4);
        }
        if (text == null) {
            GradleBuildTreeStructure.$$$reportNull$$$0(5);
        }
        if (underFileGroup != null || file != null) {
            if (file == null) {
                column = -1;
                line = -1;
            }
            int uiLine = line < 0 ? -1 : line + 1;
            int uiColumn = column < 0 ? -1 : column + 1;
            VirtualFile group = underFileGroup != null ? underFileGroup : file;
            VirtualFile nav = file != null ? file : underFileGroup;
            this.addNavigatableMessage(group.getPresentableUrl(), (Navigatable)new OpenFileDescriptor(this.myProject, nav, line, column), kind, text, data, NewErrorTreeViewPanel.createExportPrefix((int)uiLine), NewErrorTreeViewPanel.createRendererPrefix((int)uiLine, (int)uiColumn), group);
            return;
        }
        this.addSimpleMessage(kind, text, data);
    }

    public void addNavigatableMessage(@Nullable String groupName, @Nullable Navigatable navigatable, @NotNull ErrorTreeElementKind kind, @NotNull String[] message, @Nullable Object data, @NotNull String exportText, @NotNull String rendererTextPrefix, @Nullable VirtualFile file) {
        if (kind == null) {
            GradleBuildTreeStructure.$$$reportNull$$$0(6);
        }
        if (message == null) {
            GradleBuildTreeStructure.$$$reportNull$$$0(7);
        }
        if (exportText == null) {
            GradleBuildTreeStructure.$$$reportNull$$$0(8);
        }
        if (rendererTextPrefix == null) {
            GradleBuildTreeStructure.$$$reportNull$$$0(9);
        }
        if (groupName != null) {
            GroupingElement grouping = this.getGroupingElement(groupName, data, file);
            NavigatableMessageElement e = new NavigatableMessageElement(kind, grouping, message, navigatable, exportText, rendererTextPrefix);
            this.myMessagesByType.put((Object)kind, (Object)e);
            this.myGroupNameToMessagesMap.put((Object)groupName, (Object)e);
            this.myMessages.add((ErrorTreeElement)grouping);
            return;
        }
        this.myMessages.add((ErrorTreeElement)new NavigatableMessageElement(kind, null, message, navigatable, exportText, rendererTextPrefix));
    }

    private void addSimpleMessage(@NotNull ErrorTreeElementKind kind, @NotNull String[] text, @Nullable Object data) {
        if (kind == null) {
            GradleBuildTreeStructure.$$$reportNull$$$0(10);
        }
        if (text == null) {
            GradleBuildTreeStructure.$$$reportNull$$$0(11);
        }
        SimpleMessageElement element = new SimpleMessageElement(kind, text, data);
        this.myMessagesByType.put((Object)kind, (Object)element);
        this.myMessages.add((ErrorTreeElement)element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportText";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rendererTextPrefix";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/messages/GradleBuildTreeStructure";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getFirstMessage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canShow";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addMessage";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addNavigatableMessage";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "addSimpleMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

