/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.output;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageJsonSerializer;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.intellij.build.FilePosition;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleBuildOutputParser
implements BuildOutputParser {
    private static final Logger LOG = Logger.getInstance(GradleBuildOutputParser.class);
    private static final String MESSAGES_GROUP = "Android errors";
    static final String END_DETAIL = "* Try:";
    @NotNull
    private ArrayList<String> myBufferedLines = new ArrayList();
    @Nullable
    private Object myBuildId;

    public boolean parse(@NotNull String line, @NotNull BuildOutputInstantReader reader, @NotNull Consumer<MessageEvent> messageConsumer) {
        if (line == null) {
            GradleBuildOutputParser.$$$reportNull$$$0(0);
        }
        if (reader == null) {
            GradleBuildOutputParser.$$$reportNull$$$0(1);
        }
        if (messageConsumer == null) {
            GradleBuildOutputParser.$$$reportNull$$$0(2);
        }
        if (reader.getBuildId() != this.myBuildId) {
            this.myBufferedLines.clear();
            this.myBuildId = null;
        }
        if (line.startsWith("AGPBI: ")) {
            this.myBuildId = reader.getBuildId();
            this.myBufferedLines.clear();
            this.myBufferedLines.add(line);
        } else {
            if (line.equals(END_DETAIL)) {
                if (this.myBuildId != null) {
                    this.processMessage(messageConsumer);
                }
                this.myBuildId = null;
                this.myBufferedLines.clear();
                return true;
            }
            if (this.myBuildId != null) {
                this.myBufferedLines.add(line);
            }
        }
        return false;
    }

    private void processMessage(@NotNull Consumer<MessageEvent> messageConsumer) {
        if (messageConsumer == null) {
            GradleBuildOutputParser.$$$reportNull$$$0(3);
        }
        assert (this.myBuildId != null);
        String line = this.myBufferedLines.get(0);
        String jsonString = line.substring("AGPBI: ".length()).trim();
        if (jsonString.isEmpty()) {
            return;
        }
        String detailMessage = StringUtil.join(this.myBufferedLines, (String)SystemProperties.getLineSeparator());
        GsonBuilder gsonBuilder = new GsonBuilder();
        MessageJsonSerializer.registerTypeAdapters((GsonBuilder)gsonBuilder);
        Gson gson = gsonBuilder.create();
        try {
            Message msg = (Message)gson.fromJson(jsonString, Message.class);
            boolean validPosition = false;
            for (SourceFilePosition sourceFilePosition : msg.getSourceFilePositions()) {
                FilePosition filePosition = GradleBuildOutputParser.convertToFilePosition(sourceFilePosition);
                if (filePosition == null) continue;
                validPosition = true;
                messageConsumer.accept((MessageEvent)new FileMessageEventImpl(this.myBuildId, GradleBuildOutputParser.convertKind(msg.getKind()), MESSAGES_GROUP, msg.getText(), detailMessage, filePosition));
            }
            if (!validPosition) {
                messageConsumer.accept((MessageEvent)new MessageEventImpl(this.myBuildId, GradleBuildOutputParser.convertKind(msg.getKind()), MESSAGES_GROUP, msg.getText(), detailMessage));
            }
        }
        catch (JsonParseException ignored) {
            messageConsumer.accept((MessageEvent)new MessageEventImpl(this.myBuildId, MessageEvent.Kind.WARNING, MESSAGES_GROUP, line, detailMessage));
        }
    }

    @Contract(pure=true)
    @NotNull
    private static MessageEvent.Kind convertKind(@NotNull Message.Kind kind) {
        if (kind == null) {
            GradleBuildOutputParser.$$$reportNull$$$0(4);
        }
        switch (kind) {
            case ERROR: {
                MessageEvent.Kind kind2 = MessageEvent.Kind.ERROR;
                if (kind2 == null) {
                    GradleBuildOutputParser.$$$reportNull$$$0(5);
                }
                return kind2;
            }
            case WARNING: {
                MessageEvent.Kind kind3 = MessageEvent.Kind.WARNING;
                if (kind3 == null) {
                    GradleBuildOutputParser.$$$reportNull$$$0(6);
                }
                return kind3;
            }
            case INFO: {
                MessageEvent.Kind kind4 = MessageEvent.Kind.INFO;
                if (kind4 == null) {
                    GradleBuildOutputParser.$$$reportNull$$$0(7);
                }
                return kind4;
            }
            case STATISTICS: {
                MessageEvent.Kind kind5 = MessageEvent.Kind.STATISTICS;
                if (kind5 == null) {
                    GradleBuildOutputParser.$$$reportNull$$$0(8);
                }
                return kind5;
            }
            case UNKNOWN: {
                MessageEvent.Kind kind6 = MessageEvent.Kind.ERROR;
                if (kind6 == null) {
                    GradleBuildOutputParser.$$$reportNull$$$0(9);
                }
                return kind6;
            }
            case SIMPLE: {
                MessageEvent.Kind kind7 = MessageEvent.Kind.SIMPLE;
                if (kind7 == null) {
                    GradleBuildOutputParser.$$$reportNull$$$0(10);
                }
                return kind7;
            }
        }
        MessageEvent.Kind kind8 = MessageEvent.Kind.ERROR;
        if (kind8 == null) {
            GradleBuildOutputParser.$$$reportNull$$$0(11);
        }
        return kind8;
    }

    @Nullable
    private static FilePosition convertToFilePosition(@NotNull SourceFilePosition sourceFilePosition) {
        File sourceFile;
        if (sourceFilePosition == null) {
            GradleBuildOutputParser.$$$reportNull$$$0(12);
        }
        if ((sourceFile = sourceFilePosition.getFile().getSourceFile()) == null) {
            return null;
        }
        SourcePosition position = sourceFilePosition.getPosition();
        int startLine = position.getStartLine();
        int endLine = position.getEndLine();
        int startColumn = position.getStartColumn();
        int endColumn = position.getEndColumn();
        return new FilePosition(sourceFile, startLine, startColumn, endLine, endColumn);
    }

    boolean processingMessage() {
        return this.myBuildId != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageConsumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/build/output/GradleBuildOutputParser";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFilePosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/build/output/GradleBuildOutputParser";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "convertKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processMessage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertKind";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "convertToFilePosition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

