/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.importing;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.importing.NewProjectSetup;
import com.android.tools.idea.gradle.project.importing.ProjectFolder;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.SdkSync;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.util.ToolWindows;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class GradleProjectImporter {
    @NotNull
    private final SdkSync mySdkSync;
    @NotNull
    private final GradleSyncInvoker myGradleSyncInvoker;
    @NotNull
    private final NewProjectSetup myNewProjectSetup;
    @NotNull
    private final ProjectFolder.Factory myProjectFolderFactory;
    public static boolean ourSkipSetupFromTest;

    @NotNull
    public static GradleProjectImporter getInstance() {
        GradleProjectImporter gradleProjectImporter = (GradleProjectImporter)ServiceManager.getService(GradleProjectImporter.class);
        if (gradleProjectImporter == null) {
            GradleProjectImporter.$$$reportNull$$$0(0);
        }
        return gradleProjectImporter;
    }

    public GradleProjectImporter(@NotNull SdkSync sdkSync, @NotNull GradleSyncInvoker gradleSyncInvoker) {
        if (sdkSync == null) {
            GradleProjectImporter.$$$reportNull$$$0(1);
        }
        if (gradleSyncInvoker == null) {
            GradleProjectImporter.$$$reportNull$$$0(2);
        }
        this(sdkSync, gradleSyncInvoker, new NewProjectSetup(), new ProjectFolder.Factory());
    }

    @VisibleForTesting
    GradleProjectImporter(@NotNull SdkSync sdkSync, @NotNull GradleSyncInvoker gradleSyncInvoker, @NotNull NewProjectSetup newProjectSetup, @NotNull ProjectFolder.Factory projectFolderFactory) {
        if (sdkSync == null) {
            GradleProjectImporter.$$$reportNull$$$0(3);
        }
        if (gradleSyncInvoker == null) {
            GradleProjectImporter.$$$reportNull$$$0(4);
        }
        if (newProjectSetup == null) {
            GradleProjectImporter.$$$reportNull$$$0(5);
        }
        if (projectFolderFactory == null) {
            GradleProjectImporter.$$$reportNull$$$0(6);
        }
        this.mySdkSync = sdkSync;
        this.myGradleSyncInvoker = gradleSyncInvoker;
        this.myNewProjectSetup = newProjectSetup;
        this.myProjectFolderFactory = projectFolderFactory;
    }

    public void openProject(@NotNull VirtualFile selectedFile) {
        if (selectedFile == null) {
            GradleProjectImporter.$$$reportNull$$$0(7);
        }
        this.openOrImportProject(selectedFile, true);
    }

    public void importProject(@NotNull VirtualFile selectedFile) {
        if (selectedFile == null) {
            GradleProjectImporter.$$$reportNull$$$0(8);
        }
        this.openOrImportProject(selectedFile, false);
    }

    private void openOrImportProject(@NotNull VirtualFile selectedFile, boolean openProject) {
        if (selectedFile == null) {
            GradleProjectImporter.$$$reportNull$$$0(9);
        }
        VirtualFile projectFolder = GradleProjectImporter.findProjectFolder(selectedFile);
        File projectFolderPath = VfsUtilCore.virtualToIoFile((VirtualFile)projectFolder);
        try {
            this.setUpLocalProperties(projectFolderPath);
        }
        catch (IOException e) {
            return;
        }
        try {
            String projectName = projectFolder.getName();
            this.openOrImportProject(projectName, projectFolderPath, Request.EMPTY_REQUEST, GradleProjectImporter.createNewProjectListener(projectFolder), openProject);
        }
        catch (Throwable e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ExceptionUtil.rethrowUnchecked((Throwable)e);
            }
            Messages.showErrorDialog((String)e.getMessage(), (String)(openProject ? "Open Project" : "Project Import"));
            this.getLogger().error(e);
        }
    }

    @NotNull
    private static VirtualFile findProjectFolder(@NotNull VirtualFile selectedFile) {
        if (selectedFile == null) {
            GradleProjectImporter.$$$reportNull$$$0(10);
        }
        VirtualFile virtualFile = selectedFile.isDirectory() ? selectedFile : selectedFile.getParent();
        if (virtualFile == null) {
            GradleProjectImporter.$$$reportNull$$$0(11);
        }
        return virtualFile;
    }

    private void setUpLocalProperties(@NotNull File projectFolderPath) throws IOException {
        if (projectFolderPath == null) {
            GradleProjectImporter.$$$reportNull$$$0(12);
        }
        try {
            LocalProperties localProperties = new LocalProperties(projectFolderPath);
            if (IdeInfo.getInstance().isAndroidStudio()) {
                this.mySdkSync.syncIdeAndProjectAndroidSdks(localProperties);
            }
        }
        catch (IOException e) {
            this.getLogger().info("Failed to sync SDKs", (Throwable)e);
            Messages.showErrorDialog((String)e.getMessage(), (String)"Project Import");
            throw e;
        }
    }

    @NotNull
    private Logger getLogger() {
        Logger logger = Logger.getInstance(this.getClass());
        if (logger == null) {
            GradleProjectImporter.$$$reportNull$$$0(13);
        }
        return logger;
    }

    @NotNull
    private static GradleSyncListener createNewProjectListener(final @NotNull VirtualFile projectFolder) {
        if (projectFolder == null) {
            GradleProjectImporter.$$$reportNull$$$0(14);
        }
        GradleSyncListener gradleSyncListener = new GradleSyncListener(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                TransactionGuard.getInstance().submitTransactionLater((Disposable)project, () -> {
                    if (project == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (projectFolder == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    FileChooserUtil.setLastOpenedFile((Project)project, (VirtualFile)projectFolder);
                    ProjectUtil.focusProjectWindow((Project)project, (boolean)false);
                    ToolWindows.activateProjectView(project);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "projectFolder";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/gradle/project/importing/GradleProjectImporter$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncSucceeded";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$syncSucceeded$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (gradleSyncListener == null) {
            GradleProjectImporter.$$$reportNull$$$0(15);
        }
        return gradleSyncListener;
    }

    public void importProject(@NotNull String projectName, @NotNull File projectFolderPath, @Nullable GradleSyncListener listener2) throws IOException {
        if (projectName == null) {
            GradleProjectImporter.$$$reportNull$$$0(16);
        }
        if (projectFolderPath == null) {
            GradleProjectImporter.$$$reportNull$$$0(17);
        }
        this.importProject(projectName, projectFolderPath, Request.EMPTY_REQUEST, listener2);
    }

    public void importProject(@NotNull String projectName, @NotNull File projectFolderPath, @NotNull Request request, @Nullable GradleSyncListener listener2) throws IOException {
        if (projectName == null) {
            GradleProjectImporter.$$$reportNull$$$0(18);
        }
        if (projectFolderPath == null) {
            GradleProjectImporter.$$$reportNull$$$0(19);
        }
        if (request == null) {
            GradleProjectImporter.$$$reportNull$$$0(20);
        }
        this.openOrImportProject(projectName, projectFolderPath, request, listener2, false);
    }

    private void openOrImportProject(@NotNull String projectName, @NotNull File projectFolderPath, @NotNull Request request, @Nullable GradleSyncListener listener2, boolean openProject) throws IOException {
        if (projectName == null) {
            GradleProjectImporter.$$$reportNull$$$0(21);
        }
        if (projectFolderPath == null) {
            GradleProjectImporter.$$$reportNull$$$0(22);
        }
        if (request == null) {
            GradleProjectImporter.$$$reportNull$$$0(23);
        }
        ProjectFolder projectFolder = this.myProjectFolderFactory.create(projectFolderPath);
        projectFolder.createTopLevelBuildFile();
        projectFolder.createIdeaProjectFolder();
        Project newProject = request.project;
        if (newProject == null) {
            newProject = openProject ? this.myNewProjectSetup.openProject(projectFolderPath.getPath()) : this.myNewProjectSetup.createProject(projectName, projectFolderPath.getPath());
            GradleSettings gradleSettings = GradleSettings.getInstance((Project)newProject);
            gradleSettings.setGradleVmOptions("");
            String externalProjectPath = ExternalSystemApiUtil.toCanonicalPath((String)projectFolderPath.getPath());
            GradleProjectSettings projectSettings = (GradleProjectSettings)gradleSettings.getLinkedProjectSettings(externalProjectPath);
            if (projectSettings == null) {
                HashSet projects = ContainerUtilRt.newHashSet((Iterable)gradleSettings.getLinkedProjectsSettings());
                projectSettings = new GradleProjectSettings();
                projectSettings.setExternalProjectPath(externalProjectPath);
                projects.add(projectSettings);
                gradleSettings.setLinkedProjectsSettings((Collection)projects);
            }
        }
        GradleProjectInfo projectInfo = GradleProjectInfo.getInstance(newProject);
        projectInfo.setNewProject(request.isNewProject);
        projectInfo.setImportedProject(true);
        this.myNewProjectSetup.prepareProjectForImport(newProject, request.javaLanguageLevel, openProject);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            newProject.save();
        }
        this.myGradleSyncInvoker.requestProjectSync(newProject, GradleProjectImporter.createSyncRequestSettings(request), listener2);
    }

    @NotNull
    private static GradleSyncInvoker.Request createSyncRequestSettings(@NotNull Request importProjectRequest) {
        if (importProjectRequest == null) {
            GradleProjectImporter.$$$reportNull$$$0(24);
        }
        GradleSyncInvoker.Request request = GradleSyncInvoker.Request.projectLoaded();
        request.generateSourcesOnSuccess = importProjectRequest.generateSourcesOnSuccess;
        request.useCachedGradleModels = false;
        GradleSyncInvoker.Request request2 = request;
        if (request2 == null) {
            GradleProjectImporter.$$$reportNull$$$0(25);
        }
        return request2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/importing/GradleProjectImporter";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkSync";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleSyncInvoker";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newProjectSetup";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFolderFactory";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFile";
                break;
            }
            case 12: 
            case 17: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFolderPath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFolder";
                break;
            }
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importProjectRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/importing/GradleProjectImporter";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findProjectFolder";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewProjectListener";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createSyncRequestSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "openProject";
                break;
            }
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "importProject";
                break;
            }
            case 9: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "openOrImportProject";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findProjectFolder";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setUpLocalProperties";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createNewProjectListener";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createSyncRequestSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Request {
        @NotNull
        private static final Request EMPTY_REQUEST = new Request();
        @Nullable
        public Project project;
        @Nullable
        public LanguageLevel javaLanguageLevel;
        public boolean generateSourcesOnSuccess = true;
        public boolean isNewProject;
    }
}

