/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.importing;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.importing.TopLevelModuleFactory;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.util.ToolWindows;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypeService;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewProjectSetup {
    public static final ProjectType ANDROID_PROJECT_TYPE = new ProjectType("Android");
    @NotNull
    private final TopLevelModuleFactory myTopLevelModuleFactory;

    public NewProjectSetup() {
        this(new TopLevelModuleFactory(IdeInfo.getInstance(), IdeSdks.getInstance()));
    }

    @VisibleForTesting
    NewProjectSetup(@NotNull TopLevelModuleFactory topLevelModuleFactory) {
        if (topLevelModuleFactory == null) {
            NewProjectSetup.$$$reportNull$$$0(0);
        }
        this.myTopLevelModuleFactory = topLevelModuleFactory;
    }

    @NotNull
    public Project createProject(@NotNull String projectName, @NotNull String projectPath) {
        ProjectManager projectManager;
        Project newProject;
        if (projectName == null) {
            NewProjectSetup.$$$reportNull$$$0(1);
        }
        if (projectPath == null) {
            NewProjectSetup.$$$reportNull$$$0(2);
        }
        if ((newProject = (projectManager = ProjectManager.getInstance()).createProject(projectName, projectPath)) == null) {
            throw new NullPointerException("Failed to create a new project");
        }
        Project project = newProject;
        if (project == null) {
            NewProjectSetup.$$$reportNull$$$0(3);
        }
        return project;
    }

    @NotNull
    Project openProject(@NotNull String projectPath) throws IOException {
        ProjectManagerEx projectManager;
        Project newProject;
        if (projectPath == null) {
            NewProjectSetup.$$$reportNull$$$0(4);
        }
        if ((newProject = (projectManager = ProjectManagerEx.getInstanceEx()).loadProject(projectPath)) == null) {
            throw new NullPointerException("Failed to open project at '" + projectPath + "'");
        }
        Project project = newProject;
        if (project == null) {
            NewProjectSetup.$$$reportNull$$$0(5);
        }
        return project;
    }

    void prepareProjectForImport(@NotNull Project project, @Nullable LanguageLevel languageLevel, boolean openProject) {
        if (project == null) {
            NewProjectSetup.$$$reportNull$$$0(6);
        }
        this.openProjectAndActivateProjectView(project, openProject);
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (project == null) {
                NewProjectSetup.$$$reportNull$$$0(9);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                LanguageLevelProjectExtension extension;
                if (project == null) {
                    NewProjectSetup.$$$reportNull$$$0(10);
                }
                if (languageLevel != null && (extension = LanguageLevelProjectExtension.getInstance((Project)project)) != null) {
                    extension.setLanguageLevel(languageLevel);
                }
                File compilerOutputFolderPath = new File(Projects.getBaseDirPath((Project)project), FileUtil.join((String[])new String[]{"build", "classes"}));
                String compilerOutputFolderUrl = FilePaths.pathToIdeaUrl((File)compilerOutputFolderPath);
                CompilerProjectExtension compilerProjectExt = CompilerProjectExtension.getInstance((Project)project);
                assert (compilerProjectExt != null);
                compilerProjectExt.setCompilerOutputUrl(compilerOutputFolderUrl);
                ProjectTypeService.setProjectType((Project)project, (ProjectType)ANDROID_PROJECT_TYPE);
            });
        }, null, null);
    }

    private void openProjectAndActivateProjectView(@NotNull Project project, boolean openProject) {
        if (project == null) {
            NewProjectSetup.$$$reportNull$$$0(7);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (!openProject) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    NewProjectSetup.$$$reportNull$$$0(8);
                }
                this.myTopLevelModuleFactory.createTopLevelModule(project);
            });
        }
        GradleProjects.open(project);
        ToolWindows.activateProjectView(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelModuleFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/importing/NewProjectSetup";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/importing/NewProjectSetup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "openProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createProject";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "openProject";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "prepareProjectForImport";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "openProjectAndActivateProjectView";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$openProjectAndActivateProjectView$2";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$prepareProjectForImport$1";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

