/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.importing;

import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class ProjectFolder {
    public abstract void createTopLevelBuildFile() throws IOException;

    public abstract void createIdeaProjectFolder() throws IOException;

    public static void deleteLibrariesFolder(@NotNull File projectFolder) {
        File librariesFolderPath;
        File ideaFolderPath;
        if (projectFolder == null) {
            ProjectFolder.$$$reportNull$$$0(0);
        }
        if ((ideaFolderPath = new File(projectFolder, ".idea")).isDirectory() && (librariesFolderPath = new File(ideaFolderPath, "libraries")).exists() && !FileUtil.delete((File)librariesFolderPath)) {
            Logger.getInstance(ProjectFolder.class).info(String.format("Failed to delete %1$s'", librariesFolderPath.getPath()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectFolder", "com/android/tools/idea/gradle/project/importing/ProjectFolder", "deleteLibrariesFolder"));
    }

    @VisibleForTesting
    static class ProjectFolderImpl
    extends ProjectFolder {
        @NotNull
        private final File myPath;

        ProjectFolderImpl(@NotNull File path) {
            if (path == null) {
                ProjectFolderImpl.$$$reportNull$$$0(0);
            }
            this.myPath = path;
        }

        @Override
        public void createTopLevelBuildFile() throws IOException {
            File buildFile = GradleUtil.getGradleBuildFilePath(this.myPath);
            if (buildFile.isFile()) {
                return;
            }
            FileUtilRt.createIfNotExists((File)buildFile);
            String contents = "// Top-level build file where you can add configuration options common to all sub-projects/modules." + SystemProperties.getLineSeparator();
            FileUtil.writeToFile((File)buildFile, (String)contents);
        }

        @Override
        public void createIdeaProjectFolder() throws IOException {
            ProjectFolderImpl.deleteLibrariesFolder(this.myPath);
            File ideaFolderPath = new File(this.myPath, ".idea");
            FileUtil.ensureExists((File)ideaFolderPath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/project/importing/ProjectFolder$ProjectFolderImpl", "<init>"));
        }
    }

    public static class Factory {
        @NotNull
        public ProjectFolder create(@NotNull File projectFolderPath) {
            if (projectFolderPath == null) {
                Factory.$$$reportNull$$$0(0);
            }
            ProjectFolderImpl projectFolderImpl = new ProjectFolderImpl(projectFolderPath);
            if (projectFolderImpl == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return projectFolderImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectFolderPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/importing/ProjectFolder$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/importing/ProjectFolder$Factory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

