/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.builder.model.AaptOptions;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaCompileOptions;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.android.builder.model.SyncIssue;
import com.android.builder.model.TestOptions;
import com.android.builder.model.Variant;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeAndroidProjectImpl;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.gradle.model.level2.IdeDependencies;
import com.android.ide.common.gradle.model.level2.IdeDependenciesFactory;
import com.android.ide.common.repository.GradleVersion;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.databinding.DataBindingMode;
import com.android.tools.idea.gradle.AndroidGradleClassJarProvider;
import com.android.tools.idea.gradle.project.build.PostProjectBuildTasksExecutor;
import com.android.tools.idea.gradle.project.model.AndroidModelFeatures;
import com.android.tools.idea.gradle.project.model.ModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.ClassJarProvider;
import com.android.tools.lint.detector.api.Lint;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class AndroidModuleModel
implements AndroidModel,
ModuleModel {
    private static final long serialVersionUID = 4L;
    private static final String[] TEST_ARTIFACT_NAMES = new String[]{"_unit_test_", "_android_test_"};
    private static final AndroidVersion NOT_SPECIFIED = new AndroidVersion(0, null);
    @NotNull
    private ProjectSystemId myProjectSystemId;
    @NotNull
    private String myModuleName;
    @NotNull
    private File myRootDirPath;
    @NotNull
    private IdeAndroidProject myAndroidProject;
    @NotNull
    private transient AndroidModelFeatures myFeatures;
    @Nullable
    private transient GradleVersion myModelVersion;
    @NotNull
    private String mySelectedVariantName;
    private transient VirtualFile myRootDir;
    @Nullable
    private Boolean myOverridesManifestPackage;
    @Nullable
    private transient AndroidVersion myMinSdkVersion;
    @NotNull
    private Map<String, BuildTypeContainer> myBuildTypesByName;
    @NotNull
    private Map<String, ProductFlavorContainer> myProductFlavorsByName;
    @NotNull
    private Map<String, IdeVariant> myVariantsByName;
    @NotNull
    private Set<String> myVariantNames;
    private boolean myUsingSingleVariantSync;
    @NotNull
    private Set<File> myExtraGeneratedSourceFolders;

    @Nullable
    public static AndroidModuleModel get(@NotNull Module module) {
        AndroidFacet facet;
        if (module == null) {
            AndroidModuleModel.$$$reportNull$$$0(0);
        }
        return (facet = AndroidFacet.getInstance(module)) != null ? AndroidModuleModel.get(facet) : null;
    }

    @Nullable
    public static AndroidModuleModel get(@NotNull AndroidFacet androidFacet) {
        AndroidModel androidModel;
        if (androidFacet == null) {
            AndroidModuleModel.$$$reportNull$$$0(1);
        }
        return (androidModel = ((AndroidFacetConfiguration)androidFacet.getConfiguration()).getModel()) instanceof AndroidModuleModel ? (AndroidModuleModel)androidModel : null;
    }

    public AndroidModuleModel(@NotNull String moduleName, @NotNull File rootDirPath, @NotNull AndroidProject androidProject, @NotNull String selectedVariantName, @NotNull IdeDependenciesFactory dependenciesFactory) {
        if (moduleName == null) {
            AndroidModuleModel.$$$reportNull$$$0(2);
        }
        if (rootDirPath == null) {
            AndroidModuleModel.$$$reportNull$$$0(3);
        }
        if (androidProject == null) {
            AndroidModuleModel.$$$reportNull$$$0(4);
        }
        if (selectedVariantName == null) {
            AndroidModuleModel.$$$reportNull$$$0(5);
        }
        if (dependenciesFactory == null) {
            AndroidModuleModel.$$$reportNull$$$0(6);
        }
        this(moduleName, rootDirPath, androidProject, selectedVariantName, dependenciesFactory, null);
    }

    public AndroidModuleModel(@NotNull String moduleName, @NotNull File rootDirPath, @NotNull AndroidProject androidProject, @NotNull String variantName, @NotNull IdeDependenciesFactory dependenciesFactory, @Nullable Collection<Variant> variantsToAdd) {
        if (moduleName == null) {
            AndroidModuleModel.$$$reportNull$$$0(7);
        }
        if (rootDirPath == null) {
            AndroidModuleModel.$$$reportNull$$$0(8);
        }
        if (androidProject == null) {
            AndroidModuleModel.$$$reportNull$$$0(9);
        }
        if (variantName == null) {
            AndroidModuleModel.$$$reportNull$$$0(10);
        }
        if (dependenciesFactory == null) {
            AndroidModuleModel.$$$reportNull$$$0(11);
        }
        this.myBuildTypesByName = new HashMap<String, BuildTypeContainer>();
        this.myProductFlavorsByName = new HashMap<String, ProductFlavorContainer>();
        this.myVariantsByName = new HashMap<String, IdeVariant>();
        this.myVariantNames = new HashSet<String>();
        this.myExtraGeneratedSourceFolders = new HashSet<File>();
        this.myAndroidProject = new IdeAndroidProjectImpl(androidProject, dependenciesFactory, variantsToAdd);
        this.myUsingSingleVariantSync = variantsToAdd != null;
        this.myProjectSystemId = GradleUtil.GRADLE_SYSTEM_ID;
        this.myModuleName = moduleName;
        this.myRootDirPath = rootDirPath;
        this.parseAndSetModelVersion();
        this.myFeatures = new AndroidModelFeatures(this.myModelVersion);
        this.populateBuildTypesByName();
        this.populateProductFlavorsByName();
        this.populateVariantsByName();
        this.mySelectedVariantName = this.findVariantToSelect(variantName);
    }

    private void populateBuildTypesByName() {
        for (BuildTypeContainer container : this.myAndroidProject.getBuildTypes()) {
            String name = container.getBuildType().getName();
            this.myBuildTypesByName.put(name, container);
        }
    }

    private void populateProductFlavorsByName() {
        for (ProductFlavorContainer container : this.myAndroidProject.getProductFlavors()) {
            String name = container.getProductFlavor().getName();
            this.myProductFlavorsByName.put(name, container);
        }
    }

    private void populateVariantsByName() {
        this.myAndroidProject.forEachVariant(variant -> this.myVariantsByName.put(variant.getName(), (IdeVariant)variant));
        this.myVariantNames = this.myUsingSingleVariantSync ? new HashSet<String>(this.myAndroidProject.getVariantNames()) : new HashSet<String>(this.myVariantsByName.keySet());
    }

    @Deprecated
    @NotNull
    public Dependencies getSelectedMainCompileDependencies() {
        IdeAndroidArtifact mainArtifact = this.getMainArtifact();
        Dependencies dependencies = mainArtifact.getDependencies();
        if (dependencies == null) {
            AndroidModuleModel.$$$reportNull$$$0(12);
        }
        return dependencies;
    }

    @NotNull
    public IdeDependencies getSelectedMainCompileLevel2Dependencies() {
        IdeAndroidArtifact mainArtifact = this.getMainArtifact();
        IdeDependencies ideDependencies = mainArtifact.getLevel2Dependencies();
        if (ideDependencies == null) {
            AndroidModuleModel.$$$reportNull$$$0(13);
        }
        return ideDependencies;
    }

    @Nullable
    public IdeDependencies getSelectedAndroidTestCompileDependencies() {
        IdeAndroidArtifact androidTestArtifact = this.getSelectedVariant().getAndroidTestArtifact();
        if (androidTestArtifact == null) {
            return null;
        }
        return androidTestArtifact.getLevel2Dependencies();
    }

    @NotNull
    public AndroidModelFeatures getFeatures() {
        AndroidModelFeatures androidModelFeatures = this.myFeatures;
        if (androidModelFeatures == null) {
            AndroidModuleModel.$$$reportNull$$$0(14);
        }
        return androidModelFeatures;
    }

    @Nullable
    public GradleVersion getModelVersion() {
        return this.myModelVersion;
    }

    @NotNull
    public IdeAndroidArtifact getMainArtifact() {
        IdeAndroidArtifact ideAndroidArtifact = this.getSelectedVariant().getMainArtifact();
        if (ideAndroidArtifact == null) {
            AndroidModuleModel.$$$reportNull$$$0(15);
        }
        return ideAndroidArtifact;
    }

    @Override
    @NotNull
    public SourceProvider getDefaultSourceProvider() {
        SourceProvider sourceProvider = this.getAndroidProject().getDefaultConfig().getSourceProvider();
        if (sourceProvider == null) {
            AndroidModuleModel.$$$reportNull$$$0(16);
        }
        return sourceProvider;
    }

    @Override
    @NotNull
    public List<SourceProvider> getActiveSourceProviders() {
        List<SourceProvider> list = this.getMainSourceProviders(this.mySelectedVariantName);
        if (list == null) {
            AndroidModuleModel.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    private List<SourceProvider> getMainSourceProviders(@NotNull String variantName) {
        Variant variant;
        if (variantName == null) {
            AndroidModuleModel.$$$reportNull$$$0(18);
        }
        if ((variant = (Variant)this.myVariantsByName.get(variantName)) == null) {
            AndroidModuleModel.getLogger().error("Unknown variant name '" + variantName + "' found in the module '" + this.myModuleName + "'");
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                AndroidModuleModel.$$$reportNull$$$0(19);
            }
            return immutableList;
        }
        ArrayList<SourceProvider> providers = new ArrayList<SourceProvider>();
        providers.add(this.getDefaultSourceProvider());
        for (String flavor : variant.getProductFlavors()) {
            ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
            assert (productFlavor != null);
            providers.add(productFlavor.getSourceProvider());
        }
        AndroidArtifact mainArtifact = variant.getMainArtifact();
        SourceProvider multiFlavorProvider = mainArtifact.getMultiFlavorSourceProvider();
        if (multiFlavorProvider != null) {
            providers.add(multiFlavorProvider);
        }
        BuildTypeContainer buildType = this.findBuildType(variant.getBuildType());
        assert (buildType != null);
        providers.add(buildType.getSourceProvider());
        SourceProvider variantProvider = mainArtifact.getVariantSourceProvider();
        if (variantProvider != null) {
            providers.add(variantProvider);
        }
        ArrayList<SourceProvider> arrayList = providers;
        if (arrayList == null) {
            AndroidModuleModel.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @NotNull
    public Collection<SourceProvider> getTestSourceProviders(@NotNull Iterable<SourceProviderContainer> containers) {
        if (containers == null) {
            AndroidModuleModel.$$$reportNull$$$0(21);
        }
        Collection<SourceProvider> collection = AndroidModuleModel.getSourceProvidersForArtifacts(containers, TEST_ARTIFACT_NAMES);
        if (collection == null) {
            AndroidModuleModel.$$$reportNull$$$0(22);
        }
        return collection;
    }

    @Override
    @NotNull
    public List<SourceProvider> getTestSourceProviders() {
        List<SourceProvider> list = this.getTestSourceProviders(this.mySelectedVariantName, TEST_ARTIFACT_NAMES);
        if (list == null) {
            AndroidModuleModel.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    public List<SourceProvider> getTestSourceProviders(@NotNull String artifactName) {
        if (artifactName == null) {
            AndroidModuleModel.$$$reportNull$$$0(24);
        }
        List<SourceProvider> list = this.getTestSourceProviders(this.mySelectedVariantName, artifactName);
        if (list == null) {
            AndroidModuleModel.$$$reportNull$$$0(25);
        }
        return list;
    }

    @NotNull
    private List<SourceProvider> getTestSourceProviders(@NotNull String variantName, String ... testArtifactNames) {
        if (variantName == null) {
            AndroidModuleModel.$$$reportNull$$$0(26);
        }
        if (testArtifactNames == null) {
            AndroidModuleModel.$$$reportNull$$$0(27);
        }
        AndroidModuleModel.validateTestArtifactNames(testArtifactNames);
        Collection extraSourceProviders = this.getAndroidProject().getDefaultConfig().getExtraSourceProviders();
        ArrayList<SourceProvider> providers = new ArrayList<SourceProvider>(AndroidModuleModel.getSourceProvidersForArtifacts(extraSourceProviders, testArtifactNames));
        Variant variant = (Variant)this.myVariantsByName.get(variantName);
        assert (variant != null);
        for (String flavor : variant.getProductFlavors()) {
            ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
            assert (productFlavor != null);
            providers.addAll(AndroidModuleModel.getSourceProvidersForArtifacts(productFlavor.getExtraSourceProviders(), testArtifactNames));
        }
        BuildTypeContainer buildType = this.findBuildType(variant.getBuildType());
        assert (buildType != null);
        providers.addAll(AndroidModuleModel.getSourceProvidersForArtifacts(buildType.getExtraSourceProviders(), testArtifactNames));
        ArrayList<SourceProvider> arrayList = providers;
        if (arrayList == null) {
            AndroidModuleModel.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    private static void validateTestArtifactNames(@NotNull String[] testArtifactNames) {
        if (testArtifactNames == null) {
            AndroidModuleModel.$$$reportNull$$$0(29);
        }
        for (String name : testArtifactNames) {
            if (AndroidModuleModel.isTestArtifact(name)) continue;
            String msg = String.format("'%1$s' is not a test artifact", name);
            throw new IllegalArgumentException(msg);
        }
    }

    private static boolean isTestArtifact(@Nullable String artifactName) {
        return ArrayUtil.contains((String)artifactName, (String[])TEST_ARTIFACT_NAMES);
    }

    public boolean variantExists(@NotNull String variantName) {
        if (variantName == null) {
            AndroidModuleModel.$$$reportNull$$$0(30);
        }
        for (Variant variant : this.myAndroidProject.getVariants()) {
            if (!variantName.equals(variant.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<SourceProvider> getAllSourceProviders() {
        Collection variants = this.myAndroidProject.getVariants();
        ArrayList<SourceProvider> providers = new ArrayList<SourceProvider>();
        providers.add(this.getDefaultSourceProvider());
        Collection flavors = this.myAndroidProject.getProductFlavors();
        for (ProductFlavorContainer flavorContainer : flavors) {
            providers.add(flavorContainer.getSourceProvider());
        }
        for (Variant variant : variants) {
            SourceProvider provider = variant.getMainArtifact().getMultiFlavorSourceProvider();
            if (provider == null) continue;
            providers.add(provider);
        }
        Collection buildTypes = this.myAndroidProject.getBuildTypes();
        for (BuildTypeContainer btc : buildTypes) {
            providers.add(btc.getSourceProvider());
        }
        for (Variant variant : variants) {
            SourceProvider provider = variant.getMainArtifact().getVariantSourceProvider();
            if (provider == null) continue;
            providers.add(provider);
        }
        ArrayList<SourceProvider> arrayList = providers;
        if (arrayList == null) {
            AndroidModuleModel.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public String getApplicationId() {
        String string = this.getSelectedVariant().getMainArtifact().getApplicationId();
        if (string == null) {
            AndroidModuleModel.$$$reportNull$$$0(32);
        }
        return string;
    }

    @Override
    @NotNull
    public Set<String> getAllApplicationIds() {
        HashSet<String> ids = new HashSet<String>();
        for (Variant variant : this.myAndroidProject.getVariants()) {
            String applicationId2 = variant.getMergedFlavor().getApplicationId();
            if (applicationId2 == null) continue;
            ids.add(applicationId2);
        }
        HashSet<String> hashSet = ids;
        if (hashSet == null) {
            AndroidModuleModel.$$$reportNull$$$0(33);
        }
        return hashSet;
    }

    @Override
    public Boolean isDebuggable() {
        BuildTypeContainer buildTypeContainer = this.findBuildType(this.getSelectedVariant().getBuildType());
        if (buildTypeContainer != null) {
            return buildTypeContainer.getBuildType().isDebuggable();
        }
        return null;
    }

    @Override
    @Nullable
    public AndroidVersion getMinSdkVersion() {
        if (this.myMinSdkVersion == null) {
            ApiVersion minSdkVersion2 = this.getSelectedVariant().getMergedFlavor().getMinSdkVersion();
            if (minSdkVersion2 != null && minSdkVersion2.getCodename() != null) {
                ApiVersion defaultConfigVersion = this.getAndroidProject().getDefaultConfig().getProductFlavor().getMinSdkVersion();
                if (defaultConfigVersion != null) {
                    minSdkVersion2 = defaultConfigVersion;
                }
                List flavors = this.getSelectedVariant().getProductFlavors();
                for (String flavor : flavors) {
                    ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
                    assert (productFlavor != null);
                    ApiVersion flavorVersion = productFlavor.getProductFlavor().getMinSdkVersion();
                    if (flavorVersion == null) continue;
                    minSdkVersion2 = flavorVersion;
                    break;
                }
            }
            this.myMinSdkVersion = minSdkVersion2 != null ? Lint.convertVersion((ApiVersion)minSdkVersion2, null) : NOT_SPECIFIED;
        }
        return this.myMinSdkVersion != NOT_SPECIFIED ? this.myMinSdkVersion : null;
    }

    @Override
    @Nullable
    public AndroidVersion getRuntimeMinSdkVersion() {
        ApiVersion minSdkVersion2 = this.getSelectedVariant().getMergedFlavor().getMinSdkVersion();
        return minSdkVersion2 != null ? Lint.convertVersion((ApiVersion)minSdkVersion2, null) : null;
    }

    @Override
    @Nullable
    public AndroidVersion getTargetSdkVersion() {
        ApiVersion targetSdkVersion2 = this.getSelectedVariant().getMergedFlavor().getTargetSdkVersion();
        return targetSdkVersion2 != null ? Lint.convertVersion((ApiVersion)targetSdkVersion2, null) : null;
    }

    @Override
    @Nullable
    public Integer getVersionCode() {
        IdeVariant variant = this.getSelectedVariant();
        ProductFlavor flavor = variant.getMergedFlavor();
        return flavor.getVersionCode();
    }

    @NotNull
    public ProjectSystemId getProjectSystemId() {
        ProjectSystemId projectSystemId = this.myProjectSystemId;
        if (projectSystemId == null) {
            AndroidModuleModel.$$$reportNull$$$0(34);
        }
        return projectSystemId;
    }

    @Nullable
    public BuildTypeContainer findBuildType(@NotNull String name) {
        if (name == null) {
            AndroidModuleModel.$$$reportNull$$$0(35);
        }
        return this.myBuildTypesByName.get(name);
    }

    @NotNull
    public Set<String> getBuildTypes() {
        Set<String> set = this.myBuildTypesByName.keySet();
        if (set == null) {
            AndroidModuleModel.$$$reportNull$$$0(36);
        }
        return set;
    }

    @NotNull
    public Set<String> getProductFlavors() {
        Set<String> set = this.myProductFlavorsByName.keySet();
        if (set == null) {
            AndroidModuleModel.$$$reportNull$$$0(37);
        }
        return set;
    }

    @Nullable
    public ProductFlavorContainer findProductFlavor(@NotNull String name) {
        if (name == null) {
            AndroidModuleModel.$$$reportNull$$$0(38);
        }
        return this.myProductFlavorsByName.get(name);
    }

    @Override
    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            AndroidModuleModel.$$$reportNull$$$0(39);
        }
        return string;
    }

    @Override
    @NotNull
    public File getRootDirPath() {
        File file = this.myRootDirPath;
        if (file == null) {
            AndroidModuleModel.$$$reportNull$$$0(40);
        }
        return file;
    }

    @Override
    @NotNull
    public VirtualFile getRootDir() {
        if (this.myRootDir == null) {
            VirtualFile found = VfsUtil.findFileByIoFile((File)this.myRootDirPath, (boolean)true);
            assert (found != null);
            this.myRootDir = found;
        }
        VirtualFile virtualFile = this.myRootDir;
        if (virtualFile == null) {
            AndroidModuleModel.$$$reportNull$$$0(41);
        }
        return virtualFile;
    }

    @Override
    public boolean isGenerated(@NotNull VirtualFile file) {
        VirtualFile buildFolder;
        if (file == null) {
            AndroidModuleModel.$$$reportNull$$$0(42);
        }
        return (buildFolder = VfsUtil.findFileByIoFile((File)this.myAndroidProject.getBuildFolder(), (boolean)false)) != null && VfsUtilCore.isAncestor((VirtualFile)buildFolder, (VirtualFile)file, (boolean)false);
    }

    @NotNull
    public IdeAndroidProject getAndroidProject() {
        IdeAndroidProject ideAndroidProject = this.myAndroidProject;
        if (ideAndroidProject == null) {
            AndroidModuleModel.$$$reportNull$$$0(43);
        }
        return ideAndroidProject;
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(AndroidModuleModel.class);
        if (logger == null) {
            AndroidModuleModel.$$$reportNull$$$0(44);
        }
        return logger;
    }

    @NotNull
    public IdeVariant getSelectedVariant() {
        IdeVariant selected = this.myVariantsByName.get(this.mySelectedVariantName);
        assert (selected != null);
        IdeVariant ideVariant = selected;
        if (ideVariant == null) {
            AndroidModuleModel.$$$reportNull$$$0(45);
        }
        return ideVariant;
    }

    @Nullable
    public Variant findVariantByName(@NotNull String variantName) {
        if (variantName == null) {
            AndroidModuleModel.$$$reportNull$$$0(46);
        }
        return (Variant)this.myVariantsByName.get(variantName);
    }

    public void setSelectedVariantName(@NotNull String name) {
        if (name == null) {
            AndroidModuleModel.$$$reportNull$$$0(47);
        }
        this.mySelectedVariantName = this.findVariantToSelect(name);
        this.myOverridesManifestPackage = null;
        this.myMinSdkVersion = null;
    }

    @NotNull
    String findVariantToSelect(@NotNull String variantName) {
        String newVariantName;
        if (variantName == null) {
            AndroidModuleModel.$$$reportNull$$$0(48);
        }
        if (this.myVariantsByName.containsKey(variantName)) {
            newVariantName = variantName;
        } else {
            ArrayList<String> sorted = new ArrayList<String>(this.myVariantsByName.keySet());
            Collections.sort(sorted);
            assert (!this.myVariantsByName.isEmpty()) : "There is no variant model in AndroidModuleModel!";
            newVariantName = (String)sorted.get(0);
        }
        String string = newVariantName;
        if (string == null) {
            AndroidModuleModel.$$$reportNull$$$0(49);
        }
        return string;
    }

    @NotNull
    private static Collection<SourceProvider> getSourceProvidersForArtifacts(@NotNull Iterable<SourceProviderContainer> containers, String ... artifactNames) {
        if (containers == null) {
            AndroidModuleModel.$$$reportNull$$$0(50);
        }
        if (artifactNames == null) {
            AndroidModuleModel.$$$reportNull$$$0(51);
        }
        HashSet<SourceProvider> providers = new HashSet<SourceProvider>();
        block0: for (SourceProviderContainer container : containers) {
            for (String artifactName : artifactNames) {
                if (!artifactName.equals(container.getArtifactName())) continue;
                providers.add(container.getSourceProvider());
                continue block0;
            }
        }
        HashSet<SourceProvider> hashSet = providers;
        if (hashSet == null) {
            AndroidModuleModel.$$$reportNull$$$0(52);
        }
        return hashSet;
    }

    @NotNull
    public Collection<String> getBuildTypeNames() {
        Set<String> set = this.myBuildTypesByName.keySet();
        if (set == null) {
            AndroidModuleModel.$$$reportNull$$$0(53);
        }
        return set;
    }

    @NotNull
    public Collection<String> getProductFlavorNames() {
        Set<String> set = this.myProductFlavorsByName.keySet();
        if (set == null) {
            AndroidModuleModel.$$$reportNull$$$0(54);
        }
        return set;
    }

    @NotNull
    public Collection<String> getVariantNames() {
        Set<String> set = this.myVariantNames;
        if (set == null) {
            AndroidModuleModel.$$$reportNull$$$0(55);
        }
        return set;
    }

    @Nullable
    public LanguageLevel getJavaLanguageLevel() {
        JavaCompileOptions compileOptions = this.myAndroidProject.getJavaCompileOptions();
        String sourceCompatibility2 = compileOptions.getSourceCompatibility();
        return LanguageLevel.parse((String)sourceCompatibility2);
    }

    @Override
    public boolean overridesManifestPackage() {
        if (this.myOverridesManifestPackage == null) {
            this.myOverridesManifestPackage = this.getAndroidProject().getDefaultConfig().getProductFlavor().getApplicationId() != null;
            IdeVariant variant = this.getSelectedVariant();
            List flavors = variant.getProductFlavors();
            for (String flavor : flavors) {
                ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
                assert (productFlavor != null);
                if (productFlavor.getProductFlavor().getApplicationId() == null) continue;
                this.myOverridesManifestPackage = true;
                break;
            }
        }
        return this.myOverridesManifestPackage;
    }

    public void registerExtraGeneratedSourceFolder(@NotNull File folderPath) {
        if (folderPath == null) {
            AndroidModuleModel.$$$reportNull$$$0(56);
        }
        this.myExtraGeneratedSourceFolders.add(folderPath);
    }

    @NotNull
    public List<File> getExcludedFolderPaths() {
        File buildFolderPath = this.getAndroidProject().getBuildFolder();
        ArrayList<File> excludedFolderPaths = new ArrayList<File>();
        if (buildFolderPath.isDirectory()) {
            for (File folderPath : FileUtil.notNullize((File[])buildFolderPath.listFiles())) {
                String folderName = folderPath.getName();
                if (folderName.equals("intermediates") || folderName.equals("generated")) continue;
                excludedFolderPaths.add(folderPath);
            }
            File intermediates = new File(buildFolderPath, "intermediates");
            if (intermediates.isDirectory()) {
                for (File folderPath : FileUtil.notNullize((File[])intermediates.listFiles())) {
                    String folderName = folderPath.getName();
                    if (folderName.equals("exploded-aar") || folderName.equals("manifest")) continue;
                    excludedFolderPaths.add(folderPath);
                }
            }
        } else {
            excludedFolderPaths.add(new File(buildFolderPath, "outputs"));
            excludedFolderPaths.add(new File(buildFolderPath, "tmp"));
        }
        ArrayList<File> arrayList = excludedFolderPaths;
        if (arrayList == null) {
            AndroidModuleModel.$$$reportNull$$$0(57);
        }
        return arrayList;
    }

    @NotNull
    public File[] getExtraGeneratedSourceFolderPaths() {
        File[] fileArray = this.myExtraGeneratedSourceFolders.toArray(new File[0]);
        if (fileArray == null) {
            AndroidModuleModel.$$$reportNull$$$0(58);
        }
        return fileArray;
    }

    @Nullable
    public Collection<SyncIssue> getSyncIssues() {
        if (this.getFeatures().isIssueReportingSupported()) {
            return this.myAndroidProject.getSyncIssues();
        }
        return null;
    }

    @Nullable
    public IdeAndroidArtifact getArtifactForAndroidTest() {
        return this.getAndroidProject().getProjectType() == 2 ? this.getSelectedVariant().getMainArtifact() : this.getSelectedVariant().getAndroidTestArtifact();
    }

    @Nullable
    public TestOptions.Execution getTestExecutionStrategy() {
        TestOptions testOptions;
        IdeAndroidArtifact artifact = this.getArtifactForAndroidTest();
        if (artifact != null && (testOptions = artifact.getTestOptions()) != null) {
            return testOptions.getExecution();
        }
        return null;
    }

    boolean isUsingSingleVariantSync() {
        return this.myUsingSingleVariantSync;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.myProjectSystemId);
        out.writeObject(this.myModuleName);
        out.writeObject(this.myRootDirPath);
        out.writeObject(this.myAndroidProject);
        out.writeObject(this.mySelectedVariantName);
        out.writeBoolean(this.myUsingSingleVariantSync);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.myProjectSystemId = (ProjectSystemId)in.readObject();
        this.myModuleName = (String)in.readObject();
        this.myRootDirPath = (File)in.readObject();
        this.myAndroidProject = (IdeAndroidProject)in.readObject();
        String variantName = (String)in.readObject();
        this.myUsingSingleVariantSync = in.readBoolean();
        this.parseAndSetModelVersion();
        this.myFeatures = new AndroidModelFeatures(this.myModelVersion);
        this.myBuildTypesByName = new HashMap<String, BuildTypeContainer>();
        this.myProductFlavorsByName = new HashMap<String, ProductFlavorContainer>();
        this.myVariantsByName = new HashMap<String, IdeVariant>();
        this.myExtraGeneratedSourceFolders = new HashSet<File>();
        this.populateBuildTypesByName();
        this.populateProductFlavorsByName();
        this.populateVariantsByName();
        this.setSelectedVariantName(variantName);
    }

    private void parseAndSetModelVersion() {
        this.myModelVersion = GradleVersion.tryParse((String)this.myAndroidProject.getModelVersion());
    }

    @NotNull
    public SourceProvider getBuildTypeSourceProvider() {
        IdeVariant selectedVariant = this.getSelectedVariant();
        BuildTypeContainer buildType = this.findBuildType(selectedVariant.getBuildType());
        assert (buildType != null);
        SourceProvider sourceProvider = buildType.getSourceProvider();
        if (sourceProvider == null) {
            AndroidModuleModel.$$$reportNull$$$0(59);
        }
        return sourceProvider;
    }

    @NotNull
    public List<SourceProvider> getFlavorSourceProviders() {
        IdeVariant selectedVariant = this.getSelectedVariant();
        List productFlavors = selectedVariant.getProductFlavors();
        ArrayList<SourceProvider> providers = new ArrayList<SourceProvider>();
        for (String flavor : productFlavors) {
            ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
            assert (productFlavor != null);
            providers.add(productFlavor.getSourceProvider());
        }
        ArrayList<SourceProvider> arrayList = providers;
        if (arrayList == null) {
            AndroidModuleModel.$$$reportNull$$$0(60);
        }
        return arrayList;
    }

    public void syncSelectedVariantAndTestArtifact(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidModuleModel.$$$reportNull$$$0(61);
        }
        IdeVariant variant = this.getSelectedVariant();
        JpsAndroidModuleProperties state = facet.getProperties();
        state.SELECTED_BUILD_VARIANT = variant.getName();
        IdeAndroidArtifact mainArtifact = variant.getMainArtifact();
        AndroidModuleModel.updateGradleTaskNames(state, mainArtifact);
    }

    private static void updateGradleTaskNames(@NotNull JpsAndroidModuleProperties state, @NotNull IdeAndroidArtifact mainArtifact) {
        if (state == null) {
            AndroidModuleModel.$$$reportNull$$$0(62);
        }
        if (mainArtifact == null) {
            AndroidModuleModel.$$$reportNull$$$0(63);
        }
        state.ASSEMBLE_TASK_NAME = mainArtifact.getAssembleTaskName();
        state.COMPILE_JAVA_TASK_NAME = mainArtifact.getCompileTaskName();
        state.AFTER_SYNC_TASK_NAMES = new HashSet(mainArtifact.getIdeSetupTaskNames());
        state.ASSEMBLE_TEST_TASK_NAME = "";
        state.COMPILE_JAVA_TEST_TASK_NAME = "";
    }

    @Nullable
    public SourceProvider getMultiFlavorSourceProvider() {
        IdeAndroidArtifact mainArtifact = this.getSelectedVariant().getMainArtifact();
        return mainArtifact.getMultiFlavorSourceProvider();
    }

    @Nullable
    public SourceProvider getVariantSourceProvider() {
        IdeAndroidArtifact mainArtifact = this.getSelectedVariant().getMainArtifact();
        return mainArtifact.getVariantSourceProvider();
    }

    @Override
    @NotNull
    public DataBindingMode getDataBindingMode() {
        if (GradleUtil.dependsOn(this, "androidx.databinding:databinding-runtime")) {
            DataBindingMode dataBindingMode = DataBindingMode.ANDROIDX;
            if (dataBindingMode == null) {
                AndroidModuleModel.$$$reportNull$$$0(64);
            }
            return dataBindingMode;
        }
        if (GradleUtil.dependsOn(this, "com.android.databinding:library")) {
            DataBindingMode dataBindingMode = DataBindingMode.SUPPORT;
            if (dataBindingMode == null) {
                AndroidModuleModel.$$$reportNull$$$0(65);
            }
            return dataBindingMode;
        }
        DataBindingMode dataBindingMode = DataBindingMode.NONE;
        if (dataBindingMode == null) {
            AndroidModuleModel.$$$reportNull$$$0(66);
        }
        return dataBindingMode;
    }

    @Override
    @NotNull
    public ClassJarProvider getClassJarProvider() {
        AndroidGradleClassJarProvider androidGradleClassJarProvider = new AndroidGradleClassJarProvider();
        if (androidGradleClassJarProvider == null) {
            AndroidModuleModel.$$$reportNull$$$0(67);
        }
        return androidGradleClassJarProvider;
    }

    @Override
    public boolean isClassFileOutOfDate(@NotNull Module module, @NotNull String fqcn, @NotNull VirtualFile classFile) {
        if (module == null) {
            AndroidModuleModel.$$$reportNull$$$0(68);
        }
        if (fqcn == null) {
            AndroidModuleModel.$$$reportNull$$$0(69);
        }
        if (classFile == null) {
            AndroidModuleModel.$$$reportNull$$$0(70);
        }
        Project project = module.getProject();
        GlobalSearchScope scope = module.getModuleWithDependenciesScope();
        VirtualFile sourceFile = (VirtualFile)ApplicationManager.getApplication().runReadAction(() -> {
            PsiClass psiClass;
            if (fqcn == null) {
                AndroidModuleModel.$$$reportNull$$$0(72);
            }
            if ((psiClass = JavaPsiFacade.getInstance((Project)project).findClass(fqcn, scope)) == null) {
                return null;
            }
            PsiFile psiFile = psiClass.getContainingFile();
            if (psiFile == null) {
                return null;
            }
            return psiFile.getVirtualFile();
        });
        if (sourceFile == null) {
            return false;
        }
        if (FileDocumentManager.getInstance().isFileModified(sourceFile)) {
            return true;
        }
        long sourceFileModified = sourceFile.getTimeStamp();
        long lastBuildTimestamp = classFile.getTimeStamp();
        Long projectBuildTimestamp = PostProjectBuildTasksExecutor.getInstance(project).getLastBuildTimestamp();
        if (projectBuildTimestamp != null) {
            lastBuildTimestamp = projectBuildTimestamp;
        }
        return sourceFileModified > lastBuildTimestamp && lastBuildTimestamp > 0L;
    }

    @Override
    @NotNull
    public AaptOptions.Namespacing getNamespacing() {
        AaptOptions.Namespacing namespacing = this.myAndroidProject.getAaptOptions().getNamespacing();
        if (namespacing == null) {
            AndroidModuleModel.$$$reportNull$$$0(71);
        }
        return namespacing;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 71: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 71: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDirPath";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidProject";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedVariantName";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesFactory";
                break;
            }
            case 10: 
            case 18: 
            case 26: 
            case 30: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantName";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/model/AndroidModuleModel";
                break;
            }
            case 21: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containers";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactName";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testArtifactNames";
                break;
            }
            case 35: 
            case 38: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactNames";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderPath";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainArtifact";
                break;
            }
            case 69: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqcn";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/model/AndroidModuleModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedMainCompileDependencies";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedMainCompileLevel2Dependencies";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatures";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainArtifact";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSourceProvider";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveSourceProviders";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainSourceProviders";
                break;
            }
            case 22: 
            case 23: 
            case 25: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestSourceProviders";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSourceProviders";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationId";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllApplicationIds";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSystemId";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTypes";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getProductFlavors";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootDirPath";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootDir";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidProject";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedVariant";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "findVariantToSelect";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceProvidersForArtifacts";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTypeNames";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getProductFlavorNames";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariantNames";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedFolderPaths";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraGeneratedSourceFolderPaths";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTypeSourceProvider";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlavorSourceProviders";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataBindingMode";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassJarProvider";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespacing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 71: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getMainSourceProviders";
                break;
            }
            case 21: 
            case 24: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTestSourceProviders";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "validateTestArtifactNames";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "variantExists";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findBuildType";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findProductFlavor";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isGenerated";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findVariantByName";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedVariantName";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findVariantToSelect";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getSourceProvidersForArtifacts";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "registerExtraGeneratedSourceFolder";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "syncSelectedVariantAndTestArtifact";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "updateGradleTaskNames";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isClassFileOutOfDate";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isClassFileOutOfDate$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 71: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

