/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.compatibility;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.sync.compatibility.CompatibilityCheck;
import com.android.tools.idea.gradle.project.sync.compatibility.Component;
import com.android.tools.idea.gradle.project.sync.compatibility.version.BuildFileComponentVersionReader;
import com.android.tools.idea.gradle.project.sync.compatibility.version.ComponentVersionReader;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.project.messages.MessageType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.intellij.lang.annotations.Language;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class CompatibilityChecksMetadata {
    @NonNls
    private static final String BUILD_FILE_PREFIX = "buildFile:";
    @NonNls
    private static final String METADATA_FILE_NAME = "android-component-compatibility.xml";
    private final int myDataVersion;
    @NotNull
    private final List<CompatibilityCheck> myCompatibilityChecks = new ArrayList<CompatibilityCheck>();
    @NotNull
    private final Map<String, ComponentVersionReader> myReadersByComponentName = new ConcurrentHashMap<String, ComponentVersionReader>();

    @NotNull
    static CompatibilityChecksMetadata reload() {
        File metadataFilePath = CompatibilityChecksMetadata.getSourceFilePath();
        if (metadataFilePath.isFile()) {
            CompatibilityChecksMetadata compatibilityChecksMetadata;
            try {
                Element root = JDOMUtil.load((File)metadataFilePath);
                compatibilityChecksMetadata = CompatibilityChecksMetadata.load(root);
            }
            catch (Throwable e) {
                String message = "Failed to load/parse file '" + metadataFilePath.getPath() + "'. Loading metadata from local file.";
                CompatibilityChecksMetadata.getLogger().info(message, e);
                CompatibilityChecksMetadata compatibilityChecksMetadata2 = CompatibilityChecksMetadata.loadLocal();
                if (compatibilityChecksMetadata2 == null) {
                    CompatibilityChecksMetadata.$$$reportNull$$$0(1);
                }
                return compatibilityChecksMetadata2;
            }
            if (compatibilityChecksMetadata == null) {
                CompatibilityChecksMetadata.$$$reportNull$$$0(0);
            }
            return compatibilityChecksMetadata;
        }
        CompatibilityChecksMetadata compatibilityChecksMetadata = CompatibilityChecksMetadata.loadLocal();
        if (compatibilityChecksMetadata == null) {
            CompatibilityChecksMetadata.$$$reportNull$$$0(2);
        }
        return compatibilityChecksMetadata;
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static CompatibilityChecksMetadata loadLocal() {
        InputStream inputStream = CompatibilityChecksMetadata.class.getResourceAsStream(METADATA_FILE_NAME);
        Throwable throwable = null;
        Element root = JDOMUtil.load((InputStream)inputStream);
        CompatibilityChecksMetadata compatibilityChecksMetadata = CompatibilityChecksMetadata.load(root);
        CompatibilityChecksMetadata compatibilityChecksMetadata2 = compatibilityChecksMetadata;
        if (compatibilityChecksMetadata2 == null) {
            CompatibilityChecksMetadata.$$$reportNull$$$0(3);
        }
        return compatibilityChecksMetadata2;
        {
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream != null) {
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
            {
                catch (RuntimeException e) {
                    CompatibilityChecksMetadata.logFailureToReadLocalFile(e);
                    throw e;
                }
                catch (Throwable e) {
                    CompatibilityChecksMetadata.logFailureToReadLocalFile(e);
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static void logFailureToReadLocalFile(@NotNull Throwable e) {
        if (e == null) {
            CompatibilityChecksMetadata.$$$reportNull$$$0(4);
        }
        CompatibilityChecksMetadata.getLogger().info("Failed to load/parse local metadata file.", e);
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(CompatibilityChecksMetadata.class);
        if (logger == null) {
            CompatibilityChecksMetadata.$$$reportNull$$$0(5);
        }
        return logger;
    }

    @VisibleForTesting
    @NotNull
    static CompatibilityChecksMetadata reloadForTesting(@NotNull @Language(value="XML") String metadata) throws JDOMException, IOException {
        if (metadata == null) {
            CompatibilityChecksMetadata.$$$reportNull$$$0(6);
        }
        Element root = JDOMUtil.load((Reader)new StringReader(metadata));
        CompatibilityChecksMetadata compatibilityChecksMetadata = CompatibilityChecksMetadata.load(root);
        if (compatibilityChecksMetadata == null) {
            CompatibilityChecksMetadata.$$$reportNull$$$0(7);
        }
        return compatibilityChecksMetadata;
    }

    @NotNull
    static File getSourceFilePath() {
        File configPath = FilePaths.toSystemDependentPath((String)PathManager.getConfigPath());
        File file = new File(configPath, METADATA_FILE_NAME);
        if (file == null) {
            CompatibilityChecksMetadata.$$$reportNull$$$0(8);
        }
        return file;
    }

    @NotNull
    static CompatibilityChecksMetadata load(@NotNull Element root) {
        if (root == null) {
            CompatibilityChecksMetadata.$$$reportNull$$$0(9);
        }
        String dataVersionText = root.getAttributeValue("version");
        int dataVersion = 1;
        try {
            dataVersion = Integer.parseInt(dataVersionText);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        CompatibilityChecksMetadata metadata = new CompatibilityChecksMetadata(dataVersion);
        for (Element checkElement : root.getChildren("check")) {
            Element componentElement = checkElement.getChild("component");
            Component version2 = CompatibilityChecksMetadata.createComponent(componentElement, metadata);
            for (Element requirementElement : componentElement.getChildren("requires")) {
                version2.addRequirement(CompatibilityChecksMetadata.createComponent(requirementElement, metadata));
            }
            String type = checkElement.getAttributeValue("failureType");
            CompatibilityCheck check = new CompatibilityCheck(version2, CompatibilityChecksMetadata.getFailureType(type));
            metadata.myCompatibilityChecks.add(check);
        }
        CompatibilityChecksMetadata compatibilityChecksMetadata = metadata;
        if (compatibilityChecksMetadata == null) {
            CompatibilityChecksMetadata.$$$reportNull$$$0(10);
        }
        return compatibilityChecksMetadata;
    }

    @NotNull
    private static MessageType getFailureType(@NotNull String value) {
        MessageType type;
        if (value == null) {
            CompatibilityChecksMetadata.$$$reportNull$$$0(11);
        }
        MessageType messageType = (type = MessageType.findByName(value)) != null ? type : MessageType.ERROR;
        if (messageType == null) {
            CompatibilityChecksMetadata.$$$reportNull$$$0(12);
        }
        return messageType;
    }

    @NotNull
    private static Component createComponent(@NotNull Element xmlElement, @NotNull CompatibilityChecksMetadata metadata) {
        String name;
        if (xmlElement == null) {
            CompatibilityChecksMetadata.$$$reportNull$$$0(13);
        }
        if (metadata == null) {
            CompatibilityChecksMetadata.$$$reportNull$$$0(14);
        }
        if ((name = xmlElement.getAttribute("name").getValue()).startsWith(BUILD_FILE_PREFIX)) {
            name = name.substring(BUILD_FILE_PREFIX.length());
            metadata.addIfAbsent(name, new BuildFileComponentVersionReader(name));
        }
        String version2 = xmlElement.getAttributeValue("version");
        String failureMsg = null;
        Element failureMsgElement = xmlElement.getChild("failureMsg");
        if (failureMsgElement != null) {
            failureMsg = Strings.emptyToNull((String)failureMsgElement.getTextNormalize());
        }
        Component component = new Component(name, version2, failureMsg);
        if (component == null) {
            CompatibilityChecksMetadata.$$$reportNull$$$0(15);
        }
        return component;
    }

    CompatibilityChecksMetadata(int dataVersion) {
        this.myDataVersion = dataVersion;
        this.myReadersByComponentName.put("gradle", ComponentVersionReader.GRADLE);
        this.myReadersByComponentName.put("android-gradle-plugin", ComponentVersionReader.ANDROID_GRADLE_PLUGIN);
        this.myReadersByComponentName.put("android-gradle-experimental-plugin", ComponentVersionReader.ANDROID_GRADLE_EXPERIMENTAL_PLUGIN);
        if (IdeInfo.getInstance().isAndroidStudio()) {
            this.myReadersByComponentName.put("android-studio", ComponentVersionReader.ANDROID_STUDIO);
        }
    }

    private void addIfAbsent(@NotNull String name, @NotNull ComponentVersionReader componentVersionReader) {
        if (name == null) {
            CompatibilityChecksMetadata.$$$reportNull$$$0(16);
        }
        if (componentVersionReader == null) {
            CompatibilityChecksMetadata.$$$reportNull$$$0(17);
        }
        this.myReadersByComponentName.putIfAbsent(name, componentVersionReader);
    }

    int getDataVersion() {
        return this.myDataVersion;
    }

    ComponentVersionReader findComponentVersionReader(@NotNull String name) {
        if (name == null) {
            CompatibilityChecksMetadata.$$$reportNull$$$0(18);
        }
        return this.myReadersByComponentName.get(name);
    }

    @NotNull
    List<CompatibilityCheck> getCompatibilityChecks() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myCompatibilityChecks);
        if (immutableList == null) {
            CompatibilityChecksMetadata.$$$reportNull$$$0(19);
        }
        return immutableList;
    }

    @NotNull
    Map<String, ComponentVersionReader> getReadersByComponentName() {
        Map<String, ComponentVersionReader> map2 = this.myReadersByComponentName;
        if (map2 == null) {
            CompatibilityChecksMetadata.$$$reportNull$$$0(20);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadata";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadata";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlElement";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentVersionReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "reload";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadLocal";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadata";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "reloadForTesting";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFilePath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFailureType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompatibilityChecks";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadersByComponentName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logFailureToReadLocalFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reloadForTesting";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFailureType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createComponent";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addIfAbsent";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findComponentVersionReader";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

