/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.compatibility.version;

import com.android.ide.common.repository.GradleVersion;
import com.google.common.base.Splitter;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VersionRange {
    @NonNls
    private static final char OR_GREATER = '+';
    @NonNls
    private static final char START_INCLUSIVE = '[';
    @NonNls
    private static final char START_EXCLUSIVE = '(';
    @NonNls
    private static final char END_INCLUSIVE = ']';
    @NonNls
    private static final char END_EXCLUSIVE = ')';
    @NotNull
    private final String myUnparsedValue;
    @NotNull
    private final String myMinVersion;
    @Nullable
    private final GradleVersion myParsedMinVersion;
    private final boolean myMinVersionInclusive;
    @Nullable
    private final String myMaxVersion;
    @Nullable
    private final GradleVersion myParsedMaxVersion;
    private final boolean myMaxVersionInclusive;

    @NotNull
    public static VersionRange parse(@NotNull String value) {
        if (value == null) {
            VersionRange.$$$reportNull$$$0(0);
        }
        if (value.isEmpty()) {
            throw new IllegalArgumentException("Empty string is not a valid value");
        }
        int size = value.length();
        char lastChar = value.charAt(size - 1);
        if (lastChar == '+') {
            String minVersion = value.substring(0, size - 1);
            VersionRange versionRange = new VersionRange(value, minVersion, true, null, false);
            if (versionRange == null) {
                VersionRange.$$$reportNull$$$0(1);
            }
            return versionRange;
        }
        char firstChar = value.charAt(0);
        if (firstChar == '[' || firstChar == '(') {
            boolean minVersionInclusive;
            boolean bl = minVersionInclusive = firstChar == '[';
            if (lastChar != ']' && lastChar != ')') {
                throw new IllegalArgumentException(String.format("Value '%1$s' should end with ']' or ')'", value));
            }
            boolean maxVersionInclusive = lastChar == ']';
            String rangeValue = value.substring(1, size - 1);
            List values2 = Splitter.on((char)',').splitToList((CharSequence)rangeValue);
            if (values2.size() != 2) {
                throw new IllegalArgumentException(String.format("Range '%1$s' should contain 2 values", value));
            }
            String minVersion = ((String)values2.get(0)).trim();
            String maxVersion = ((String)values2.get(1)).trim();
            if (maxVersion.length() == 1 && maxVersion.charAt(0) == '+') {
                maxVersion = null;
            }
            VersionRange versionRange = new VersionRange(value, minVersion, minVersionInclusive, maxVersion, maxVersionInclusive);
            if (versionRange == null) {
                VersionRange.$$$reportNull$$$0(2);
            }
            return versionRange;
        }
        VersionRange versionRange = new VersionRange(value, value, false, null, false);
        if (versionRange == null) {
            VersionRange.$$$reportNull$$$0(3);
        }
        return versionRange;
    }

    private VersionRange(@NotNull String unparsedValue, @NotNull String minVersion, boolean minVersionInclusive, @Nullable String maxVersion, boolean maxVersionInclusive) {
        if (unparsedValue == null) {
            VersionRange.$$$reportNull$$$0(4);
        }
        if (minVersion == null) {
            VersionRange.$$$reportNull$$$0(5);
        }
        this.myUnparsedValue = unparsedValue;
        this.myMinVersion = minVersion;
        GradleVersion parsedMinVersion = GradleVersion.tryParse((String)minVersion);
        if (parsedMinVersion != null && parsedMinVersion.getMajor() == 0 && minVersion.equals(parsedMinVersion.getMajorSegment().getText())) {
            parsedMinVersion = null;
        }
        this.myParsedMinVersion = parsedMinVersion;
        this.myMinVersionInclusive = minVersionInclusive;
        this.myMaxVersion = maxVersion;
        this.myParsedMaxVersion = maxVersion != null ? GradleVersion.tryParse((String)maxVersion) : null;
        this.myMaxVersionInclusive = maxVersionInclusive;
    }

    public boolean contains(@NotNull String value) {
        if (value == null) {
            VersionRange.$$$reportNull$$$0(6);
        }
        if (this.myParsedMinVersion != null) {
            boolean contains = false;
            GradleVersion version2 = GradleVersion.tryParse((String)value);
            if (version2 != null) {
                if (this.myMinVersionInclusive) {
                    contains = version2.compareIgnoringQualifiers(this.myParsedMinVersion) >= 0;
                } else {
                    boolean bl = contains = version2.compareIgnoringQualifiers(this.myParsedMinVersion) > 0;
                }
                if (contains && this.myParsedMaxVersion != null) {
                    contains = this.myMaxVersionInclusive ? version2.compareIgnoringQualifiers(this.myParsedMaxVersion) <= 0 : version2.compareIgnoringQualifiers(this.myParsedMaxVersion) < 0;
                }
            }
            return contains;
        }
        return value.equals(this.myMinVersion) || value.equals(this.myMaxVersion);
    }

    @NotNull
    public String getDescription() {
        if (this.myMinVersion.equals(this.myMaxVersion)) {
            String string = this.myMinVersion;
            if (string == null) {
                VersionRange.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (this.myMaxVersion == null) {
            String string = String.format("%1$s (or newer)", this.myMinVersion);
            if (string == null) {
                VersionRange.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = "versions " + this.myMinVersion + VersionRange.inclusiveness(this.myMinVersionInclusive) + " to " + this.myMaxVersion + VersionRange.inclusiveness(this.myMaxVersionInclusive);
        if (string == null) {
            VersionRange.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static String inclusiveness(boolean inclusive) {
        return " (" + (inclusive ? "inclusive" : "exclusive") + ")";
    }

    @NotNull
    public String getMinVersion() {
        String string = this.myMinVersion;
        if (string == null) {
            VersionRange.$$$reportNull$$$0(10);
        }
        return string;
    }

    public boolean isMinVersionInclusive() {
        return this.myMinVersionInclusive;
    }

    @Nullable
    public String getMaxVersion() {
        return this.myMaxVersion;
    }

    public boolean isMaxVersionInclusive() {
        return this.myMaxVersionInclusive;
    }

    public String toString() {
        return this.myUnparsedValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/compatibility/version/VersionRange";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unparsedValue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/compatibility/version/VersionRange";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

