/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixGradleVersionInWrapperHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class Gradle4AndPlugin2Dot2ErrorHandler
extends SyncErrorHandler {
    @Override
    public boolean handleError(@NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        if (error == null) {
            Gradle4AndPlugin2Dot2ErrorHandler.$$$reportNull$$$0(0);
        }
        if (notification == null) {
            Gradle4AndPlugin2Dot2ErrorHandler.$$$reportNull$$$0(1);
        }
        if (project == null) {
            Gradle4AndPlugin2Dot2ErrorHandler.$$$reportNull$$$0(2);
        }
        if (Gradle4AndPlugin2Dot2ErrorHandler.isGradleAndPluginMismatch(this.getRootCause(error), project)) {
            final String migrationDocUrl = "https://goo.gl/sEn5eA";
            notification.setListener(migrationDocUrl, (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    if (notification == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    BrowserUtil.browse((String)migrationDocUrl);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                    }
                    objectArray[1] = "com/android/tools/idea/gradle/project/sync/errors/Gradle4AndPlugin2Dot2ErrorHandler$1";
                    objectArray[2] = "hyperlinkActivated";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            NotificationHyperlink fixGradleVersion = FixGradleVersionInWrapperHyperlink.createIfProjectUsesGradleWrapper(project, "3.5");
            String text = "The versions of the Android Gradle plugin and Gradle are not compatible.\nPlease do one of the following:<ul><li>Update your plugin to version 2.4. This will require changes to build.gradle due to API changes.\n<a href='" + migrationDocUrl + "'>Open migration guide</a></li><li>Downgrade Gradle to version 3.5.";
            if (fixGradleVersion != null) {
                text = text + "\n" + fixGradleVersion.toHtml();
            }
            text = text + "</li></ul>";
            notification.setTitle("Gradle Sync Issues");
            notification.setMessage(text);
            notification.setNotificationCategory(NotificationCategory.convert((NotificationType)DEFAULT_NOTIFICATION_TYPE));
            List<NotificationHyperlink> quickFixes = Collections.emptyList();
            if (fixGradleVersion != null) {
                quickFixes = Collections.singletonList(fixGradleVersion);
            }
            GradleSyncMessages.getInstance(project).addNotificationListener(notification, quickFixes);
            return true;
        }
        return false;
    }

    private static boolean isGradleAndPluginMismatch(@NotNull Throwable rootCause, @NotNull Project project) {
        String text;
        boolean targetMissingMethodFound;
        if (rootCause == null) {
            Gradle4AndPlugin2Dot2ErrorHandler.$$$reportNull$$$0(3);
        }
        if (project == null) {
            Gradle4AndPlugin2Dot2ErrorHandler.$$$reportNull$$$0(4);
        }
        if (rootCause instanceof NoSuchMethodError && (targetMissingMethodFound = (text = rootCause.getMessage()).startsWith("com.android.build.gradle.tasks.factory.AndroidJavaCompile.setDependencyCacheDir"))) {
            GradleWrapper gradleWrapper = GradleWrapper.find(project);
            if (gradleWrapper != null) {
                try {
                    String version2 = gradleWrapper.getGradleVersion();
                    if (version2 != null) {
                        GradleVersion parsed = GradleVersion.parse((String)version2);
                        return parsed.compareIgnoringQualifiers("4.0") >= 0;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCause";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/errors/Gradle4AndPlugin2Dot2ErrorHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleError";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isGradleAndPluginMismatch";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

