/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.base.Strings;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlElement;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.UsesSdk;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveSdkFromManifestHyperlink
extends NotificationHyperlink {
    @NotNull
    private final Module myModule;

    public RemoveSdkFromManifestHyperlink(@NotNull Module module) {
        if (module == null) {
            RemoveSdkFromManifestHyperlink.$$$reportNull$$$0(0);
        }
        super("remove.sdk.from.manifest", RemoveSdkFromManifestHyperlink.getMessage(module));
        this.myModule = module;
    }

    @NotNull
    private static String getMessage(@NotNull Module module) {
        ResolvedPropertyModel minSdkInBuildFile;
        GradleBuildModel buildModel;
        if (module == null) {
            RemoveSdkFromManifestHyperlink.$$$reportNull$$$0(1);
        }
        if ((buildModel = RemoveSdkFromManifestHyperlink.getBuildModel(module)) != null && (minSdkInBuildFile = RemoveSdkFromManifestHyperlink.getMinSdkInBuildModel(buildModel)).getValueType() == GradlePropertyModel.ValueType.NONE) {
            if ("Move minSdkVersion to build file and sync project" == null) {
                RemoveSdkFromManifestHyperlink.$$$reportNull$$$0(2);
            }
            return "Move minSdkVersion to build file and sync project";
        }
        if ("Remove minSdkVersion and sync project" == null) {
            RemoveSdkFromManifestHyperlink.$$$reportNull$$$0(3);
        }
        return "Remove minSdkVersion and sync project";
    }

    @Nullable
    private static GradleBuildModel getBuildModel(@NotNull Module module) {
        if (module == null) {
            RemoveSdkFromManifestHyperlink.$$$reportNull$$$0(4);
        }
        return ProjectBuildModel.get(module.getProject()).getModuleBuildModel(module);
    }

    @NotNull
    private static ResolvedPropertyModel getMinSdkInBuildModel(@NotNull GradleBuildModel buildModel) {
        if (buildModel == null) {
            RemoveSdkFromManifestHyperlink.$$$reportNull$$$0(5);
        }
        ResolvedPropertyModel resolvedPropertyModel = buildModel.android().defaultConfig().minSdkVersion();
        if (resolvedPropertyModel == null) {
            RemoveSdkFromManifestHyperlink.$$$reportNull$$$0(6);
        }
        return resolvedPropertyModel;
    }

    @Override
    protected void execute(@NotNull Project project) {
        AndroidFacet androidFacet;
        if (project == null) {
            RemoveSdkFromManifestHyperlink.$$$reportNull$$$0(7);
        }
        if ((androidFacet = AndroidFacet.getInstance(this.myModule)) != null) {
            int minSdkInManifest = 14;
            Manifest manifest = androidFacet.getManifest();
            if (manifest != null) {
                ResolvedPropertyModel minSdkInBuildFile;
                for (UsesSdk usesSdk : manifest.getUsesSdks()) {
                    XmlElement element;
                    try {
                        minSdkInManifest = Integer.parseInt(Strings.nullToEmpty((String)usesSdk.getMinSdkVersion().getStringValue()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if ((element = usesSdk.getMinSdkVersion().getXmlElement()) == null) continue;
                    WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                        element.delete();
                        if (usesSdk.getXmlTag().getAttributes().length == 0) {
                            usesSdk.getXmlTag().delete();
                        }
                        FileDocumentManager.getInstance().saveAllDocuments();
                    });
                }
                GradleBuildModel buildModel = RemoveSdkFromManifestHyperlink.getBuildModel(this.myModule);
                if (buildModel != null && (minSdkInBuildFile = RemoveSdkFromManifestHyperlink.getMinSdkInBuildModel(buildModel)).getValueType() == GradlePropertyModel.ValueType.NONE) {
                    minSdkInBuildFile.setValue(minSdkInManifest);
                    WriteCommandAction.runWriteCommandAction((Project)project, buildModel::applyChanges);
                }
            }
        }
        GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/hyperlink/RemoveSdkFromManifestHyperlink";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/hyperlink/RemoveSdkFromManifestHyperlink";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinSdkInBuildModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBuildModel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMinSdkInBuildModel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

