/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.tools.idea.io.FilePaths;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;

class ProjectFinder {
    private static final Key<CopyOnWriteArrayList<Project>> NEW_PROJECTS_KEY = Key.create((String)"idea.gradle.sync.new.projects");

    ProjectFinder() {
    }

    static void registerAsNewProject(@NotNull Project project) {
        CopyOnWriteArrayList<Object> newProjects;
        if (project == null) {
            ProjectFinder.$$$reportNull$$$0(0);
        }
        if ((newProjects = ProjectFinder.getNewProjects()) == null) {
            newProjects = new CopyOnWriteArrayList();
            ApplicationManager.getApplication().putUserData(NEW_PROJECTS_KEY, newProjects);
        }
        newProjects.addIfAbsent(project);
    }

    static void unregisterAsNewProject(@NotNull Project project) {
        Application application;
        CopyOnWriteArrayList newProjects;
        if (project == null) {
            ProjectFinder.$$$reportNull$$$0(1);
        }
        if ((newProjects = (CopyOnWriteArrayList)(application = ApplicationManager.getApplication()).getUserData(NEW_PROJECTS_KEY)) != null) {
            newProjects.remove(project);
        }
    }

    @Nullable
    Project findProject(@NotNull ProjectResolverContext context) {
        String projectPath;
        if (context == null) {
            ProjectFinder.$$$reportNull$$$0(2);
        }
        if (StringUtil.isNotEmpty((String)(projectPath = context.getProjectPath()))) {
            File projectFolderPath = FilePaths.toSystemDependentPath((String)projectPath);
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                if (!ProjectFinder.hasMatchingPath(project, projectFolderPath)) continue;
                return project;
            }
            CopyOnWriteArrayList<Project> newProjects = ProjectFinder.getNewProjects();
            if (newProjects != null) {
                for (Project project : newProjects) {
                    if (!ProjectFinder.hasMatchingPath(project, projectFolderPath)) continue;
                    return project;
                }
            }
        }
        return null;
    }

    private static boolean hasMatchingPath(@NotNull Project project, @NotNull File path) {
        File currentPath;
        String basePath;
        if (project == null) {
            ProjectFinder.$$$reportNull$$$0(3);
        }
        if (path == null) {
            ProjectFinder.$$$reportNull$$$0(4);
        }
        return (basePath = project.getBasePath()) != null && FileUtil.filesEqual((File)path, (File)(currentPath = new File(basePath)));
    }

    @Nullable
    private static CopyOnWriteArrayList<Project> getNewProjects() {
        return (CopyOnWriteArrayList)ApplicationManager.getApplication().getUserData(NEW_PROJECTS_KEY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/idea/ProjectFinder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerAsNewProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterAsNewProject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findProject";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasMatchingPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

