/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Dependencies;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.project.sync.Modules;
import com.android.tools.idea.gradle.project.sync.ng.SyncModuleModels;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AndroidModule {
    @NotNull
    private final AndroidProject myAndroidProject;
    @NotNull
    private final SyncModuleModels myModuleModels;
    @NotNull
    private final List<ModuleDependency> myModuleDependencies;
    @NotNull
    private final Map<String, Variant> myVariantsByName;

    AndroidModule(@NotNull AndroidProject androidProject, @NotNull SyncModuleModels moduleModels) {
        if (androidProject == null) {
            AndroidModule.$$$reportNull$$$0(0);
        }
        if (moduleModels == null) {
            AndroidModule.$$$reportNull$$$0(1);
        }
        this.myModuleDependencies = new ArrayList<ModuleDependency>();
        this.myVariantsByName = new HashMap<String, Variant>();
        this.myAndroidProject = androidProject;
        this.myModuleModels = moduleModels;
    }

    void addSelectedVariant(@NotNull Variant selectedVariant) {
        if (selectedVariant == null) {
            AndroidModule.$$$reportNull$$$0(2);
        }
        this.myVariantsByName.put(selectedVariant.getName(), selectedVariant);
        AndroidArtifact artifact = selectedVariant.getMainArtifact();
        Dependencies dependencies = artifact.getDependencies();
        for (AndroidLibrary library : dependencies.getLibraries()) {
            String project = library.getProject();
            if (project == null) continue;
            String id = Modules.createUniqueModuleId(Strings.nullToEmpty((String)library.getBuildId()), project);
            String variant = library.getProjectVariant();
            ModuleDependency dependency = new ModuleDependency(id, variant);
            this.myModuleDependencies.add(dependency);
        }
    }

    @NotNull
    AndroidProject getAndroidProject() {
        AndroidProject androidProject = this.myAndroidProject;
        if (androidProject == null) {
            AndroidModule.$$$reportNull$$$0(3);
        }
        return androidProject;
    }

    @NotNull
    List<ModuleDependency> getModuleDependencies() {
        List<ModuleDependency> list = this.myModuleDependencies;
        if (list == null) {
            AndroidModule.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    SyncModuleModels getModuleModels() {
        SyncModuleModels syncModuleModels = this.myModuleModels;
        if (syncModuleModels == null) {
            AndroidModule.$$$reportNull$$$0(5);
        }
        return syncModuleModels;
    }

    boolean containsVariant(@NotNull String variantName) {
        if (variantName == null) {
            AndroidModule.$$$reportNull$$$0(6);
        }
        return this.myVariantsByName.containsKey(variantName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidProject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModels";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedVariant";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/AndroidModule";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/AndroidModule";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleDependencies";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addSelectedVariant";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "containsVariant";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ModuleDependency {
        @NotNull
        final String id;
        @Nullable
        final String variant;

        ModuleDependency(@NotNull String id, @Nullable String variant) {
            if (id == null) {
                ModuleDependency.$$$reportNull$$$0(0);
            }
            this.id = id;
            this.variant = variant;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/idea/gradle/project/sync/ng/AndroidModule$ModuleDependency", "<init>"));
        }
    }
}

