/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.sync.ng.SyncModuleModels;
import com.android.tools.idea.gradle.project.sync.ng.SyncProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.caching.CachedProjectModels;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.GradleProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.settings.CompositeDefinitionSource;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class CompositeBuildDataSetup {
    public void setupCompositeBuildData(@NotNull CachedProjectModels projectModels, @NotNull Project project) {
        if (projectModels == null) {
            CompositeBuildDataSetup.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CompositeBuildDataSetup.$$$reportNull$$$0(1);
        }
        CompositeBuildDataSetup.doSetupCompositeBuild(projectModels.getBuildParticipants(), project);
    }

    public void setupCompositeBuildData(@NotNull SyncProjectModels projectModels, @NotNull CachedProjectModels cache, @NotNull Project project) {
        if (projectModels == null) {
            CompositeBuildDataSetup.$$$reportNull$$$0(2);
        }
        if (cache == null) {
            CompositeBuildDataSetup.$$$reportNull$$$0(3);
        }
        if (project == null) {
            CompositeBuildDataSetup.$$$reportNull$$$0(4);
        }
        HashMap<String, BuildParticipant> compositeParticipants = new HashMap<String, BuildParticipant>();
        for (SyncModuleModels moduleModels : projectModels.getModuleModels()) {
            GradleProject gradleProject = moduleModels.findModel(GradleProject.class);
            BuildIdentifier moduleBuildId = moduleModels.getBuildId();
            if (gradleProject == null || moduleBuildId == projectModels.getRootBuildId()) continue;
            try {
                String buildPath = ExternalSystemApiUtil.toCanonicalPath((String)moduleBuildId.getRootDir().getCanonicalPath());
                BuildParticipant buildParticipant = compositeParticipants.computeIfAbsent(buildPath, p -> {
                    if (cache == null) {
                        CompositeBuildDataSetup.$$$reportNull$$$0(7);
                    }
                    BuildParticipant participant = new BuildParticipant();
                    cache.addBuildParticipant(participant);
                    return participant;
                });
                buildParticipant.setRootPath(buildPath);
                buildParticipant.getProjects().add(ExternalSystemApiUtil.toCanonicalPath((String)gradleProject.getProjectDirectory().getCanonicalPath()));
            }
            catch (IOException e) {
                Logger.getInstance(CompositeBuildDataSetup.class).warn("Fails to construct the canonical path for module", (Throwable)e);
            }
        }
        CompositeBuildDataSetup.doSetupCompositeBuild(new ArrayList<BuildParticipant>(compositeParticipants.values()), project);
    }

    private static void doSetupCompositeBuild(@NotNull List<BuildParticipant> buildParticipants, @NotNull Project project) {
        String projectPath;
        if (buildParticipants == null) {
            CompositeBuildDataSetup.$$$reportNull$$$0(5);
        }
        if (project == null) {
            CompositeBuildDataSetup.$$$reportNull$$$0(6);
        }
        if ((projectPath = project.getBasePath()) == null) {
            return;
        }
        GradleProjectSettings projectSettings = (GradleProjectSettings)GradleSettings.getInstance((Project)project).getLinkedProjectSettings(projectPath);
        if (projectSettings == null) {
            return;
        }
        GradleProjectSettings.CompositeBuild compositeBuild = new GradleProjectSettings.CompositeBuild();
        compositeBuild.setCompositeDefinitionSource(CompositeDefinitionSource.SCRIPT);
        compositeBuild.setCompositeParticipants(buildParticipants);
        projectSettings.setCompositeBuild(compositeBuild);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectModels";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildParticipants";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/CompositeBuildDataSetup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setupCompositeBuildData";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "doSetupCompositeBuild";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$setupCompositeBuildData$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

