/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.ModelBuilderParameter;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.project.sync.Modules;
import com.android.tools.idea.gradle.project.sync.ng.AndroidModule;
import com.android.tools.idea.gradle.project.sync.ng.SelectedVariants;
import com.android.tools.idea.gradle.project.sync.ng.SyncModuleModels;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.Model;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SelectedVariantChooser
implements Serializable {
    SelectedVariantChooser() {
    }

    void chooseSelectedVariants(@NotNull List<SyncModuleModels> projectModels, @NotNull BuildController controller, @NotNull SelectedVariants selectedVariants) {
        if (projectModels == null) {
            SelectedVariantChooser.$$$reportNull$$$0(0);
        }
        if (controller == null) {
            SelectedVariantChooser.$$$reportNull$$$0(1);
        }
        if (selectedVariants == null) {
            SelectedVariantChooser.$$$reportNull$$$0(2);
        }
        HashMap<String, AndroidModule> modulesById = new HashMap<String, AndroidModule>();
        LinkedList<String> allModules = new LinkedList<String>();
        HashSet<String> visitedModules = new HashSet<String>();
        for (SyncModuleModels moduleModels : projectModels) {
            AndroidProject androidProject = moduleModels.findModel(AndroidProject.class);
            GradleProject gradleProject = moduleModels.findModel(GradleProject.class);
            if (gradleProject == null || androidProject == null || !androidProject.getVariants().isEmpty()) continue;
            AndroidModule module = new AndroidModule(androidProject, moduleModels);
            String id = Modules.createUniqueModuleId(gradleProject);
            modulesById.put(id, module);
            if (androidProject.getProjectType() == 0) {
                allModules.addFirst(id);
                continue;
            }
            allModules.addLast(id);
        }
        for (String moduleId : allModules) {
            if (visitedModules.contains(moduleId)) continue;
            visitedModules.add(moduleId);
            AndroidModule module = (AndroidModule)modulesById.get(moduleId);
            Objects.requireNonNull(module);
            Variant variant = SelectedVariantChooser.selectVariantForAppOrLeaf(module, controller, selectedVariants);
            if (variant == null) continue;
            module.addSelectedVariant(variant);
            SelectedVariantChooser.selectVariantForDependencyModules(module, controller, modulesById, visitedModules);
        }
    }

    private static void selectVariantForDependencyModules(@NotNull AndroidModule androidModule, @NotNull BuildController controller, @NotNull Map<String, AndroidModule> libModulesById, @NotNull Set<String> visitedModules) {
        if (androidModule == null) {
            SelectedVariantChooser.$$$reportNull$$$0(3);
        }
        if (controller == null) {
            SelectedVariantChooser.$$$reportNull$$$0(4);
        }
        if (libModulesById == null) {
            SelectedVariantChooser.$$$reportNull$$$0(5);
        }
        if (visitedModules == null) {
            SelectedVariantChooser.$$$reportNull$$$0(6);
        }
        for (AndroidModule.ModuleDependency dependency : androidModule.getModuleDependencies()) {
            Variant dependencyVariant;
            AndroidModule dependencyModule;
            String dependencyModuleId = dependency.id;
            visitedModules.add(dependencyModuleId);
            String variantName = dependency.variant;
            if (variantName == null || (dependencyModule = libModulesById.get(dependencyModuleId)) == null || dependencyModule.containsVariant(variantName) || (dependencyVariant = SelectedVariantChooser.syncAndAddVariant(variantName, dependencyModule.getModuleModels(), controller)) == null) continue;
            dependencyModule.addSelectedVariant(dependencyVariant);
            SelectedVariantChooser.selectVariantForDependencyModules(dependencyModule, controller, libModulesById, visitedModules);
        }
    }

    @Nullable
    private static Variant selectVariantForAppOrLeaf(@NotNull AndroidModule androidModule, @NotNull BuildController controller, @NotNull SelectedVariants selectedVariants) {
        if (androidModule == null) {
            SelectedVariantChooser.$$$reportNull$$$0(7);
        }
        if (controller == null) {
            SelectedVariantChooser.$$$reportNull$$$0(8);
        }
        if (selectedVariants == null) {
            SelectedVariantChooser.$$$reportNull$$$0(9);
        }
        SyncModuleModels moduleModels = androidModule.getModuleModels();
        GradleProject gradleProject = moduleModels.findModel(GradleProject.class);
        Objects.requireNonNull(gradleProject);
        String moduleId = Modules.createUniqueModuleId(gradleProject);
        String variant = selectedVariants.getSelectedVariant(moduleId);
        if (variant == null) {
            variant = SelectedVariantChooser.getDebugOrFirstVariant(androidModule.getAndroidProject());
        }
        return variant != null ? SelectedVariantChooser.syncAndAddVariant(variant, androidModule.getModuleModels(), controller) : null;
    }

    @Nullable
    private static String getDebugOrFirstVariant(@NotNull AndroidProject androidProject) {
        ArrayList names;
        int nameCount;
        if (androidProject == null) {
            SelectedVariantChooser.$$$reportNull$$$0(10);
        }
        if ((nameCount = (names = androidProject.getVariantNames()).size()) == 0) {
            return null;
        }
        String debugVariant = "debug";
        if (names.contains(debugVariant)) {
            return debugVariant;
        }
        if (nameCount > 1) {
            ArrayList sortedNames = new ArrayList(names);
            sortedNames.sort(String::compareTo);
            names = sortedNames;
        }
        return names instanceof List ? (String)((List)names).get(0) : (String)names.iterator().next();
    }

    @Nullable
    private static Variant syncAndAddVariant(@NotNull String variantName, @NotNull SyncModuleModels moduleModels, @NotNull BuildController controller) {
        if (variantName == null) {
            SelectedVariantChooser.$$$reportNull$$$0(11);
        }
        if (moduleModels == null) {
            SelectedVariantChooser.$$$reportNull$$$0(12);
        }
        if (controller == null) {
            SelectedVariantChooser.$$$reportNull$$$0(13);
        }
        GradleProject gradleProject = moduleModels.findModel(GradleProject.class);
        Objects.requireNonNull(gradleProject);
        Variant variant = (Variant)controller.getModel((Model)gradleProject, Variant.class, ModelBuilderParameter.class, parameter -> {
            if (variantName == null) {
                SelectedVariantChooser.$$$reportNull$$$0(14);
            }
            parameter.setVariantName(variantName);
        });
        if (variant != null) {
            moduleModels.addModel(Variant.class, variant);
        }
        return variant;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectModels";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedVariants";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModule";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libModulesById";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedModules";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidProject";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModels";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/SelectedVariantChooser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "chooseSelectedVariants";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "selectVariantForDependencyModules";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "selectVariantForAppOrLeaf";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getDebugOrFirstVariant";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "syncAndAddVariant";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$syncAndAddVariant$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

