/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.sync.Modules;
import com.android.tools.idea.gradle.project.sync.ng.SelectedVariants;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.io.File;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SelectedVariantCollector {
    @NotNull
    private final Project myProject;

    SelectedVariantCollector(@NotNull Project project) {
        if (project == null) {
            SelectedVariantCollector.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    SelectedVariants collectSelectedVariants() {
        SelectedVariants selectedVariants = new SelectedVariants();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            SelectedVariant variant = this.findSelectedVariant(module);
            if (variant == null) continue;
            selectedVariants.addSelectedVariant(variant.moduleId, variant.variantName);
        }
        SelectedVariants selectedVariants2 = selectedVariants;
        if (selectedVariants2 == null) {
            SelectedVariantCollector.$$$reportNull$$$0(1);
        }
        return selectedVariants2;
    }

    @VisibleForTesting
    @Nullable
    SelectedVariant findSelectedVariant(@NotNull Module module) {
        AndroidFacet androidFacet;
        GradleModuleModel gradleModel;
        GradleFacet gradleFacet;
        if (module == null) {
            SelectedVariantCollector.$$$reportNull$$$0(2);
        }
        if ((gradleFacet = GradleFacet.getInstance(module)) != null && (gradleModel = gradleFacet.getGradleModuleModel()) != null && (androidFacet = AndroidFacet.getInstance(module)) != null) {
            return new SelectedVariant(androidFacet, gradleModel.getRootFolderPath(), ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/SelectedVariantCollector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/SelectedVariantCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSelectedVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findSelectedVariant";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class SelectedVariant {
        @NotNull
        final String moduleId;
        @NotNull
        final String variantName;

        SelectedVariant(@NotNull AndroidFacet androidFacet, @NotNull File rootFolderPath, @NotNull String gradlePath) {
            if (androidFacet == null) {
                SelectedVariant.$$$reportNull$$$0(0);
            }
            if (rootFolderPath == null) {
                SelectedVariant.$$$reportNull$$$0(1);
            }
            if (gradlePath == null) {
                SelectedVariant.$$$reportNull$$$0(2);
            }
            this.moduleId = Modules.createUniqueModuleId(rootFolderPath, gradlePath);
            this.variantName = androidFacet.getProperties().SELECTED_BUILD_VARIANT;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "androidFacet";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rootFolderPath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "gradlePath";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/project/sync/ng/SelectedVariantCollector$SelectedVariant";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

