/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.Projects;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.sync.common.CommandLineArgs;
import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandlerManager;
import com.android.tools.idea.gradle.project.sync.ng.ExtraGradleSyncModelsManager;
import com.android.tools.idea.gradle.project.sync.ng.GradleSyncProgress;
import com.android.tools.idea.gradle.project.sync.ng.SelectedVariantCollector;
import com.android.tools.idea.gradle.project.sync.ng.SelectedVariants;
import com.android.tools.idea.gradle.project.sync.ng.SyncAction;
import com.android.tools.idea.gradle.project.sync.ng.SyncActionOptions;
import com.android.tools.idea.gradle.project.sync.ng.SyncExecutionCallback;
import com.android.tools.idea.gradle.project.sync.ng.SyncProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.variantonly.VariantOnlyProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.variantonly.VariantOnlySyncAction;
import com.android.tools.idea.gradle.project.sync.ng.variantonly.VariantOnlySyncOptions;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.OutputBuildEventImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.output.BuildOutputInstantReaderImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import java.util.Collections;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ProjectConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

class SyncExecutor {
    @NotNull
    private final Project myProject;
    @NotNull
    private final CommandLineArgs myCommandLineArgs;
    @NotNull
    private final SyncErrorHandlerManager myErrorHandlerManager;
    @NotNull
    private final ExtraGradleSyncModelsManager myExtraModelsManager;
    @NotNull
    private final SelectedVariantCollector mySelectedVariantCollector;
    @NotNull
    private final GradleExecutionHelper myHelper;

    SyncExecutor(@NotNull Project project) {
        if (project == null) {
            SyncExecutor.$$$reportNull$$$0(0);
        }
        this(project, ExtraGradleSyncModelsManager.getInstance(), new CommandLineArgs(true), new SyncErrorHandlerManager(project), new SelectedVariantCollector(project));
    }

    @VisibleForTesting
    SyncExecutor(@NotNull Project project, @NotNull ExtraGradleSyncModelsManager extraModelsManager, @NotNull CommandLineArgs commandLineArgs, @NotNull SyncErrorHandlerManager errorHandlerManager, @NotNull SelectedVariantCollector selectedVariantCollector) {
        if (project == null) {
            SyncExecutor.$$$reportNull$$$0(1);
        }
        if (extraModelsManager == null) {
            SyncExecutor.$$$reportNull$$$0(2);
        }
        if (commandLineArgs == null) {
            SyncExecutor.$$$reportNull$$$0(3);
        }
        if (errorHandlerManager == null) {
            SyncExecutor.$$$reportNull$$$0(4);
        }
        if (selectedVariantCollector == null) {
            SyncExecutor.$$$reportNull$$$0(5);
        }
        this.myHelper = new GradleExecutionHelper();
        this.myProject = project;
        this.myCommandLineArgs = commandLineArgs;
        this.myErrorHandlerManager = errorHandlerManager;
        this.myExtraModelsManager = extraModelsManager;
        this.mySelectedVariantCollector = selectedVariantCollector;
    }

    void syncProject(@NotNull ProgressIndicator indicator, @NotNull SyncExecutionCallback callback) {
        if (indicator == null) {
            SyncExecutor.$$$reportNull$$$0(6);
        }
        if (callback == null) {
            SyncExecutor.$$$reportNull$$$0(7);
        }
        this.syncProject(indicator, callback, null);
    }

    void syncProject(@NotNull ProgressIndicator indicator, @NotNull SyncExecutionCallback callback, @Nullable VariantOnlySyncOptions options) {
        if (indicator == null) {
            SyncExecutor.$$$reportNull$$$0(8);
        }
        if (callback == null) {
            SyncExecutor.$$$reportNull$$$0(9);
        }
        if (this.myProject.isDisposed()) {
            callback.reject(String.format("Project '%1$s' is already disposed", this.myProject.getName()));
        }
        GradleExecutionSettings executionSettings = GradleUtil.getOrCreateGradleExecutionSettings(this.myProject);
        executionSettings.withArguments(this.myCommandLineArgs.get(this.myProject)).withVmOptions(Collections.emptyList());
        Function syncFunction = connection -> {
            if (indicator == null) {
                SyncExecutor.$$$reportNull$$$0(30);
            }
            if (callback == null) {
                SyncExecutor.$$$reportNull$$$0(31);
            }
            this.syncProject((ProjectConnection)connection, executionSettings, indicator, callback, options);
            return null;
        };
        try {
            this.myHelper.execute(Projects.getBaseDirPath((Project)this.myProject).getPath(), executionSettings, syncFunction);
        }
        catch (Throwable e) {
            callback.setRejected(e);
        }
    }

    private void syncProject(@NotNull ProjectConnection connection, @NotNull GradleExecutionSettings executionSettings, @NotNull ProgressIndicator indicator, @NotNull SyncExecutionCallback callback, @Nullable VariantOnlySyncOptions options) {
        if (connection == null) {
            SyncExecutor.$$$reportNull$$$0(10);
        }
        if (executionSettings == null) {
            SyncExecutor.$$$reportNull$$$0(11);
        }
        if (indicator == null) {
            SyncExecutor.$$$reportNull$$$0(12);
        }
        if (callback == null) {
            SyncExecutor.$$$reportNull$$$0(13);
        }
        ExternalSystemTaskId id = SyncExecutor.createId(this.myProject);
        SyncViewManager syncViewManager = (SyncViewManager)ServiceManager.getService((Project)this.myProject, SyncViewManager.class);
        BuildOutputInstantReaderImpl buildOutputReader = new BuildOutputInstantReaderImpl((Object)id, (BuildProgressListener)syncViewManager, Collections.emptyList());
        String projectPath = Projects.getBaseDirPath((Project)this.myProject).getPath();
        DefaultBuildDescriptor buildDescriptor = new DefaultBuildDescriptor((Object)id, this.myProject.getName(), projectPath, System.currentTimeMillis());
        StartBuildEventImpl startEvent = new StartBuildEventImpl((BuildDescriptor)buildDescriptor, "syncing...");
        syncViewManager.onEvent((BuildEvent)startEvent);
        try {
            if (options == null) {
                this.executeFullSync(connection, executionSettings, indicator, id, buildOutputReader, callback);
            } else {
                this.executeVariantOnlySync(connection, executionSettings, indicator, id, buildOutputReader, callback, options);
            }
        }
        catch (RuntimeException e) {
            this.myErrorHandlerManager.handleError(e);
            callback.setRejected(e);
            Runnable runnable = () -> PostSyncProjectSetup.finishFailedSync(id, this.myProject);
            ApplicationManager.getApplication().invokeLater(runnable);
        }
        buildOutputReader.close();
    }

    void executeFullSync(@NotNull ProjectConnection connection, @NotNull GradleExecutionSettings executionSettings, @NotNull ProgressIndicator indicator, @NotNull ExternalSystemTaskId id, @NotNull BuildOutputInstantReaderImpl buildOutputReader, @NotNull SyncExecutionCallback callback) {
        if (connection == null) {
            SyncExecutor.$$$reportNull$$$0(14);
        }
        if (executionSettings == null) {
            SyncExecutor.$$$reportNull$$$0(15);
        }
        if (indicator == null) {
            SyncExecutor.$$$reportNull$$$0(16);
        }
        if (id == null) {
            SyncExecutor.$$$reportNull$$$0(17);
        }
        if (buildOutputReader == null) {
            SyncExecutor.$$$reportNull$$$0(18);
        }
        if (callback == null) {
            SyncExecutor.$$$reportNull$$$0(19);
        }
        SyncAction syncAction = this.createSyncAction();
        BuildActionExecuter executor = connection.action((BuildAction)syncAction);
        GradleExecutionHelper.prepare((LongRunningOperation)executor, (ExternalSystemTaskId)id, (GradleExecutionSettings)executionSettings, (ExternalSystemTaskNotificationListener)new GradleSyncNotificationListener(id, indicator, buildOutputReader), (ProjectConnection)connection);
        CancellationTokenSource cancellationTokenSource = GradleConnector.newCancellationTokenSource();
        executor.withCancellationToken(cancellationTokenSource.token());
        callback.setDone((SyncProjectModels)executor.run(), id);
    }

    void executeVariantOnlySync(@NotNull ProjectConnection connection, @NotNull GradleExecutionSettings executionSettings, @NotNull ProgressIndicator indicator, @NotNull ExternalSystemTaskId id, @NotNull BuildOutputInstantReaderImpl buildOutputReader, @NotNull SyncExecutionCallback callback, @NotNull VariantOnlySyncOptions options) {
        if (connection == null) {
            SyncExecutor.$$$reportNull$$$0(20);
        }
        if (executionSettings == null) {
            SyncExecutor.$$$reportNull$$$0(21);
        }
        if (indicator == null) {
            SyncExecutor.$$$reportNull$$$0(22);
        }
        if (id == null) {
            SyncExecutor.$$$reportNull$$$0(23);
        }
        if (buildOutputReader == null) {
            SyncExecutor.$$$reportNull$$$0(24);
        }
        if (callback == null) {
            SyncExecutor.$$$reportNull$$$0(25);
        }
        if (options == null) {
            SyncExecutor.$$$reportNull$$$0(26);
        }
        VariantOnlySyncAction syncAction = new VariantOnlySyncAction(options);
        BuildActionExecuter executor = connection.action((BuildAction)syncAction);
        GradleExecutionHelper.prepare((LongRunningOperation)executor, (ExternalSystemTaskId)id, (GradleExecutionSettings)executionSettings, (ExternalSystemTaskNotificationListener)new GradleSyncNotificationListener(id, indicator, buildOutputReader), (ProjectConnection)connection);
        callback.setDone((VariantOnlyProjectModels)executor.run(), id);
    }

    @VisibleForTesting
    @NotNull
    SyncAction createSyncAction() {
        SyncActionOptions options = new SyncActionOptions();
        options.setSingleVariantSyncEnabled((Boolean)StudioFlags.SINGLE_VARIANT_SYNC_ENABLED.get());
        if (options.isSingleVariantSyncEnabled()) {
            SelectedVariants selectedVariants = this.mySelectedVariantCollector.collectSelectedVariants();
            options.setSelectedVariants(selectedVariants);
        }
        SyncAction syncAction = new SyncAction(this.myExtraModelsManager.getAndroidModelTypes(), this.myExtraModelsManager.getJavaModelTypes(), options);
        if (syncAction == null) {
            SyncExecutor.$$$reportNull$$$0(27);
        }
        return syncAction;
    }

    @NotNull
    private static ExternalSystemTaskId createId(@NotNull Project project) {
        if (project == null) {
            SyncExecutor.$$$reportNull$$$0(28);
        }
        ExternalSystemTaskId externalSystemTaskId = ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)project);
        if (externalSystemTaskId == null) {
            SyncExecutor.$$$reportNull$$$0(29);
        }
        return externalSystemTaskId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 27: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 27: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraModelsManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineArgs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandlerManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedVariantCollector";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 16: 
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: 
            case 9: 
            case 13: 
            case 19: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 10: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 11: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionSettings";
                break;
            }
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildOutputReader";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/SyncExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/SyncExecutor";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createSyncAction";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "syncProject";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "executeFullSync";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "executeVariantOnlySync";
                break;
            }
            case 27: 
            case 29: {
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createId";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$syncProject$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 27: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class GradleSyncNotificationListener
    extends ExternalSystemTaskNotificationListenerAdapter {
        @NotNull
        private final ProgressIndicator myIndicator;
        @NotNull
        private final ExternalSystemTaskId myTaskId;
        @NotNull
        private final BuildOutputInstantReaderImpl myOutputReader;

        GradleSyncNotificationListener(@NotNull ExternalSystemTaskId taskId, @NotNull ProgressIndicator indicator, @NotNull BuildOutputInstantReaderImpl outputReader) {
            if (taskId == null) {
                GradleSyncNotificationListener.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                GradleSyncNotificationListener.$$$reportNull$$$0(1);
            }
            if (outputReader == null) {
                GradleSyncNotificationListener.$$$reportNull$$$0(2);
            }
            this.myIndicator = indicator;
            this.myTaskId = taskId;
            this.myOutputReader = outputReader;
        }

        public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text, boolean stdOut) {
            Project project;
            if (id == null) {
                GradleSyncNotificationListener.$$$reportNull$$$0(3);
            }
            if (text == null) {
                GradleSyncNotificationListener.$$$reportNull$$$0(4);
            }
            if ((project = this.myTaskId.findProject()) == null) {
                return;
            }
            ((SyncViewManager)ServiceManager.getService((Project)project, SyncViewManager.class)).onEvent((BuildEvent)new OutputBuildEventImpl((Object)id, text, stdOut));
            this.myOutputReader.append((CharSequence)text);
        }

        public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
            if (event == null) {
                GradleSyncNotificationListener.$$$reportNull$$$0(5);
            }
            GradleSyncProgress.notifyProgress(this.myIndicator, event.getDescription());
            if (event instanceof ExternalSystemTaskExecutionEvent) {
                Project project = this.myTaskId.findProject();
                if (project == null) {
                    return;
                }
                BuildEvent buildEvent = ExternalSystemUtil.convert((ExternalSystemTaskExecutionEvent)((ExternalSystemTaskExecutionEvent)event));
                ((SyncViewManager)ServiceManager.getService((Project)project, SyncViewManager.class)).onEvent(buildEvent);
            }
        }

        public void onEnd(@NotNull ExternalSystemTaskId id) {
            if (id == null) {
                GradleSyncNotificationListener.$$$reportNull$$$0(6);
            }
            this.myOutputReader.close();
        }

        public void onCancel(@NotNull ExternalSystemTaskId id) {
            if (id == null) {
                GradleSyncNotificationListener.$$$reportNull$$$0(7);
            }
            super.onCancel(id);
            Project project = this.myTaskId.findProject();
            if (project != null) {
                FinishBuildEventImpl event = new FinishBuildEventImpl((Object)id, null, System.currentTimeMillis(), "cancelled", (EventResult)new SkippedResultImpl());
                ((SyncViewManager)ServiceManager.getService((Project)project, SyncViewManager.class)).onEvent((BuildEvent)event);
            }
            this.myOutputReader.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputReader";
                    break;
                }
                case 3: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/SyncExecutor$GradleSyncNotificationListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onTaskOutput";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onStatusChange";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onEnd";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onCancel";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

