/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.ModelBuilderParameter;
import com.android.builder.model.NativeAndroidProject;
import com.android.java.model.ArtifactModel;
import com.android.java.model.JavaProject;
import com.android.tools.idea.gradle.project.sync.ng.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.ng.SyncActionOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.Model;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyncModuleModels
implements GradleModuleModels {
    private static final long serialVersionUID = 3L;
    @NotNull
    private final BuildIdentifier myBuildId;
    @NotNull
    private final Set<Class<?>> myExtraAndroidModelTypes;
    @NotNull
    private final Set<Class<?>> myExtraJavaModelTypes;
    @NotNull
    private final SyncActionOptions myOptions;
    @NotNull
    private final Map<Class, List<Object>> myModelsByType;
    @NotNull
    private String myModuleName;

    SyncModuleModels(@NotNull GradleProject gradleProject, @NotNull BuildIdentifier buildId, @NotNull Set<Class<?>> extraAndroidModelTypes, @NotNull Set<Class<?>> extraJavaModelTypes, @NotNull SyncActionOptions options) {
        if (gradleProject == null) {
            SyncModuleModels.$$$reportNull$$$0(0);
        }
        if (buildId == null) {
            SyncModuleModels.$$$reportNull$$$0(1);
        }
        if (extraAndroidModelTypes == null) {
            SyncModuleModels.$$$reportNull$$$0(2);
        }
        if (extraJavaModelTypes == null) {
            SyncModuleModels.$$$reportNull$$$0(3);
        }
        if (options == null) {
            SyncModuleModels.$$$reportNull$$$0(4);
        }
        this.myModelsByType = new HashMap<Class, List<Object>>();
        this.myBuildId = buildId;
        this.myExtraAndroidModelTypes = extraAndroidModelTypes;
        this.myExtraJavaModelTypes = extraJavaModelTypes;
        this.myModuleName = gradleProject.getName();
        this.myOptions = options;
    }

    void populate(@NotNull GradleProject gradleProject, @NotNull BuildController controller) {
        if (gradleProject == null) {
            SyncModuleModels.$$$reportNull$$$0(5);
        }
        if (controller == null) {
            SyncModuleModels.$$$reportNull$$$0(6);
        }
        this.addModel(GradleProject.class, gradleProject);
        AndroidProject androidProject = this.findAndAddAndroidProject(gradleProject, controller);
        if (androidProject != null) {
            this.findAndAddModel(gradleProject, controller, NativeAndroidProject.class);
            for (Class<?> type : this.myExtraAndroidModelTypes) {
                this.findAndAddModel(gradleProject, controller, type);
            }
            return;
        }
        JavaProject javaProject = this.findAndAddModel(gradleProject, controller, JavaProject.class);
        if (javaProject != null) {
            for (Class<?> type : this.myExtraJavaModelTypes) {
                this.findAndAddModel(gradleProject, controller, type);
            }
            return;
        }
        this.findAndAddModel(gradleProject, controller, ArtifactModel.class);
    }

    @Nullable
    private AndroidProject findAndAddAndroidProject(@NotNull GradleProject gradleProject, @NotNull BuildController controller) {
        if (gradleProject == null) {
            SyncModuleModels.$$$reportNull$$$0(7);
        }
        if (controller == null) {
            SyncModuleModels.$$$reportNull$$$0(8);
        }
        if (this.myOptions.isSingleVariantSyncEnabled()) {
            try {
                AndroidProject androidProject = (AndroidProject)controller.getModel((Model)gradleProject, AndroidProject.class, ModelBuilderParameter.class, parameter -> parameter.setShouldBuildVariant(false));
                if (androidProject != null) {
                    this.addModel(AndroidProject.class, androidProject);
                    return androidProject;
                }
            }
            catch (UnsupportedVersionException unsupportedVersionException) {
                // empty catch block
            }
        }
        return this.findAndAddModel(gradleProject, controller, AndroidProject.class);
    }

    @Nullable
    private <T> T findAndAddModel(@NotNull GradleProject gradleProject, @NotNull BuildController controller, @NotNull Class<T> modelType) {
        Object model;
        if (gradleProject == null) {
            SyncModuleModels.$$$reportNull$$$0(9);
        }
        if (controller == null) {
            SyncModuleModels.$$$reportNull$$$0(10);
        }
        if (modelType == null) {
            SyncModuleModels.$$$reportNull$$$0(11);
        }
        if ((model = controller.findModel((Model)gradleProject, modelType)) != null) {
            this.addModel(modelType, model);
        }
        return (T)model;
    }

    @Override
    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            SyncModuleModels.$$$reportNull$$$0(12);
        }
        return string;
    }

    public void deduplicateModuleName() {
        this.myModuleName = this.myBuildId.getRootDir().getName() + "-" + this.myModuleName;
    }

    @NotNull
    public BuildIdentifier getBuildId() {
        BuildIdentifier buildIdentifier = this.myBuildId;
        if (buildIdentifier == null) {
            SyncModuleModels.$$$reportNull$$$0(13);
        }
        return buildIdentifier;
    }

    @Override
    @Nullable
    public <T> T findModel(@NotNull Class<T> modelType) {
        List<Object> models;
        if (modelType == null) {
            SyncModuleModels.$$$reportNull$$$0(14);
        }
        if ((models = this.myModelsByType.get(modelType)) == null || models.isEmpty()) {
            return null;
        }
        assert (models.size() == 1) : "More than one models available, please use findModels() instead.";
        Object model = models.get(0);
        assert (modelType.isInstance(model));
        return modelType.cast(model);
    }

    @Override
    @Nullable
    public <T> List<T> findModels(@NotNull Class<T> modelType) {
        List<Object> models;
        if (modelType == null) {
            SyncModuleModels.$$$reportNull$$$0(15);
        }
        if ((models = this.myModelsByType.get(modelType)) == null || models.isEmpty()) {
            return null;
        }
        return models.stream().map(model -> {
            if (modelType == null) {
                SyncModuleModels.$$$reportNull$$$0(18);
            }
            assert (modelType.isInstance(model));
            return modelType.cast(model);
        }).collect(Collectors.toList());
    }

    <T> void addModel(@NotNull Class<T> modelType, @NotNull T model) {
        if (modelType == null) {
            SyncModuleModels.$$$reportNull$$$0(16);
        }
        if (model == null) {
            SyncModuleModels.$$$reportNull$$$0(17);
        }
        List models = this.myModelsByType.computeIfAbsent(modelType, k -> new ArrayList());
        models.add(model);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraAndroidModelTypes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraJavaModelTypes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelType";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/SyncModuleModels";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/SyncModuleModels";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "populate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findAndAddAndroidProject";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findAndAddModel";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findModel";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findModels";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addModel";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findModels$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

