/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng.caching;

import com.android.tools.idea.gradle.project.sync.ng.caching.CachedModuleModels;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;

public class CachedProjectModels
implements Serializable {
    private static final long serialVersionUID = 2L;
    @NotNull
    private final Map<String, CachedModuleModels> myModelsByModuleName = new HashMap<String, CachedModuleModels>();
    @NotNull
    private final List<BuildParticipant> myBuildParticipants = new ArrayList<BuildParticipant>();

    @VisibleForTesting
    CachedProjectModels() {
    }

    @NotNull
    public List<BuildParticipant> getBuildParticipants() {
        List<BuildParticipant> list = this.myBuildParticipants;
        if (list == null) {
            CachedProjectModels.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void addBuildParticipant(@NotNull BuildParticipant buildParticipant) {
        if (buildParticipant == null) {
            CachedProjectModels.$$$reportNull$$$0(1);
        }
        this.myBuildParticipants.add(buildParticipant);
    }

    @NotNull
    public CachedModuleModels addModule(@NotNull Module module) {
        if (module == null) {
            CachedProjectModels.$$$reportNull$$$0(2);
        }
        CachedModuleModels cache = new CachedModuleModels(module);
        this.myModelsByModuleName.put(module.getName(), cache);
        CachedModuleModels cachedModuleModels = cache;
        if (cachedModuleModels == null) {
            CachedProjectModels.$$$reportNull$$$0(3);
        }
        return cachedModuleModels;
    }

    @Nullable
    public CachedModuleModels findCacheForModule(@NotNull String moduleName) {
        if (moduleName == null) {
            CachedProjectModels.$$$reportNull$$$0(4);
        }
        return this.myModelsByModuleName.get(moduleName);
    }

    @NotNull
    public Future<?> saveToDisk(@NotNull Project project) {
        if (project == null) {
            CachedProjectModels.$$$reportNull$$$0(5);
        }
        File cacheFilePath = CachedProjectModels.getCacheFilePath(project);
        Future<?> future2 = this.saveToDisk(cacheFilePath);
        if (future2 == null) {
            CachedProjectModels.$$$reportNull$$$0(6);
        }
        return future2;
    }

    @VisibleForTesting
    @NotNull
    static File getCacheFilePath(@NotNull Project project) {
        if (project == null) {
            CachedProjectModels.$$$reportNull$$$0(7);
        }
        File file = new File(GradleUtil.getCacheFolderRootPath(project), "gradle_models.ser");
        if (file == null) {
            CachedProjectModels.$$$reportNull$$$0(8);
        }
        return file;
    }

    @NotNull
    private Future<?> saveToDisk(@NotNull File path) {
        if (path == null) {
            CachedProjectModels.$$$reportNull$$$0(9);
        }
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (path == null) {
                CachedProjectModels.$$$reportNull$$$0(12);
            }
            try {
                FileUtil.ensureExists((File)path.getParentFile());
            }
            catch (IOException e) {
                CachedProjectModels.getLog().warn(String.format("Failed to create folders for path '%1$s'", path.getPath()), (Throwable)e);
            }
            try (FileOutputStream fos = new FileOutputStream(path);){
                try (ObjectOutputStream oos = new ObjectOutputStream(fos);){
                    oos.writeObject(this);
                }
                catch (Throwable e) {
                    CachedProjectModels.getLog().warn(String.format("Failed to save Gradle models to path '%1$s'", path.getPath()), e);
                }
            }
            catch (Throwable e) {
                CachedProjectModels.getLog().warn(String.format("Failed to open path '%1$s'", path.getPath()), e);
            }
        });
        if (future2 == null) {
            CachedProjectModels.$$$reportNull$$$0(10);
        }
        return future2;
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(CachedProjectModels.class);
        if (logger == null) {
            CachedProjectModels.$$$reportNull$$$0(11);
        }
        return logger;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CachedProjectModels)) {
            return false;
        }
        CachedProjectModels cache = (CachedProjectModels)o;
        return Objects.equals(this.myModelsByModuleName, cache.myModelsByModuleName) && Objects.equals(this.myBuildParticipants, cache.myBuildParticipants);
    }

    public int hashCode() {
        return Objects.hash(this.myModelsByModuleName, this.myBuildParticipants);
    }

    public String toString() {
        return "CachedProjectModels{myModelsByModuleName=" + this.myModelsByModuleName + "myBuildParticipants=" + this.myBuildParticipants + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/caching/CachedProjectModels";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildParticipant";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildParticipants";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/caching/CachedProjectModels";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "addModule";
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "saveToDisk";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheFilePath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addBuildParticipant";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addModule";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findCacheForModule";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "saveToDisk";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCacheFilePath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$saveToDisk$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Loader {
        /*
         * Loose catch block
         * Enabled aggressive exception aggregation
         */
        @Nullable
        public CachedProjectModels loadFromDisk(@NotNull Project project) {
            block33: {
                File cacheFilePath;
                if (project == null) {
                    Loader.$$$reportNull$$$0(0);
                }
                if (!(cacheFilePath = CachedProjectModels.getCacheFilePath(project)).isFile()) break block33;
                try {
                    Throwable throwable = null;
                    try (FileInputStream fis = new FileInputStream(cacheFilePath);){
                        CachedProjectModels cachedProjectModels;
                        Throwable throwable2;
                        ObjectInputStream ois;
                        block31: {
                            block32: {
                                ois = new ObjectInputStream(fis);
                                throwable2 = null;
                                cachedProjectModels = (CachedProjectModels)ois.readObject();
                                if (ois == null) break block31;
                                if (throwable2 == null) break block32;
                                try {
                                    ois.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                break block31;
                            }
                            ois.close();
                        }
                        return cachedProjectModels;
                        catch (Throwable throwable4) {
                            try {
                                try {
                                    try {
                                        throwable2 = throwable4;
                                        throw throwable4;
                                    }
                                    catch (Throwable throwable5) {
                                        if (ois != null) {
                                            if (throwable2 != null) {
                                                try {
                                                    ois.close();
                                                }
                                                catch (Throwable throwable6) {
                                                    throwable2.addSuppressed(throwable6);
                                                }
                                            } else {
                                                ois.close();
                                            }
                                        }
                                        throw throwable5;
                                    }
                                }
                                catch (Throwable e) {
                                    CachedProjectModels.getLog().warn(String.format("Failed to load Gradle models from '%1$s'", cacheFilePath.getPath()), e);
                                }
                            }
                            catch (Throwable throwable7) {
                                throwable = throwable7;
                                throw throwable7;
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    CachedProjectModels.getLog().warn(String.format("Failed to access '%1$s' while loading Gradle models", cacheFilePath.getPath()), e);
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/ng/caching/CachedProjectModels$Loader", "loadFromDisk"));
        }
    }

    public static class Factory {
        @NotNull
        public CachedProjectModels createNew() {
            CachedProjectModels cachedProjectModels = new CachedProjectModels();
            if (cachedProjectModels == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return cachedProjectModels;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/ng/caching/CachedProjectModels$Factory", "createNew"));
        }
    }
}

