/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng.variantonly;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ModelBuilderParameter;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.project.sync.Modules;
import com.android.tools.idea.gradle.project.sync.ng.variantonly.VariantOnlySyncOptions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariantOnlyProjectModels
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final Map<String, VariantOnlyModuleModel> myModuleModelsById = new HashMap<String, VariantOnlyModuleModel>();

    public void populate(@NotNull BuildController controller, @NotNull VariantOnlySyncOptions syncOptions) {
        if (controller == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(0);
        }
        if (syncOptions == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(1);
        }
        this.populateModelsForModule(controller, syncOptions.myBuildId, syncOptions.myGradlePath, syncOptions.myVariantName);
    }

    private void populateModelsForModule(@NotNull BuildController controller, @NotNull File buildId, @NotNull String gradlePath, @NotNull String variantName) {
        AndroidProject androidProject;
        String moduleId;
        VariantOnlyModuleModel moduleModel;
        if (controller == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(2);
        }
        if (buildId == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(3);
        }
        if (gradlePath == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(4);
        }
        if (variantName == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(5);
        }
        if ((moduleModel = this.myModuleModelsById.get(moduleId = Modules.createUniqueModuleId(buildId, gradlePath))) != null && moduleModel.containsVariant(variantName)) {
            return;
        }
        if (moduleModel != null) {
            VariantOnlyProjectModels.syncAndAddVariant(moduleModel, variantName, controller);
            return;
        }
        GradleProject gradleProject = VariantOnlyProjectModels.findGradleProject(controller, buildId, gradlePath);
        if (gradleProject != null && (androidProject = (AndroidProject)controller.findModel((Model)gradleProject, AndroidProject.class, ModelBuilderParameter.class, parameter -> parameter.setShouldBuildVariant(false))) != null) {
            moduleModel = new VariantOnlyModuleModel(androidProject, gradleProject, moduleId);
            this.myModuleModelsById.put(moduleId, moduleModel);
            Variant variant = VariantOnlyProjectModels.syncAndAddVariant(moduleModel, variantName, controller);
            if (variant != null) {
                this.populateForDependencyModules(variant, controller);
            }
        }
    }

    private void populateForDependencyModules(@NotNull Variant variant, @NotNull BuildController controller) {
        if (variant == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(6);
        }
        if (controller == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(7);
        }
        for (AndroidLibrary library : variant.getMainArtifact().getDependencies().getLibraries()) {
            String projectPath = library.getProject();
            String buildId = library.getBuildId();
            String variantToSelect = library.getProjectVariant();
            if (projectPath == null || buildId == null || variantToSelect == null) continue;
            this.populateModelsForModule(controller, new File(buildId), projectPath, variantToSelect);
        }
    }

    @Nullable
    private static Variant syncAndAddVariant(@NotNull VariantOnlyModuleModel moduleModel, @NotNull String variantName, @NotNull BuildController controller) {
        GradleProject gradleProject;
        Variant variant;
        if (moduleModel == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(8);
        }
        if (variantName == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(9);
        }
        if (controller == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(10);
        }
        if ((variant = (Variant)controller.findModel((Model)(gradleProject = moduleModel.getGradleProject()), Variant.class, ModelBuilderParameter.class, parameter -> {
            if (variantName == null) {
                VariantOnlyProjectModels.$$$reportNull$$$0(19);
            }
            parameter.setVariantName(variantName);
        })) != null) {
            moduleModel.addVariant(variant);
        }
        return variant;
    }

    @Nullable
    private static GradleProject findGradleProject(@NotNull BuildController controller, @NotNull File buildId, @NotNull String gradlePath) {
        GradleProject gradleProject;
        GradleBuild rootBuild;
        GradleBuild gradleBuild;
        if (controller == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(11);
        }
        if (buildId == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(12);
        }
        if (gradlePath == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(13);
        }
        if ((gradleBuild = VariantOnlyProjectModels.findGradleBuild(rootBuild = controller.getBuildModel(), buildId)) != null && (gradleProject = (GradleProject)controller.findModel((Model)gradleBuild.getRootProject(), GradleProject.class)) != null) {
            return VariantOnlyProjectModels.findGradleProject(gradleProject, gradlePath);
        }
        return null;
    }

    @Nullable
    private static GradleBuild findGradleBuild(@NotNull GradleBuild gradleBuild, @NotNull File buildId) {
        if (gradleBuild == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(14);
        }
        if (buildId == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(15);
        }
        Path projectRootDir = gradleBuild.getBuildIdentifier().getRootDir().toPath();
        try {
            if (Files.isSameFile(projectRootDir, buildId.toPath())) {
                return gradleBuild;
            }
        }
        catch (IOException e) {
            return null;
        }
        for (GradleBuild childBuild : gradleBuild.getIncludedBuilds()) {
            GradleBuild build = VariantOnlyProjectModels.findGradleBuild(childBuild, buildId);
            if (build == null) continue;
            return build;
        }
        return null;
    }

    @Nullable
    private static GradleProject findGradleProject(@NotNull GradleProject gradleProject, @NotNull String gradlePath) {
        if (gradleProject == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(16);
        }
        if (gradlePath == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(17);
        }
        if (gradleProject.getPath().equals(gradlePath)) {
            return gradleProject;
        }
        for (GradleProject child : gradleProject.getChildren()) {
            GradleProject project = VariantOnlyProjectModels.findGradleProject(child, gradlePath);
            if (project == null) continue;
            return project;
        }
        return null;
    }

    @NotNull
    public List<VariantOnlyModuleModel> getModuleModels() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myModuleModelsById.values());
        if (immutableList == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(18);
        }
        return immutableList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncOptions";
                break;
            }
            case 3: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildId";
                break;
            }
            case 4: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 5: 
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleBuild";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProject";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/variantonly/VariantOnlyProjectModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/variantonly/VariantOnlyProjectModels";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "populate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "populateModelsForModule";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "populateForDependencyModules";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "syncAndAddVariant";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findGradleProject";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findGradleBuild";
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$syncAndAddVariant$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class VariantOnlyModuleModel
    implements Serializable {
        @NotNull
        private final AndroidProject myAndroidProject;
        @NotNull
        private final GradleProject myGradleProject;
        @NotNull
        private final String myModuleId;
        @NotNull
        private final Map<String, Variant> myVariantsByName;

        public VariantOnlyModuleModel(@NotNull AndroidProject androidProject, @NotNull GradleProject gradleProject, @NotNull String moduleId) {
            if (androidProject == null) {
                VariantOnlyModuleModel.$$$reportNull$$$0(0);
            }
            if (gradleProject == null) {
                VariantOnlyModuleModel.$$$reportNull$$$0(1);
            }
            if (moduleId == null) {
                VariantOnlyModuleModel.$$$reportNull$$$0(2);
            }
            this.myVariantsByName = new HashMap<String, Variant>();
            this.myAndroidProject = androidProject;
            this.myGradleProject = gradleProject;
            this.myModuleId = moduleId;
        }

        @NotNull
        public AndroidProject getAndroidProject() {
            AndroidProject androidProject = this.myAndroidProject;
            if (androidProject == null) {
                VariantOnlyModuleModel.$$$reportNull$$$0(3);
            }
            return androidProject;
        }

        @NotNull
        public GradleProject getGradleProject() {
            GradleProject gradleProject = this.myGradleProject;
            if (gradleProject == null) {
                VariantOnlyModuleModel.$$$reportNull$$$0(4);
            }
            return gradleProject;
        }

        @NotNull
        public String getModuleId() {
            String string = this.myModuleId;
            if (string == null) {
                VariantOnlyModuleModel.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public List<Variant> getVariants() {
            ImmutableList immutableList = ImmutableList.copyOf(this.myVariantsByName.values());
            if (immutableList == null) {
                VariantOnlyModuleModel.$$$reportNull$$$0(6);
            }
            return immutableList;
        }

        private void addVariant(@NotNull Variant variant) {
            if (variant == null) {
                VariantOnlyModuleModel.$$$reportNull$$$0(7);
            }
            this.myVariantsByName.put(variant.getName(), variant);
        }

        public boolean containsVariant(@NotNull String variantName) {
            if (variantName == null) {
                VariantOnlyModuleModel.$$$reportNull$$$0(8);
            }
            return this.myVariantsByName.containsKey(variantName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "androidProject";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradleProject";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleId";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/variantonly/VariantOnlyProjectModels$VariantOnlyModuleModel";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variant";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variantName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/variantonly/VariantOnlyProjectModels$VariantOnlyModuleModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAndroidProject";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGradleProject";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleId";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addVariant";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "containsVariant";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

