/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module;

import com.android.builder.model.level2.Library;
import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.sync.Modules;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.google.common.base.Strings;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class ModuleFinder {
    @NotNull
    public static final ModuleFinder EMPTY = new ModuleFinder();
    @NotNull
    private final Map<String, Module> myModulesByGradlePath;
    @NotNull
    private final Map<String, Module> myModulesByModuleId;
    @NotNull
    private final Map<String, File> myIncludedProjectFolderByModuleFolder;

    private ModuleFinder() {
        this.myModulesByGradlePath = new HashMap<String, Module>();
        this.myModulesByModuleId = new HashMap<String, Module>();
        this.myIncludedProjectFolderByModuleFolder = new HashMap<String, File>();
    }

    public ModuleFinder(@NotNull Project project) {
        if (project == null) {
            ModuleFinder.$$$reportNull$$$0(0);
        }
        this.myModulesByGradlePath = new HashMap<String, Module>();
        this.myModulesByModuleId = new HashMap<String, Module>();
        this.myIncludedProjectFolderByModuleFolder = new HashMap<String, File>();
        this.populateIncludedProjectFolderByModuleFolder(project);
    }

    private void populateIncludedProjectFolderByModuleFolder(@NotNull Project project) {
        String projectPath;
        if (project == null) {
            ModuleFinder.$$$reportNull$$$0(1);
        }
        if ((projectPath = project.getBasePath()) == null) {
            return;
        }
        GradleProjectSettings projectSettings = (GradleProjectSettings)GradleSettings.getInstance((Project)project).getLinkedProjectSettings(projectPath);
        if (projectSettings == null) {
            return;
        }
        GradleProjectSettings.CompositeBuild compositeBuild = projectSettings.getCompositeBuild();
        if (compositeBuild == null) {
            return;
        }
        for (BuildParticipant participant : compositeBuild.getCompositeParticipants()) {
            for (String modulePath : participant.getProjects()) {
                String path = Strings.nullToEmpty((String)participant.getRootPath());
                this.myIncludedProjectFolderByModuleFolder.put(modulePath, new File(path));
            }
        }
    }

    public void addModule(@NotNull Module module, @NotNull String gradlePath) {
        if (module == null) {
            ModuleFinder.$$$reportNull$$$0(2);
        }
        if (gradlePath == null) {
            ModuleFinder.$$$reportNull$$$0(3);
        }
        this.myModulesByGradlePath.put(gradlePath, module);
        File folderPath = this.getProjectRootFolder(module);
        if (folderPath != null) {
            this.myModulesByModuleId.put(Modules.createUniqueModuleId(folderPath, gradlePath), module);
        }
    }

    @Nullable
    private File getProjectRootFolder(@NotNull Module module) {
        String modulePath;
        File moduleFolder;
        if (module == null) {
            ModuleFinder.$$$reportNull$$$0(4);
        }
        if ((moduleFolder = GradleProjects.findModuleRootFolderPath(module)) != null && this.myIncludedProjectFolderByModuleFolder.containsKey(modulePath = moduleFolder.getPath())) {
            return this.myIncludedProjectFolderByModuleFolder.get(modulePath);
        }
        return Projects.getBaseDirPath((Project)module.getProject());
    }

    @Nullable
    public Module findModuleByGradlePath(@NotNull String gradlePath) {
        if (gradlePath == null) {
            ModuleFinder.$$$reportNull$$$0(5);
        }
        return this.myModulesByGradlePath.get(gradlePath);
    }

    @Nullable
    public Module findModuleByModuleId(@NotNull String moduleId) {
        if (moduleId == null) {
            ModuleFinder.$$$reportNull$$$0(6);
        }
        return this.myModulesByModuleId.get(moduleId);
    }

    @Nullable
    public Module findModuleFromLibrary(@NotNull Library library) {
        if (library == null) {
            ModuleFinder.$$$reportNull$$$0(7);
        }
        if (library.getType() != 3) {
            return null;
        }
        String gradlePath = library.getProjectPath();
        if (StringUtil.isNotEmpty((String)gradlePath)) {
            Module module = null;
            String projectFolderPath = library.getBuildId();
            if (StringUtil.isNotEmpty((String)projectFolderPath)) {
                String moduleId = Modules.createUniqueModuleId(projectFolderPath, gradlePath);
                module = this.myModulesByModuleId.get(moduleId);
            }
            return module != null ? module : this.myModulesByGradlePath.get(gradlePath);
        }
        return null;
    }

    public boolean isCompositeBuild(@NotNull Module module) {
        File moduleFolder;
        if (module == null) {
            ModuleFinder.$$$reportNull$$$0(8);
        }
        if ((moduleFolder = GradleProjects.findModuleRootFolderPath(module)) != null) {
            return this.myIncludedProjectFolderByModuleFolder.containsKey(moduleFolder.getPath());
        }
        return false;
    }

    public String toString() {
        return "ModuleFinder{myModulesByGradlePath=" + this.myModulesByGradlePath + ", myModulesByModuleId=" + this.myModulesByModuleId + ", myIncludedProjectFolderByModuleFolder=" + this.myIncludedProjectFolderByModuleFolder + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/ModuleFinder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "populateIncludedProjectFolderByModuleFolder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addModule";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getProjectRootFolder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findModuleByGradlePath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findModuleByModuleId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findModuleFromLibrary";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompositeBuild";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Factory {
        @NotNull
        public ModuleFinder create(@NotNull Project project) {
            if (project == null) {
                Factory.$$$reportNull$$$0(0);
            }
            ModuleFinder moduleFinder = new ModuleFinder(project);
            if (moduleFinder == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return moduleFinder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/ModuleFinder$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/ModuleFinder$Factory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

