/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.idea;

import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.JavaModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.java.ArtifactsByConfigurationModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.java.CompilerOutputModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.java.ContentRootsModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.java.DependenciesModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.java.JavaFacetModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.java.JavaLanguageLevelModuleSetupStep;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class JavaModuleSetup {
    @NotNull
    private final JavaModuleSetupStep[] mySetupSteps;

    public JavaModuleSetup() {
        this(new JavaFacetModuleSetupStep(), new ContentRootsModuleSetupStep(), new DependenciesModuleSetupStep(), new ArtifactsByConfigurationModuleSetupStep(), new CompilerOutputModuleSetupStep(), new JavaLanguageLevelModuleSetupStep());
    }

    @VisibleForTesting
    JavaModuleSetup(JavaModuleSetupStep ... setupSteps) {
        if (setupSteps == null) {
            JavaModuleSetup.$$$reportNull$$$0(0);
        }
        this.mySetupSteps = setupSteps;
    }

    public void setUpModule(@NotNull ModuleSetupContext context, @NotNull JavaModuleModel javaModuleModel, boolean syncSkipped) {
        if (context == null) {
            JavaModuleSetup.$$$reportNull$$$0(1);
        }
        if (javaModuleModel == null) {
            JavaModuleSetup.$$$reportNull$$$0(2);
        }
        Module module = context.getModule();
        if (javaModuleModel.isAndroidModuleWithoutVariants()) {
            GradleSyncMessages messages = GradleSyncMessages.getInstance(module.getProject());
            String[] text = new String[]{String.format("The module '%1$s' is an Android project without build variants, and cannot be built.", module.getName()), "Please fix the module's configuration in the build.gradle file and sync the project again."};
            messages.report(new SyncMessage("Project Structure Issues", MessageType.ERROR, text));
            JavaModuleSetup.cleanUpAndroidModuleWithoutVariants(module, context.getIdeModelsProvider());
            return;
        }
        for (JavaModuleSetupStep step : this.mySetupSteps) {
            if (syncSkipped && !step.invokeOnSkippedSync()) continue;
            step.setUpModule(context, javaModuleModel);
        }
    }

    private static void cleanUpAndroidModuleWithoutVariants(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider) {
        if (module == null) {
            JavaModuleSetup.$$$reportNull$$$0(3);
        }
        if (ideModelsProvider == null) {
            JavaModuleSetup.$$$reportNull$$$0(4);
        }
        Facets.removeAllFacets(ideModelsProvider.getModifiableFacetModel(module), AndroidFacet.ID);
        ModifiableRootModel rootModel = ideModelsProvider.getModifiableRootModel(module);
        for (ContentEntry contentEntry : rootModel.getContentEntries()) {
            contentEntry.clearSourceFolders();
            contentEntry.clearExcludeFolders();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setupSteps";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaModuleModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModelsProvider";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/idea/JavaModuleSetup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setUpModule";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanUpAndroidModuleWithoutVariants";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

