/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.gradle.model.level2.IdeDependencies;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.gradle.InstantRunGradleUtils;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleAndroidModule;
import com.google.wireless.android.sdk.stats.GradleBuildDetails;
import com.google.wireless.android.sdk.stats.GradleLibrary;
import com.google.wireless.android.sdk.stats.GradleModule;
import com.google.wireless.android.sdk.stats.GradleNativeAndroidModule;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureUsageTracker {
    private static final Logger LOG = Logger.getInstance(ProjectStructureUsageTracker.class);
    @NotNull
    private final Project myProject;

    ProjectStructureUsageTracker(@NotNull Project project) {
        if (project == null) {
            ProjectStructureUsageTracker.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    void trackProjectStructure() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
            try {
                this.trackProjectStructure(moduleManager.getModules());
            }
            catch (Throwable e) {
                LOG.warn("Failed to track project structure", e);
            }
        });
    }

    void trackProjectStructure(@NotNull Module[] modules) {
        AndroidModuleModel model;
        if (modules == null) {
            ProjectStructureUsageTracker.$$$reportNull$$$0(1);
        }
        AndroidModuleModel appModel = null;
        AndroidModuleModel libModel = null;
        int appCount = 0;
        int libCount = 0;
        ArrayList<GradleLibrary> gradleLibraries = new ArrayList<GradleLibrary>();
        for (Module module : modules) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(module);
            if (androidModel == null) continue;
            if (androidModel.getAndroidProject().getProjectType() == 1) {
                libModel = androidModel;
                ++libCount;
                continue;
            }
            appModel = androidModel;
            ++appCount;
            GradleLibrary gradleLibrary = ProjectStructureUsageTracker.trackExternalDependenciesInAndroidApp(androidModel);
            if (gradleLibrary == null) continue;
            gradleLibraries.add(gradleLibrary);
        }
        AndroidModuleModel androidModuleModel = model = appModel != null ? appModel : libModel;
        if (model != null) {
            ArrayList<GradleAndroidModule> gradleAndroidModules = new ArrayList<GradleAndroidModule>();
            ArrayList<GradleNativeAndroidModule> gradleNativeAndroidModules = new ArrayList<GradleNativeAndroidModule>();
            String appId = AnonymizerUtil.anonymizeUtf8((String)model.getApplicationId());
            IdeAndroidProject androidProject = model.getAndroidProject();
            GradleVersion gradleVersion = GradleVersions.getInstance().getGradleVersion(this.myProject);
            if (gradleVersion == null) {
                gradleVersion = new GradleVersion(0, 0, 0);
            }
            GradleModule gradleModule = GradleModule.newBuilder().setTotalModuleCount((long)modules.length).setAppModuleCount((long)appCount).setLibModuleCount((long)libCount).build();
            for (Module module : modules) {
                AndroidModuleModel androidModel = AndroidModuleModel.get(module);
                if (androidModel != null) {
                    IdeAndroidProject moduleAndroidProject = androidModel.getAndroidProject();
                    GradleAndroidModule.Builder androidModule = GradleAndroidModule.newBuilder();
                    androidModule.setModuleName(AnonymizerUtil.anonymizeUtf8((String)module.getName())).setSigningConfigCount((long)moduleAndroidProject.getSigningConfigs().size()).setIsLibrary(moduleAndroidProject.getProjectType() == 1).setBuildTypeCount((long)androidModel.getBuildTypeNames().size()).setFlavorCount((long)androidModel.getProductFlavorNames().size()).setFlavorDimension((long)moduleAndroidProject.getFlavorDimensions().size());
                    gradleAndroidModules.add(androidModule.build());
                }
                boolean shouldReportNative = false;
                NdkModuleModel ndkModel = NdkModuleModel.get(module);
                GradleNativeAndroidModule.NativeBuildSystemType buildSystemType = GradleNativeAndroidModule.NativeBuildSystemType.UNKNOWN_NATIVE_BUILD_SYSTEM_TYPE;
                String moduleName = "";
                if (ndkModel != null) {
                    shouldReportNative = true;
                    if (ndkModel.getFeatures().isBuildSystemNameSupported()) {
                        for (String buildSystem : ndkModel.getAndroidProject().getBuildSystems()) {
                            buildSystemType = ProjectStructureUsageTracker.stringToBuildSystemType(buildSystem);
                        }
                    } else {
                        buildSystemType = GradleNativeAndroidModule.NativeBuildSystemType.GRADLE_EXPERIMENTAL;
                    }
                    moduleName = AnonymizerUtil.anonymizeUtf8((String)ndkModel.getModuleName());
                } else if (androidModel != null && ProjectStructureUsageTracker.areNativeLibrariesPresent((AndroidProject)androidModel.getAndroidProject())) {
                    shouldReportNative = true;
                    buildSystemType = AndroidPluginGeneration.find(module) == AndroidPluginGeneration.COMPONENT ? GradleNativeAndroidModule.NativeBuildSystemType.GRADLE_EXPERIMENTAL : GradleNativeAndroidModule.NativeBuildSystemType.NDK_COMPILE;
                }
                if (!shouldReportNative) continue;
                GradleNativeAndroidModule.Builder nativeModule = GradleNativeAndroidModule.newBuilder();
                nativeModule.setModuleName(moduleName).setBuildSystemType(buildSystemType);
                gradleNativeAndroidModules.add(nativeModule.build());
            }
            GradleBuildDetails.Builder gradleBuild = GradleBuildDetails.newBuilder();
            gradleBuild.setAppId(appId).setAndroidPluginVersion(androidProject.getModelVersion()).setGradleVersion(gradleVersion.toString()).setUserEnabledIr(InstantRunSettings.isInstantRunEnabled()).setModelSupportsIr(InstantRunGradleUtils.modelSupportsInstantRun(model)).setVariantSupportsIr(InstantRunGradleUtils.variantSupportsInstantRun(model)).addAllLibraries(gradleLibraries).addModules(gradleModule).addAllAndroidModules(gradleAndroidModules).addAllNativeAndroidModules(gradleNativeAndroidModules);
            AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder();
            event.setCategory(AndroidStudioEvent.EventCategory.GRADLE).setKind(AndroidStudioEvent.EventKind.GRADLE_BUILD_DETAILS).setGradleBuildDetails(gradleBuild);
            UsageTracker.getInstance().log(event);
        }
    }

    static GradleNativeAndroidModule.NativeBuildSystemType stringToBuildSystemType(@NotNull String buildSystem) {
        if (buildSystem == null) {
            ProjectStructureUsageTracker.$$$reportNull$$$0(2);
        }
        switch (buildSystem) {
            case "ndkBuild": {
                return GradleNativeAndroidModule.NativeBuildSystemType.NDK_BUILD;
            }
            case "cmake": {
                return GradleNativeAndroidModule.NativeBuildSystemType.CMAKE;
            }
            case "ndkCompile": {
                return GradleNativeAndroidModule.NativeBuildSystemType.NDK_COMPILE;
            }
            case "gradle": {
                return GradleNativeAndroidModule.NativeBuildSystemType.GRADLE_EXPERIMENTAL;
            }
        }
        return GradleNativeAndroidModule.NativeBuildSystemType.UNKNOWN_NATIVE_BUILD_SYSTEM_TYPE;
    }

    private static boolean areNativeLibrariesPresent(@NotNull AndroidProject androidProject) {
        String modelVersion;
        if (androidProject == null) {
            ProjectStructureUsageTracker.$$$reportNull$$$0(3);
        }
        if ((modelVersion = androidProject.getModelVersion()).startsWith("1.0") || modelVersion.startsWith("1.1") || androidProject.getApiVersion() < 3) {
            return false;
        }
        for (Variant variant : androidProject.getVariants()) {
            Collection nativeLibraries = variant.getMainArtifact().getNativeLibraries();
            if (nativeLibraries == null || nativeLibraries.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static GradleLibrary trackExternalDependenciesInAndroidApp(@NotNull AndroidModuleModel model) {
        if (model == null) {
            ProjectStructureUsageTracker.$$$reportNull$$$0(4);
        }
        IdeAndroidProject androidProject = model.getAndroidProject();
        Ref chosenVariant = new Ref();
        androidProject.forEachVariant(variant -> {
            if ("release".equals(variant.getBuildType())) {
                chosenVariant.set(variant);
            }
        });
        if (chosenVariant.get() == null) {
            chosenVariant.set((Object)model.getSelectedVariant());
        }
        IdeDependencies dependencies = ((IdeVariant)chosenVariant.get()).getMainArtifact().getLevel2Dependencies();
        return GradleLibrary.newBuilder().setAarDependencyCount((long)dependencies.getAndroidLibraries().size()).setJarDependencyCount((long)dependencies.getJavaLibraries().size()).build();
    }

    @Nullable
    public static String getApplicationId(@NotNull Project project) {
        if (project == null) {
            ProjectStructureUsageTracker.$$$reportNull$$$0(5);
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidModel androidModel = AndroidModel.get(module);
            if (androidModel == null || AndroidFacet.getInstance((Module)module).getProperties().PROJECT_TYPE != 0) continue;
            return androidModel.getApplicationId();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildSystem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidProject";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/post/ProjectStructureUsageTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "trackProjectStructure";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "stringToBuildSystemType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "areNativeLibrariesPresent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "trackExternalDependenciesInAndroidApp";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getApplicationId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

