/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.validation.android;

import com.android.builder.model.AndroidProject;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.validation.android.AndroidProjectValidationStrategy;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BuildTools23Rc1ValidationStrategy
extends AndroidProjectValidationStrategy {
    @NotNull
    private final BuildToolsVersionReader myBuildToolsVersionReader;
    @NotNull
    private final List<String> myModules;

    BuildTools23Rc1ValidationStrategy(@NotNull Project project) {
        if (project == null) {
            BuildTools23Rc1ValidationStrategy.$$$reportNull$$$0(0);
        }
        this(project, module -> {
            AndroidModel android;
            GradleBuildModel buildModel = GradleBuildModel.get(module);
            if (buildModel != null && (android = buildModel.android()) != null) {
                return android.buildToolsVersion().toString();
            }
            return null;
        });
    }

    @VisibleForTesting
    BuildTools23Rc1ValidationStrategy(@NotNull Project project, @NotNull BuildToolsVersionReader buildToolsVersionReader) {
        if (project == null) {
            BuildTools23Rc1ValidationStrategy.$$$reportNull$$$0(1);
        }
        if (buildToolsVersionReader == null) {
            BuildTools23Rc1ValidationStrategy.$$$reportNull$$$0(2);
        }
        super(project);
        this.myModules = new ArrayList<String>();
        this.myBuildToolsVersionReader = buildToolsVersionReader;
    }

    @Override
    void validate(@NotNull Module module, @NotNull AndroidModuleModel androidModel) {
        String preview;
        List segments;
        GradleVersion parsed;
        String version2;
        if (module == null) {
            BuildTools23Rc1ValidationStrategy.$$$reportNull$$$0(3);
        }
        if (androidModel == null) {
            BuildTools23Rc1ValidationStrategy.$$$reportNull$$$0(4);
        }
        if (!BuildTools23Rc1ValidationStrategy.isOneDotThreeOrNewer((AndroidProject)androidModel.getAndroidProject()) && (version2 = this.myBuildToolsVersionReader.getBuildToolsVersion(module)) != null && (parsed = GradleVersion.parse((String)((String)(segments = Splitter.on((char)' ').omitEmptyStrings().splitToList((CharSequence)version2)).get(0)))).getMajor() == 23 && parsed.getMinor() == 0 && parsed.getMicro() == 0 && ((preview = "rc1").equals(parsed.getPreviewType()) || segments.size() > 1 && preview.equals(segments.get(1)))) {
            this.myModules.add(module.getName());
        }
    }

    private static boolean isOneDotThreeOrNewer(@NotNull AndroidProject project) {
        String modelVersion;
        if (project == null) {
            BuildTools23Rc1ValidationStrategy.$$$reportNull$$$0(5);
        }
        return !(modelVersion = project.getModelVersion()).startsWith("1.0") && !modelVersion.startsWith("1.1") && project.getApiVersion() >= 3;
    }

    @Override
    void fixAndReportFoundIssues() {
        if (!this.myModules.isEmpty()) {
            Collections.sort(this.myModules);
            StringBuilder msg = new StringBuilder();
            msg.append("Build Tools 23.0.0 rc1 is <b>deprecated</b>.<br>\n").append("Please update these modules to use Build Tools 23.0.0 rc2 (or newer) instead:");
            for (String module : this.myModules) {
                msg.append("<br>\n * ").append(module);
            }
            msg.append("<br>\n<br>\nOtherwise the project won't build. ");
            Project project = this.getProject();
            SyncMessage message = new SyncMessage("Gradle Sync Issues", MessageType.ERROR, msg.toString());
            GradleSyncMessages.getInstance(project).report(message);
            GradleSyncState.getInstance(project).getSummary().setSyncErrorsFound(true);
        }
    }

    @VisibleForTesting
    @NotNull
    List<String> getModules() {
        List<String> list = this.myModules;
        if (list == null) {
            BuildTools23Rc1ValidationStrategy.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildToolsVersionReader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/validation/android/BuildTools23Rc1ValidationStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/validation/android/BuildTools23Rc1ValidationStrategy";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isOneDotThreeOrNewer";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static interface BuildToolsVersionReader {
        @Nullable
        public String getBuildToolsVersion(@NotNull Module var1);
    }
}

