/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.ddmlib.IDevice;
import com.android.ide.common.util.DeviceUtils;
import com.android.resources.Density;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.run.AndroidDevice;
import com.google.common.collect.Ordering;
import com.google.gson.stream.JsonWriter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 ,2\u00020\u0001:\u0001,B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u00c6\u0003JK\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001J\t\u0010%\u001a\u00020\u0005H\u00d6\u0001J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0003J\b\u0010*\u001a\u00020+H\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006-"}, d2={"Lcom/android/tools/idea/gradle/run/AndroidDeviceSpec;", "", "apiLevel", "", "apiCodeName", "", "buildDensity", "Lcom/android/resources/Density;", "buildAbis", "Ljava/util/ArrayList;", "languages", "Ljava/util/SortedSet;", "(ILjava/lang/String;Lcom/android/resources/Density;Ljava/util/ArrayList;Ljava/util/SortedSet;)V", "getApiCodeName", "()Ljava/lang/String;", "getApiLevel", "()I", "getBuildAbis", "()Ljava/util/ArrayList;", "getBuildDensity", "()Lcom/android/resources/Density;", "getLanguages", "()Ljava/util/SortedSet;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "writeJson", "", "out", "Ljava/io/Writer;", "writeToJsonTempFile", "Ljava/io/File;", "Companion", "intellij.android.core"})
public final class AndroidDeviceSpec {
    private final int apiLevel;
    @Nullable
    private final String apiCodeName;
    @Nullable
    private final Density buildDensity;
    @NotNull
    private final ArrayList<String> buildAbis;
    @NotNull
    private final SortedSet<String> languages;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeJson(Writer out) throws IOException {
        Closeable closeable = (Closeable)new JsonWriter(out);
        Throwable throwable = null;
        try {
            String it;
            Iterable $receiver$iv;
            Density density;
            Density it2;
            JsonWriter writer = (JsonWriter)closeable;
            writer.beginObject();
            writer.name("sdk_version").value((long)this.apiLevel);
            Density density2 = this.buildDensity;
            if (density2 != null && (it2 = (density = density2)).getDpiValue() > 0) {
                writer.name("screen_density").value((long)it2.getDpiValue());
            }
            if (!this.buildAbis.isEmpty()) {
                writer.name("supported_abis");
                writer.beginArray();
                $receiver$iv = this.buildAbis;
                for (Object element$iv : $receiver$iv) {
                    it = (String)element$iv;
                    writer.value(it);
                }
                writer.endArray();
            }
            if (!this.languages.isEmpty()) {
                writer.name("supported_locales");
                writer.beginArray();
                $receiver$iv = this.languages;
                for (Object element$iv : $receiver$iv) {
                    it = (String)element$iv;
                    writer.value(it);
                }
                writer.endArray();
            }
            JsonWriter jsonWriter = writer.endObject();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final Logger getLog() {
        Logger logger = Logger.getInstance(AndroidDeviceSpec.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(AndroidDeviceSpec::class.java)");
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final File writeToJsonTempFile() throws IOException {
        String string;
        Closeable closeable = new StringWriter();
        Throwable throwable = null;
        try {
            StringWriter it = (StringWriter)closeable;
            this.writeJson(it);
            it.flush();
            string = it.toString();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String jsonString = string;
        this.getLog().info("Device spec file generated: " + jsonString);
        File tempFile = FileUtil.createTempFile((String)"device-spec", (String)".json", (boolean)true);
        FileUtil.writeToFile((File)tempFile, (String)jsonString);
        File file = tempFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"tempFile");
        return file;
    }

    public final int getApiLevel() {
        return this.apiLevel;
    }

    @Nullable
    public final String getApiCodeName() {
        return this.apiCodeName;
    }

    @Nullable
    public final Density getBuildDensity() {
        return this.buildDensity;
    }

    @NotNull
    public final ArrayList<String> getBuildAbis() {
        return this.buildAbis;
    }

    @NotNull
    public final SortedSet<String> getLanguages() {
        return this.languages;
    }

    public AndroidDeviceSpec(int apiLevel, @Nullable String apiCodeName, @Nullable Density buildDensity, @NotNull ArrayList<String> buildAbis, @NotNull SortedSet<String> languages) {
        Intrinsics.checkParameterIsNotNull(buildAbis, (String)"buildAbis");
        Intrinsics.checkParameterIsNotNull(languages, (String)"languages");
        this.apiLevel = apiLevel;
        this.apiCodeName = apiCodeName;
        this.buildDensity = buildDensity;
        this.buildAbis = buildAbis;
        this.languages = languages;
    }

    public final int component1() {
        return this.apiLevel;
    }

    @Nullable
    public final String component2() {
        return this.apiCodeName;
    }

    @Nullable
    public final Density component3() {
        return this.buildDensity;
    }

    @NotNull
    public final ArrayList<String> component4() {
        return this.buildAbis;
    }

    @NotNull
    public final SortedSet<String> component5() {
        return this.languages;
    }

    @NotNull
    public final AndroidDeviceSpec copy(int apiLevel, @Nullable String apiCodeName, @Nullable Density buildDensity, @NotNull ArrayList<String> buildAbis, @NotNull SortedSet<String> languages) {
        Intrinsics.checkParameterIsNotNull(buildAbis, (String)"buildAbis");
        Intrinsics.checkParameterIsNotNull(languages, (String)"languages");
        return new AndroidDeviceSpec(apiLevel, apiCodeName, buildDensity, buildAbis, languages);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ AndroidDeviceSpec copy$default(AndroidDeviceSpec androidDeviceSpec, int n, String string, Density density, ArrayList arrayList, SortedSet sortedSet, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = androidDeviceSpec.apiLevel;
        }
        if ((n2 & 2) != 0) {
            string = androidDeviceSpec.apiCodeName;
        }
        if ((n2 & 4) != 0) {
            density = androidDeviceSpec.buildDensity;
        }
        if ((n2 & 8) != 0) {
            arrayList = androidDeviceSpec.buildAbis;
        }
        if ((n2 & 0x10) != 0) {
            sortedSet = androidDeviceSpec.languages;
        }
        return androidDeviceSpec.copy(n, string, density, arrayList, sortedSet);
    }

    public String toString() {
        return "AndroidDeviceSpec(apiLevel=" + this.apiLevel + ", apiCodeName=" + this.apiCodeName + ", buildDensity=" + this.buildDensity + ", buildAbis=" + this.buildAbis + ", languages=" + this.languages + ")";
    }

    public int hashCode() {
        String string = this.apiCodeName;
        Density density = this.buildDensity;
        ArrayList<String> arrayList = this.buildAbis;
        SortedSet<String> sortedSet = this.languages;
        return (((Integer.hashCode(this.apiLevel) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (density != null ? density.hashCode() : 0)) * 31 + (arrayList != null ? ((Object)arrayList).hashCode() : 0)) * 31 + (sortedSet != null ? sortedSet.hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof AndroidDeviceSpec)) break block3;
                AndroidDeviceSpec androidDeviceSpec = (AndroidDeviceSpec)object;
                if (!(this.apiLevel == androidDeviceSpec.apiLevel) || !Intrinsics.areEqual((Object)this.apiCodeName, (Object)androidDeviceSpec.apiCodeName) || !Intrinsics.areEqual((Object)this.buildDensity, (Object)androidDeviceSpec.buildDensity) || !Intrinsics.areEqual(this.buildAbis, androidDeviceSpec.buildAbis) || !Intrinsics.areEqual(this.languages, androidDeviceSpec.languages)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @Nullable
    public static final AndroidDeviceSpec create(@NotNull List<? extends AndroidDevice> devices, boolean fetchLanguages, long timeout, @NotNull TimeUnit unit) throws IOException {
        return Companion.create(devices, fetchLanguages, timeout, unit);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0003J0\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/gradle/run/AndroidDeviceSpec$Companion;", "", "()V", "combineDeviceLanguages", "Ljava/util/SortedSet;", "", "devices", "", "Lcom/android/tools/idea/run/AndroidDevice;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "create", "Lcom/android/tools/idea/gradle/run/AndroidDeviceSpec;", "fetchLanguages", "", "intellij.android.core"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final AndroidDeviceSpec create(@NotNull List<? extends AndroidDevice> devices, boolean fetchLanguages, long timeout, @NotNull TimeUnit unit) throws IOException {
            SortedSet<String> sortedSet;
            AndroidVersion minVersion;
            Object object;
            Collection collection;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull(devices, (String)"devices");
            Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
            if (devices.isEmpty()) {
                return null;
            }
            String apiCodeName = null;
            Density buildDensity = null;
            ArrayList<String> buildAbis = new ArrayList<String>();
            Iterable iterable = $receiver$iv = (Iterable)devices;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                AndroidDevice androidDevice = (AndroidDevice)item$iv$iv;
                collection = destination$iv$iv;
                object = it.getVersion();
                collection.add(object);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            Ordering ordering = Ordering.natural();
            Intrinsics.checkExpressionValueIsNotNull((Object)ordering, (String)"Ordering.natural()");
            Object object2 = CollectionsKt.minWith((Iterable)iterable2, (Comparator)((Comparator)ordering));
            if (object2 == null) {
                Intrinsics.throwNpe();
            }
            AndroidVersion androidVersion = minVersion = (AndroidVersion)object2;
            Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"minVersion");
            int apiLevel = androidVersion.getApiLevel();
            if (minVersion.getCodename() != null) {
                apiCodeName = minVersion.getCodename();
            }
            if (devices.size() == 1) {
                void $receiver$iv$iv2;
                Object item$iv$iv;
                AndroidDevice device = devices.get(0);
                Density density = Density.getEnum((int)device.getDensity());
                if (density != null) {
                    buildDensity = density;
                }
                List<Abi> list = device.getAbis();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"device.abis");
                Iterable $receiver$iv2 = list;
                item$iv$iv = $receiver$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (Object item$iv$iv2 : $receiver$iv$iv2) {
                    void it;
                    Abi $i$f$map = (Abi)item$iv$iv2;
                    collection = destination$iv$iv2;
                    object = it.toString();
                    collection.add(object);
                }
                List abis = (List)destination$iv$iv2;
                if (!abis.isEmpty()) {
                    buildAbis.addAll(abis);
                }
            }
            if (fetchLanguages) {
                sortedSet = this.combineDeviceLanguages(devices, timeout, unit);
            } else {
                SortedSet<String> sortedSet2 = Collections.emptySortedSet();
                sortedSet = sortedSet2;
                Intrinsics.checkExpressionValueIsNotNull(sortedSet2, (String)"Collections.emptySortedSet()");
            }
            SortedSet<String> languages = sortedSet;
            return new AndroidDeviceSpec(apiLevel, apiCodeName, buildDensity, buildAbis, languages);
        }

        private final SortedSet<String> combineDeviceLanguages(List<? extends AndroidDevice> devices, long timeout, TimeUnit unit) throws IOException {
            SortedSet sortedSet;
            try {
                SortedSet sortedSet2;
                boolean bl;
                List languageSets;
                Set it;
                Iterator iterator;
                Iterable $receiver$iv$iv;
                Collection destination$iv$iv;
                Iterable $receiver$iv;
                block9: {
                    long nanos = Math.max(1L, unit.toNanos(timeout));
                    Duration duration = Duration.ofNanos(nanos);
                    Iterable iterable = $receiver$iv = (Iterable)devices;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    iterator = $receiver$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Object item$iv$iv = iterator.next();
                        AndroidDevice androidDevice = (AndroidDevice)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        Object object = it.getLaunchedDevice().get(timeout, unit);
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.launchedDevice.get(timeout, unit)");
                        IDevice iDevice = (IDevice)object;
                        Duration duration2 = duration;
                        Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"duration");
                        Set set = DeviceUtils.getLanguages((IDevice)iDevice, (Duration)duration2);
                        collection.add(set);
                    }
                    languageSets = (List)destination$iv$iv;
                    $receiver$iv = languageSets;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $receiver$iv) {
                            Set it2 = (Set)element$iv;
                            if (!it2.isEmpty()) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    SortedSet sortedSet3 = Collections.emptySortedSet();
                    sortedSet2 = sortedSet3;
                    Intrinsics.checkExpressionValueIsNotNull(sortedSet3, (String)"Collections.emptySortedSet()");
                } else {
                    $receiver$iv = languageSets;
                    $receiver$iv$iv = $receiver$iv;
                    destination$iv$iv = new ArrayList();
                    iterator = $receiver$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv$iv = iterator.next();
                        it = (Set)element$iv$iv;
                        Iterable list$iv$iv = it;
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    sortedSet2 = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
                }
                sortedSet = sortedSet2;
            }
            catch (Exception e) {
                throw (Throwable)new IOException("Error retrieving list of installed languages on device", e);
            }
            return sortedSet;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

