/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RepoManager;
import com.android.tools.idea.gradle.structure.AndroidProjectStructureConfigurable;
import com.android.tools.idea.gradle.structure.ProjectConfigurationError;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.npw.PathValidationResult;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.Jdks;
import com.android.tools.idea.sdk.SdkPaths;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeSdksConfigurable
extends BaseConfigurable
implements Place.Navigator {
    @NonNls
    private static final String SDKS_PLACE = "sdks.place";
    @NonNls
    public static final String IDE_SDKS_LOCATION_VIEW = "IdeSdksView";
    private static final String CHOOSE_VALID_JDK_DIRECTORY_ERR = "Please choose a valid JDK directory.";
    private static final String CHOOSE_VALID_SDK_DIRECTORY_ERR = "Please choose a valid Android SDK directory.";
    private static final String CHOOSE_VALID_NDK_DIRECTORY_ERR = "Please choose a valid Android NDK directory.";
    private static final Logger LOG = Logger.getInstance(IdeSdksConfigurable.class);
    @Nullable
    private final BaseConfigurable myHost;
    @Nullable
    private final Project myProject;
    @NotNull
    private final BiMap<String, Component> myComponentsById;
    @Nullable
    private String myOriginalNdkHomePath;
    @Nullable
    private String myOriginalSdkHomePath;
    @Nullable
    private String myOriginalJdkHomePath;
    @Nullable
    private String myUserSelectedJdkHomePath;
    private boolean myOriginalUseEmbeddedJdk;
    private HyperlinkLabel myNdkDownloadHyperlinkLabel;
    private HyperlinkLabel myNdkResetHyperlinkLabel;
    private TextFieldWithBrowseButton mySdkLocationTextField;
    private TextFieldWithBrowseButton myNdkLocationTextField;
    private TextFieldWithBrowseButton myJdkLocationTextField;
    private JCheckBox myUseEmbeddedJdkCheckBox;
    private JPanel myWholePanel;
    private JPanel myNdkDownloadPanel;
    private AsyncProcessIcon myNdkCheckProcessIcon;
    private DetailsComponent myDetailsComponent;
    private History myHistory;
    private String mySelectedComponentId;

    public IdeSdksConfigurable(@Nullable BaseConfigurable host, @Nullable Project project) {
        this.$$$setupUI$$$();
        this.myComponentsById = HashBiMap.create();
        this.myHost = host;
        this.myProject = project;
        this.myWholePanel.setPreferredSize((Dimension)JBUI.size((int)700, (int)500));
        this.myWholePanel.setName(IDE_SDKS_LOCATION_VIEW);
        this.myDetailsComponent = new DetailsComponent();
        this.myDetailsComponent.setContent((JComponent)this.myWholePanel);
        this.myDetailsComponent.setText(new String[]{"SDK Location"});
        if (this.myProject == null || this.myProject.isDefault()) {
            this.myNdkLocationTextField.setEnabled(false);
        }
        this.adjustNdkQuickFixVisibility();
        CardLayout layout2 = (CardLayout)this.myNdkDownloadPanel.getLayout();
        layout2.show(this.myNdkDownloadPanel, "loading");
        StudioLoggerProgressIndicator logger = new StudioLoggerProgressIndicator(((Object)((Object)this)).getClass());
        RepoManager repoManager = AndroidSdks.getInstance().tryToChooseSdkHandler().getSdkManager((ProgressIndicator)logger);
        StudioProgressRunner runner = new StudioProgressRunner(false, false, "Loading Remote SDK", project);
        RepoManager.RepoLoadedCallback onComplete = packages -> ApplicationManager.getApplication().invokeLater(() -> {
            if (packages.getRemotePackages().get("ndk-bundle") != null) {
                layout2.show(this.myNdkDownloadPanel, "link");
            } else {
                this.myNdkDownloadPanel.setVisible(false);
            }
        }, ModalityState.any());
        Runnable onError = () -> ApplicationManager.getApplication().invokeLater(() -> this.myNdkDownloadPanel.setVisible(false), ModalityState.any());
        repoManager.load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, null, (List)ImmutableList.of((Object)onComplete), (List)ImmutableList.of((Object)onError), (ProgressRunner)runner, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), false);
        FocusAdapter historyUpdater = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (IdeSdksConfigurable.this.myHistory != null) {
                    String id = (String)IdeSdksConfigurable.this.myComponentsById.inverse().get((Object)e.getComponent());
                    IdeSdksConfigurable.this.mySelectedComponentId = id;
                    if (id != null) {
                        IdeSdksConfigurable.this.myHistory.pushQueryPlace();
                    }
                }
            }
        };
        this.installValidationListener(this.mySdkLocationTextField.getTextField());
        this.installValidationListener(this.myJdkLocationTextField.getTextField());
        this.installValidationListener(this.myNdkLocationTextField.getTextField());
        this.myUseEmbeddedJdkCheckBox.addChangeListener(e -> {
            String path;
            boolean useEmbeddedJdk = this.useEmbeddedJdk();
            this.updateJdkTextField(useEmbeddedJdk);
            File embeddedJdkPath = EmbeddedDistributionPaths.getInstance().getEmbeddedJdkPath();
            String string = path = embeddedJdkPath != null ? embeddedJdkPath.getPath() : "";
            if (!useEmbeddedJdk) {
                if (path.equals(this.myUserSelectedJdkHomePath)) {
                    this.myUserSelectedJdkHomePath = "";
                }
                path = this.myUserSelectedJdkHomePath;
            }
            this.myJdkLocationTextField.getTextField().setText(path);
        });
        this.addHistoryUpdater("mySdkLocationTextField", this.mySdkLocationTextField.getTextField(), historyUpdater);
        this.addHistoryUpdater("myJdkLocationTextField", this.myJdkLocationTextField.getTextField(), historyUpdater);
        this.addHistoryUpdater("myNdkLocationTextField", this.myNdkLocationTextField.getTextField(), historyUpdater);
    }

    private void addHistoryUpdater(@NotNull String id, @NotNull Component c, @NotNull FocusListener historyUpdater) {
        if (id == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(0);
        }
        if (c == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(1);
        }
        if (historyUpdater == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(2);
        }
        this.myComponentsById.put((Object)id, (Object)c);
        c.addFocusListener(historyUpdater);
    }

    public void disposeUIResources() {
    }

    public void reset() {
        this.myOriginalSdkHomePath = IdeSdksConfigurable.getIdeAndroidSdkPath();
        this.myOriginalNdkHomePath = this.getIdeNdkPath();
        this.myOriginalJdkHomePath = IdeSdksConfigurable.getIdeJdkPath();
        this.myOriginalUseEmbeddedJdk = IdeSdks.getInstance().isUsingEmbeddedJdk();
        this.mySdkLocationTextField.setText(this.myOriginalSdkHomePath);
        this.myNdkLocationTextField.setText(this.myOriginalNdkHomePath);
        String jdkPath = this.myOriginalUseEmbeddedJdk ? EmbeddedDistributionPaths.getInstance().getEmbeddedJdkPath().getPath() : this.myOriginalJdkHomePath;
        this.myJdkLocationTextField.setText(jdkPath);
        this.myUserSelectedJdkHomePath = this.myOriginalJdkHomePath;
        this.updateJdkTextField(this.myOriginalUseEmbeddedJdk);
        this.myUseEmbeddedJdkCheckBox.setSelected(this.myOriginalUseEmbeddedJdk);
    }

    private void updateJdkTextField(boolean useEmbeddedJdk) {
        Color background = useEmbeddedJdk ? UIUtil.getLabelBackground() : UIUtil.getTextFieldBackground();
        JTextField textField2 = this.myJdkLocationTextField.getTextField();
        textField2.setBackground(background);
        textField2.setEditable(!useEmbeddedJdk);
        this.myJdkLocationTextField.getButton().setEnabled(!useEmbeddedJdk);
    }

    public void apply() throws ConfigurationException {
        if (!this.isModified()) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.saveAndroidNdkPath();
            IdeSdks ideSdks = IdeSdks.getInstance();
            ideSdks.setJdkPath(this.useEmbeddedJdk() ? EmbeddedDistributionPaths.getInstance().getEmbeddedJdkPath() : this.getJdkLocation());
            ideSdks.setAndroidSdkPath(this.getSdkLocation(), this.myProject);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                ActionManager.getInstance().getAction("WelcomeScreen.RunAndroidSdkManager").update(null);
            }
        });
    }

    private void saveAndroidNdkPath() {
        if (this.myProject == null || this.myProject.isDefault()) {
            return;
        }
        try {
            LocalProperties localProperties = new LocalProperties(this.myProject);
            localProperties.setAndroidNdkPath(this.getNdkLocation());
            localProperties.save();
        }
        catch (IOException e) {
            LOG.info(String.format("Unable to update local.properties file in project '%1$s'.", this.myProject.getName()), (Throwable)e);
            String cause = e.getMessage();
            if (Strings.isNullOrEmpty((String)cause)) {
                cause = "[Unknown]";
            }
            String msg = String.format("Unable to update local.properties file in project '%1$s'.\n\nCause: %2$s\n\nPlease manually update the file's '%3$s' property value to \n'%4$s'\nand sync the project with Gradle files.", this.myProject.getName(), cause, "ndk.dir", this.getNdkLocation().getPath());
            Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)"Android Ndk Update");
        }
    }

    private void createUIComponents() {
        this.myNdkCheckProcessIcon = new AsyncProcessIcon("NDK check progress");
        this.createSdkLocationTextField();
        this.createJdkLocationTextField();
        this.createNdkLocationTextField();
        this.createNdkDownloadLink();
        this.createNdkResetLink();
    }

    private void createSdkLocationTextField() {
        this.mySdkLocationTextField = this.createTextFieldWithBrowseButton("Choose Android SDK Location", CHOOSE_VALID_SDK_DIRECTORY_ERR, (Function<File, SdkPaths.ValidationResult>)((Function)file -> SdkPaths.validateAndroidSdk(file, false)));
    }

    private void createNdkLocationTextField() {
        this.myNdkLocationTextField = this.createTextFieldWithBrowseButton("Choose Android NDK Location", CHOOSE_VALID_NDK_DIRECTORY_ERR, (Function<File, SdkPaths.ValidationResult>)((Function)file -> SdkPaths.validateAndroidNdk(file, false)));
    }

    @NotNull
    private TextFieldWithBrowseButton createTextFieldWithBrowseButton(@NotNull String title, @NotNull String errorMessage, @NotNull Function<File, SdkPaths.ValidationResult> validation) {
        if (title == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(3);
        }
        if (errorMessage == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(4);
        }
        if (validation == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(5);
        }
        FileChooserDescriptor descriptor = IdeSdksConfigurable.createSingleFolderDescriptor(title, (Function<File, Void>)((Function)file -> {
            if (validation == null) {
                IdeSdksConfigurable.$$$reportNull$$$0(27);
            }
            if (errorMessage == null) {
                IdeSdksConfigurable.$$$reportNull$$$0(28);
            }
            SdkPaths.ValidationResult validationResult = (SdkPaths.ValidationResult)validation.fun(file);
            if (!validationResult.success) {
                String msg = validationResult.message;
                if (StringUtil.isEmpty((String)msg)) {
                    msg = errorMessage;
                }
                throw new IllegalArgumentException(msg);
            }
            return null;
        }));
        JTextField textField2 = new JTextField(10);
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton(textField2, e -> {
            VirtualFile chosen;
            VirtualFile suggestedDir = null;
            File ndkLocation = this.getNdkLocation();
            if (ndkLocation.isDirectory()) {
                suggestedDir = VfsUtil.findFileByIoFile((File)ndkLocation, (boolean)false);
            }
            if ((chosen = FileChooser.chooseFile((FileChooserDescriptor)descriptor, null, (VirtualFile)suggestedDir)) != null) {
                File f = VfsUtilCore.virtualToIoFile((VirtualFile)chosen);
                textField2.setText(f.getPath());
            }
        });
        if (textFieldWithBrowseButton == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(6);
        }
        return textFieldWithBrowseButton;
    }

    private void createNdkResetLink() {
        this.myNdkResetHyperlinkLabel = new HyperlinkLabel();
        this.myNdkResetHyperlinkLabel.setHyperlinkText("", "Select", " default NDK");
        this.myNdkResetHyperlinkLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                File androidNdkPath = IdeSdks.getInstance().getAndroidNdkPath();
                assert (androidNdkPath != null);
                IdeSdksConfigurable.this.myNdkLocationTextField.setText(androidNdkPath.getPath());
            }
        });
    }

    private void createNdkDownloadLink() {
        this.myNdkDownloadHyperlinkLabel = new HyperlinkLabel();
        this.myNdkDownloadHyperlinkLabel.setHyperlinkText("", "Download", " Android NDK.");
        this.myNdkDownloadHyperlinkLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                if (IdeSdksConfigurable.this.validateAndroidSdkPath() != null) {
                    Messages.showErrorDialog((Component)IdeSdksConfigurable.this.getContentPanel(), (String)"Please select a valid SDK before downloading the NDK.");
                    return;
                }
                ImmutableList requested = ImmutableList.of((Object)"ndk-bundle");
                ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(IdeSdksConfigurable.this.myWholePanel, (Collection<String>)requested, false);
                if (dialog != null && dialog.showAndGet()) {
                    File ndk = IdeSdks.getInstance().getAndroidNdkPath();
                    if (ndk != null) {
                        IdeSdksConfigurable.this.myNdkLocationTextField.setText(ndk.getPath());
                    }
                    IdeSdksConfigurable.this.validateState();
                }
            }
        });
    }

    private void createJdkLocationTextField() {
        JTextField textField2 = new JTextField(10);
        this.myJdkLocationTextField = new TextFieldWithBrowseButton(textField2, e -> this.chooseJdkLocation());
    }

    public void chooseJdkLocation() {
        VirtualFile chosen;
        this.myJdkLocationTextField.getTextField().requestFocus();
        VirtualFile suggestedDir = null;
        File jdkLocation = this.getUserSelectedJdkLocation();
        if (jdkLocation.isDirectory()) {
            suggestedDir = VfsUtil.findFileByIoFile((File)jdkLocation, (boolean)false);
        }
        if ((chosen = FileChooser.chooseFile((FileChooserDescriptor)IdeSdksConfigurable.createSingleFolderDescriptor("Choose JDK Location", (Function<File, Void>)((Function)file -> {
            File validJdkLocation = this.validateJdkPath((File)file);
            if (validJdkLocation == null) {
                throw new IllegalArgumentException(CHOOSE_VALID_JDK_DIRECTORY_ERR);
            }
            return null;
        })), null, (VirtualFile)suggestedDir)) != null) {
            File validJdkLocation = this.validateJdkPath(VfsUtilCore.virtualToIoFile((VirtualFile)chosen));
            assert (validJdkLocation != null);
            this.myUserSelectedJdkHomePath = validJdkLocation.getPath();
            this.myJdkLocationTextField.setText(this.myUserSelectedJdkHomePath);
        }
    }

    private void installValidationListener(@NotNull JTextField textField2) {
        if (textField2 == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(7);
        }
        if (this.myHost instanceof AndroidProjectStructureConfigurable) {
            textField2.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    ((AndroidProjectStructureConfigurable)IdeSdksConfigurable.this.myHost).requestValidation();
                }
            });
        }
    }

    @NotNull
    private static FileChooserDescriptor createSingleFolderDescriptor(@NotNull String title, final @NotNull Function<File, Void> validation) {
        if (title == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(8);
        }
        if (validation == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(9);
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false){

            public void validateSelectedFiles(VirtualFile[] files2) throws Exception {
                for (VirtualFile virtualFile : files2) {
                    File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                    validation.fun((Object)file);
                }
            }
        };
        if (SystemInfo.isMac) {
            descriptor.withShowHiddenFiles(true);
        }
        descriptor.setTitle(title);
        FileChooserDescriptor fileChooserDescriptor = descriptor;
        if (fileChooserDescriptor == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(10);
        }
        return fileChooserDescriptor;
    }

    public String getDisplayName() {
        return "SDK Location";
    }

    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.myDetailsComponent.getComponent();
    }

    @NotNull
    public JComponent getContentPanel() {
        JPanel jPanel = this.myWholePanel;
        if (jPanel == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(11);
        }
        return jPanel;
    }

    public boolean isModified() {
        return !Objects.equals(this.myOriginalSdkHomePath, this.getSdkLocation().getPath()) || !Objects.equals(this.myOriginalNdkHomePath, this.getNdkLocation().getPath()) || !Objects.equals(this.myOriginalJdkHomePath, this.getJdkLocation().getPath()) || this.myOriginalUseEmbeddedJdk != this.useEmbeddedJdk();
    }

    @Nullable
    private static Sdk getFirstDefaultAndroidSdk(boolean create) {
        IdeSdks ideSdks = IdeSdks.getInstance();
        List<Sdk> allAndroidSdks = ideSdks.getEligibleAndroidSdks();
        if (!allAndroidSdks.isEmpty()) {
            return allAndroidSdks.get(0);
        }
        if (!create) {
            return null;
        }
        AndroidSdkData sdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        if (sdkData == null) {
            return null;
        }
        List<Sdk> sdks = ideSdks.createAndroidSdkPerAndroidTarget(sdkData.getLocation());
        return !sdks.isEmpty() ? sdks.get(0) : null;
    }

    @NotNull
    private static String getIdeAndroidSdkPath() {
        String sdkHome;
        File path = IdeSdks.getInstance().getAndroidSdkPath();
        if (path != null) {
            String string = path.getPath();
            if (string == null) {
                IdeSdksConfigurable.$$$reportNull$$$0(12);
            }
            return string;
        }
        Sdk sdk = IdeSdksConfigurable.getFirstDefaultAndroidSdk(true);
        if (sdk != null && (sdkHome = sdk.getHomePath()) != null) {
            String string = FileUtilRt.toSystemDependentName((String)sdkHome);
            if (string == null) {
                IdeSdksConfigurable.$$$reportNull$$$0(13);
            }
            return string;
        }
        if ("" == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(14);
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private String getIdeNdkPath() {
        if (this.myProject != null && !this.myProject.isDefault()) {
            String string;
            try {
                File androidNdkPath = new LocalProperties(this.myProject).getAndroidNdkPath();
                if (androidNdkPath == null) return "";
                string = androidNdkPath.getPath();
            }
            catch (IOException e) {
                LOG.info(String.format("Unable to read local.properties file in project '%1$s'.", this.myProject.getName()), (Throwable)e);
                return "";
            }
            if (string != null) return string;
            IdeSdksConfigurable.$$$reportNull$$$0(15);
            return string;
        }
        File path = IdeSdks.getInstance().getAndroidNdkPath();
        if (path == null) return "";
        String string = path.getPath();
        if (string != null) return string;
        IdeSdksConfigurable.$$$reportNull$$$0(16);
        return string;
    }

    @NotNull
    private static String getIdeJdkPath() {
        File javaHome = IdeSdks.getInstance().getJdkPath();
        String string = javaHome != null ? javaHome.getPath() : "";
        if (string == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private File getSdkLocation() {
        String sdkLocation = this.mySdkLocationTextField.getText();
        File file = FilePaths.toSystemDependentPath((String)sdkLocation);
        if (file == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(19);
        }
        return file;
    }

    @NotNull
    private File getNdkLocation() {
        String ndkLocation = this.myNdkLocationTextField.getText();
        File file = FilePaths.toSystemDependentPath((String)ndkLocation);
        if (file == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(20);
        }
        return file;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        Component toFocus = (Component)this.myComponentsById.get((Object)this.mySelectedComponentId);
        JComponent jComponent = toFocus instanceof JComponent ? (JComponent)toFocus : this.mySdkLocationTextField.getTextField();
        if (jComponent == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(21);
        }
        return jComponent;
    }

    public boolean validate() throws ConfigurationException {
        File validJdkLocation;
        String msg = this.validateAndroidSdkPath();
        if (msg != null) {
            throw new ConfigurationException(msg);
        }
        if (!this.useEmbeddedJdk() && (validJdkLocation = this.validateJdkPath(this.getJdkLocation())) == null) {
            throw new ConfigurationException(CHOOSE_VALID_JDK_DIRECTORY_ERR);
        }
        msg = this.validateAndroidNdkPath();
        if (msg != null) {
            throw new ConfigurationException(msg);
        }
        return true;
    }

    @NotNull
    public List<ProjectConfigurationError> validateState() {
        ProjectConfigurationError error;
        File jdkLocation;
        ArrayList errors = Lists.newArrayList();
        String msg = this.validateAndroidSdkPath();
        if (msg != null) {
            ProjectConfigurationError error2 = new ProjectConfigurationError(msg, this.mySdkLocationTextField.getTextField());
            errors.add(error2);
        }
        if ((jdkLocation = this.validateJdkPath(this.getJdkLocation())) == null) {
            error = new ProjectConfigurationError(CHOOSE_VALID_JDK_DIRECTORY_ERR, this.myJdkLocationTextField.getTextField());
            errors.add(error);
        } else {
            JavaSdkVersion version2 = Jdks.getInstance().findVersion(jdkLocation);
            if (version2 == null || !version2.isAtLeast(JavaSdkVersion.JDK_1_8)) {
                ProjectConfigurationError error3 = new ProjectConfigurationError("Please choose JDK 8 or newer", this.myJdkLocationTextField.getTextField());
                errors.add(error3);
            }
        }
        msg = this.validateAndroidNdkPath();
        if (msg != null) {
            error = new ProjectConfigurationError(msg, this.myNdkLocationTextField.getTextField());
            errors.add(error);
        }
        ArrayList arrayList = errors;
        if (arrayList == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    @Nullable
    private String validateAndroidSdkPath() {
        PathValidationResult wizardValidationResult = PathValidationResult.validateLocation(this.getSdkLocation().getAbsolutePath(), "Android SDK location", false, PathValidationResult.WritableCheckMode.DO_NOT_CHECK);
        if (!wizardValidationResult.isOk()) {
            return wizardValidationResult.getFormattedMessage();
        }
        SdkPaths.ValidationResult validationResult = SdkPaths.validateAndroidSdk(this.getSdkLocation(), false);
        if (!validationResult.success) {
            String msg = validationResult.message;
            if (StringUtil.isEmpty((String)msg)) {
                msg = CHOOSE_VALID_SDK_DIRECTORY_ERR;
            }
            return msg;
        }
        return null;
    }

    @Nullable
    private String validateAndroidNdkPath() {
        this.hideNdkQuickfixLink();
        if (!this.myNdkLocationTextField.getText().isEmpty()) {
            SdkPaths.ValidationResult validationResult = SdkPaths.validateAndroidNdk(this.getNdkLocation(), false);
            if (!validationResult.success) {
                this.adjustNdkQuickFixVisibility();
                String msg = validationResult.message;
                if (StringUtil.isEmpty((String)msg)) {
                    msg = CHOOSE_VALID_NDK_DIRECTORY_ERR;
                }
                return msg;
            }
        } else if (this.myNdkLocationTextField.isVisible()) {
            this.adjustNdkQuickFixVisibility();
        }
        return null;
    }

    private void adjustNdkQuickFixVisibility() {
        boolean hasNdk = IdeSdks.getInstance().getAndroidNdkPath() != null;
        this.myNdkDownloadPanel.setVisible(!hasNdk);
        this.myNdkResetHyperlinkLabel.setVisible(hasNdk);
    }

    private void hideNdkQuickfixLink() {
        this.myNdkResetHyperlinkLabel.setVisible(false);
        this.myNdkDownloadPanel.setVisible(false);
    }

    @NotNull
    private File getUserSelectedJdkLocation() {
        String jdkLocation = Strings.nullToEmpty((String)this.myUserSelectedJdkHomePath);
        File file = FilePaths.toSystemDependentPath((String)jdkLocation);
        if (file == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(23);
        }
        return file;
    }

    @NotNull
    private File getJdkLocation() {
        String jdkLocation = this.myJdkLocationTextField.getText();
        File file = FilePaths.toSystemDependentPath((String)jdkLocation);
        if (file == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(24);
        }
        return file;
    }

    private boolean useEmbeddedJdk() {
        return this.myUseEmbeddedJdkCheckBox.isSelected();
    }

    @Nullable
    private File validateJdkPath(@NotNull File file) {
        File potentialPath;
        if (file == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(25);
        }
        if (JdkUtil.checkForJdk((File)file)) {
            return file;
        }
        if (SystemInfo.isMac && (potentialPath = new File(file, "/Contents/Home")).isDirectory() && JdkUtil.checkForJdk((File)potentialPath)) {
            this.myJdkLocationTextField.setText(potentialPath.getPath());
            return potentialPath;
        }
        return null;
    }

    public static boolean isNeeded() {
        String jdkPath = IdeSdksConfigurable.getIdeJdkPath();
        String sdkPath = IdeSdksConfigurable.getIdeAndroidSdkPath();
        IdeSdks ideSdks = IdeSdks.getInstance();
        boolean validJdk = ideSdks.isUsingEmbeddedJdk() || !jdkPath.isEmpty() && JdkUtil.checkForJdk((File)new File(jdkPath));
        boolean validSdk = !sdkPath.isEmpty() && ideSdks.isValidAndroidSdkPath(new File(sdkPath));
        return !validJdk || !validSdk;
    }

    public void setHistory(History history) {
        this.myHistory = history;
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        Component c;
        Object path;
        if (place != null && (path = place.getPath(SDKS_PLACE)) instanceof String && (c = (Component)this.myComponentsById.get(path)) != null) {
            c.requestFocusInWindow();
        }
        return ActionCallback.DONE;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(26);
        }
        place.putPath(SDKS_PLACE, (Object)this.mySelectedComponentId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "historyUpdater";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 5: 
            case 9: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validation";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/IdeSdksConfigurable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/IdeSdksConfigurable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextFieldWithBrowseButton";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createSingleFolderDescriptor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentPanel";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeAndroidSdkPath";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeNdkPath";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeJdkPath";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkLocation";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNdkLocation";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "validateState";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserSelectedJdkLocation";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdkLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addHistoryUpdater";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTextFieldWithBrowseButton";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "installValidationListener";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createSingleFolderDescriptor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "validateJdkPath";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "queryPlace";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createTextFieldWithBrowseButton$8";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myWholePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(14, 4, 4, 4), -1, 10, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("<html><b>Android SDK location:</b><br> The directory where the Android SDK is located. This location will be used for new projects, and for existing projects that do not have a local.properties file with a sdk.dir property.</html>");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 4, 10, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 2, 0, 3, 6, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.mySdkLocationTextField;
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 0, new Dimension(215, -1), null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("<html><b>JDK location:</b><br> The directory where the Java Development Kit (JDK) is located.</html>");
        jPanel2.add((Component)jLabel2, new GridConstraints(2, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 4, 10, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(4, 0, 1, 2, 0, 3, 6, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.myJdkLocationTextField;
        jPanel4.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 0, new Dimension(215, -1), null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("<html><b>Android NDK location:</b><br> The directory where the Android NDK is located. This location will be saved as ndk.dir property in the local.properties file.</html>");
        jPanel2.add((Component)jLabel3, new GridConstraints(5, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 4, 10, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(6, 0, 1, 2, 0, 3, 6, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton3 = this.myNdkLocationTextField;
        jPanel5.add((Component)textFieldWithBrowseButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 0, new Dimension(215, -1), null, null));
        HyperlinkLabel hyperlinkLabel = this.myNdkResetHyperlinkLabel;
        jPanel5.add((Component)hyperlinkLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myNdkDownloadPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel5.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        HyperlinkLabel hyperlinkLabel2 = this.myNdkDownloadHyperlinkLabel;
        jPanel.add((Component)hyperlinkLabel2, "link");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel6, "loading");
        AsyncProcessIcon asyncProcessIcon = this.myNdkCheckProcessIcon;
        jPanel6.add((Component)asyncProcessIcon, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Checking availability...");
        jPanel6.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myUseEmbeddedJdkCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Use embedded JDK (recommended)");
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }
}

