/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables;

import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.structure.configurables.BaseNamedConfigurable;
import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.PsModuleCellRenderer;
import com.android.tools.idea.gradle.structure.configurables.ui.PsUISettings;
import com.android.tools.idea.gradle.structure.configurables.ui.ToolWindowHeader;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.navigation.Place;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasePerspectiveConfigurable
extends MasterDetailsComponent
implements SearchableConfigurable,
Disposable,
Place.Navigator {
    @NotNull
    private final PsContext myContext;
    protected boolean myUiDisposed;
    private ToolWindowHeader myHeader;
    private JBLoadingPanel myLoadingPanel;
    private JComponent myCenterComponent;
    private boolean myTreeInitiated;
    private boolean myTreeMinimized;
    private volatile boolean mySelectModuleQuietly;

    protected BasePerspectiveConfigurable(@NotNull PsContext context) {
        if (context == null) {
            BasePerspectiveConfigurable.$$$reportNull$$$0(0);
        }
        this.myUiDisposed = true;
        ((JBSplitter)this.getSplitter()).setSplitterProportionKey("android.psd.proportion.modules");
        context.add(new GradleSyncListener(){

            @Override
            public void syncStarted(@NotNull Project project, boolean skipped, boolean sourceGenerationRequested) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (BasePerspectiveConfigurable.this.myLoadingPanel != null) {
                    BasePerspectiveConfigurable.this.myLoadingPanel.startLoading();
                }
            }

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                BasePerspectiveConfigurable.this.stopSyncAnimation();
            }

            @Override
            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(3);
                }
                BasePerspectiveConfigurable.this.stopSyncAnimation();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/BasePerspectiveConfigurable$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncSucceeded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncFailed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        this.myContext = context;
        this.myContext.add((moduleName, source) -> {
            if (source != this) {
                this.mySelectModuleQuietly = true;
                BaseNamedConfigurable<?> baseNamedConfigurable = this.selectModule(moduleName);
                if (baseNamedConfigurable != null) {
                    baseNamedConfigurable.restoreUiState();
                }
            }
        }, (Disposable)this);
        this.myContext.getAnalyzerDaemon().add((Function1<? super PsModel, Unit>)((Function1)model -> {
            if (this.myTree.isShowing()) {
                UIUtil.invokeLaterIfNeeded(() -> UiUtil.revalidateAndRepaint((JComponent)this.myTree));
            }
            return Unit.INSTANCE;
        }), this);
        this.myTreeMinimized = this.myContext.getUiSettings().MODULES_LIST_MINIMIZE;
        if (this.myTreeMinimized) {
            this.myToReInitWholePanel = true;
            this.reInitWholePanelIfNeeded();
        }
        this.myContext.getUiSettings().addListener(settings -> {
            if (settings.MODULES_LIST_MINIMIZE != this.myTreeMinimized) {
                this.myTreeMinimized = settings.MODULES_LIST_MINIMIZE;
                this.myToReInitWholePanel = true;
                this.reInitWholePanelIfNeeded();
            }
        }, this);
    }

    private void stopSyncAnimation() {
        if (this.myLoadingPanel != null) {
            this.myLoadingPanel.stopLoading();
        }
    }

    @Nullable
    private BaseNamedConfigurable<?> selectModule(@NotNull String moduleName) {
        MasterDetailsComponent.MyNode node;
        PsModule module;
        if (moduleName == null) {
            BasePerspectiveConfigurable.$$$reportNull$$$0(1);
        }
        if ((module = this.findModule(moduleName)) != null && (node = BasePerspectiveConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)module)) != null) {
            this.selectNodeInTree(moduleName);
            this.setSelectedNode(node);
            NamedConfigurable configurable = node.getConfigurable();
            return configurable instanceof BaseNamedConfigurable ? (BaseNamedConfigurable)configurable : null;
        }
        return null;
    }

    @Nullable
    protected PsModule findModule(@NotNull String moduleName) {
        PsModule module;
        if (moduleName == null) {
            BasePerspectiveConfigurable.$$$reportNull$$$0(2);
        }
        if ((module = this.myContext.getProject().findModuleByName(moduleName)) == null) {
            for (PsModule extraModule : this.getExtraTopModules()) {
                if (!moduleName.equals(extraModule.getName())) continue;
                module = extraModule;
                break;
            }
        }
        return module;
    }

    protected void updateSelection(@Nullable NamedConfigurable configurable) {
        super.updateSelection(configurable);
        if (configurable instanceof BaseNamedConfigurable) {
            BaseNamedConfigurable baseConfigurable = (BaseNamedConfigurable)configurable;
            Object module = baseConfigurable.getEditableObject();
            if (!this.mySelectModuleQuietly) {
                this.myContext.setSelectedModule(((PsModule)module).getName(), (Object)this);
                baseConfigurable.restoreUiState();
            } else {
                this.mySelectModuleQuietly = false;
            }
        }
        this.myHistory.pushQueryPlace();
    }

    protected void reInitWholePanelIfNeeded() {
        if (!this.myToReInitWholePanel) {
            return;
        }
        if (this.myTreeMinimized) {
            Splitter splitter = this.getSplitter();
            this.myCenterComponent = splitter.getSecondComponent();
            if (this.myCenterComponent == null) {
                super.reInitWholePanelIfNeeded();
                splitter = this.getSplitter();
                this.myCenterComponent = splitter.getSecondComponent();
            }
            this.myToReInitWholePanel = false;
            splitter.setSecondComponent(null);
            this.myWholePanel.remove((Component)splitter);
            this.myWholePanel.add((Component)this.myCenterComponent, "Center");
            UiUtil.revalidateAndRepaint(this.myWholePanel);
        } else {
            if (this.myWholePanel == null) {
                super.reInitWholePanelIfNeeded();
            }
            this.myToReInitWholePanel = false;
            Splitter splitter = this.getSplitter();
            if (this.myCenterComponent != null && this.myCenterComponent != splitter) {
                this.myWholePanel.remove(this.myCenterComponent);
                splitter.setSecondComponent(this.myCenterComponent);
                this.myWholePanel.add((Component)splitter);
                UiUtil.revalidateAndRepaint(this.myWholePanel);
            }
            this.myCenterComponent = splitter;
            JComponent first = splitter.getFirstComponent();
            if (first instanceof JPanel) {
                JPanel panel = (JPanel)first;
                if (this.myHeader == null) {
                    this.myHeader = ToolWindowHeader.createAndAdd("Modules", StudioIcons.Shell.Filetree.ANDROID_MODULE, panel, ToolWindowAnchor.LEFT);
                    this.myHeader.setPreferredFocusedComponent((JComponent)this.myTree);
                    this.myHeader.addMinimizeListener(() -> {
                        this.modulesTreeMinimized();
                        this.reInitWholePanelIfNeeded();
                    });
                } else if (this.myHeader.getParent() != panel) {
                    panel.add((Component)this.myHeader, "North");
                }
            }
        }
    }

    private void modulesTreeMinimized() {
        PsUISettings settings = this.myContext.getUiSettings();
        this.myToReInitWholePanel = true;
        this.myTreeMinimized = true;
        settings.MODULES_LIST_MINIMIZE = true;
        settings.fireUISettingsChanged();
    }

    public void reset() {
        this.myUiDisposed = false;
        if (!this.myTreeInitiated) {
            this.initTree();
            this.myTree.setShowsRootHandles(false);
            this.loadTree();
        } else {
            super.disposeUIResources();
            this.myTree.setShowsRootHandles(false);
            this.loadTree();
        }
        super.reset();
    }

    protected void initTree() {
        if (this.myTreeInitiated) {
            return;
        }
        this.myTreeInitiated = true;
        super.initTree();
        this.myTree.setRootVisible(false);
        new TreeSpeedSearch(this.myTree, treePath -> ((MasterDetailsComponent.MyNode)treePath.getLastPathComponent()).getDisplayName(), true);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.myTree);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new PsModuleCellRenderer(this.myContext)));
    }

    protected void loadTree() {
        List<PsModule> extraTopModules = this.getExtraTopModules();
        this.createModuleNodes(extraTopModules);
        ((DefaultTreeModel)this.myTree.getModel()).reload();
        this.myUiDisposed = false;
    }

    @NotNull
    public JComponent createComponent() {
        JComponent contents = super.createComponent();
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this);
        this.myLoadingPanel.setLoadingText("Syncing Project with Gradle");
        this.myLoadingPanel.add((Component)contents, (Object)"Center");
        JBLoadingPanel jBLoadingPanel = this.myLoadingPanel;
        if (jBLoadingPanel == null) {
            BasePerspectiveConfigurable.$$$reportNull$$$0(3);
        }
        return jBLoadingPanel;
    }

    @NotNull
    protected List<PsModule> getExtraTopModules() {
        List<PsModule> list = Collections.emptyList();
        if (list == null) {
            BasePerspectiveConfigurable.$$$reportNull$$$0(4);
        }
        return list;
    }

    private void createModuleNodes(@NotNull List<PsModule> extraTopModules) {
        if (extraTopModules == null) {
            BasePerspectiveConfigurable.$$$reportNull$$$0(5);
        }
        extraTopModules.forEach(this::addConfigurableFor);
        this.myContext.getProject().forEachModule(this::addConfigurableFor);
    }

    private void addConfigurableFor(@NotNull PsModule module) {
        NamedConfigurable<? extends PsModule> configurable;
        if (module == null) {
            BasePerspectiveConfigurable.$$$reportNull$$$0(6);
        }
        if ((configurable = this.getConfigurable(module)) != null) {
            MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode(configurable);
            this.myRoot.add((MutableTreeNode)node);
        }
    }

    @Nullable
    protected abstract NamedConfigurable<? extends PsModule> getConfigurable(@NotNull PsModule var1);

    @NotNull
    protected PsContext getContext() {
        PsContext psContext = this.myContext;
        if (psContext == null) {
            BasePerspectiveConfigurable.$$$reportNull$$$0(7);
        }
        return psContext;
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        String moduleName;
        Object path;
        if (place != null && (path = place.getPath(this.getNavigationPathName())) instanceof String && !StringUtil.isEmpty((String)(moduleName = (String)path))) {
            ActionCallback callback = new ActionCallback();
            this.getContext().setSelectedModule(moduleName, (Object)this);
            this.selectModule(moduleName);
            NamedConfigurable selectedConfigurable = this.getSelectedConfigurable();
            if (selectedConfigurable != null) {
                Place.goFurther((Object)selectedConfigurable, (Place)place, (boolean)requestFocus).notifyWhenDone(callback);
                return callback;
            }
        }
        return ActionCallback.DONE;
    }

    public void queryPlace(@NotNull Place place) {
        NamedConfigurable selectedConfigurable;
        if (place == null) {
            BasePerspectiveConfigurable.$$$reportNull$$$0(8);
        }
        if ((selectedConfigurable = this.getSelectedConfigurable()) instanceof BaseNamedConfigurable) {
            Object module = ((BaseNamedConfigurable)selectedConfigurable).getEditableObject();
            String moduleName = ((PsModule)module).getName();
            place.putPath(this.getNavigationPathName(), (Object)moduleName);
            Place.queryFurther((Object)selectedConfigurable, (Place)place);
            return;
        }
        place.putPath(this.getNavigationPathName(), (Object)"");
    }

    @NotNull
    protected abstract String getNavigationPathName();

    @Nullable
    public NamedConfigurable getSelectedConfigurable() {
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)selectionPath.getLastPathComponent();
            return node.getConfigurable();
        }
        return null;
    }

    public void putNavigationPath(@NotNull Place place, @NotNull String moduleName, @NotNull String dependency) {
        if (place == null) {
            BasePerspectiveConfigurable.$$$reportNull$$$0(9);
        }
        if (moduleName == null) {
            BasePerspectiveConfigurable.$$$reportNull$$$0(10);
        }
        if (dependency == null) {
            BasePerspectiveConfigurable.$$$reportNull$$$0(11);
        }
        place.putPath(this.getNavigationPathName(), (Object)moduleName);
        PsModule module = this.findModule(moduleName);
        assert (module != null);
        MasterDetailsComponent.MyNode node = BasePerspectiveConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)module);
        assert (node != null);
        NamedConfigurable configurable = node.getConfigurable();
        assert (configurable instanceof BaseNamedConfigurable);
        BaseNamedConfigurable dependenciesConfigurable = (BaseNamedConfigurable)configurable;
        dependenciesConfigurable.putNavigationPath(place, dependency);
    }

    public void disposeUIResources() {
        if (this.myUiDisposed) {
            return;
        }
        super.disposeUIResources();
        this.myUiDisposed = true;
        this.myAutoScrollHandler.cancelAllRequests();
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
        if (this.myHeader != null) {
            Disposer.dispose((Disposable)this.myHeader);
        }
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/configurables/BasePerspectiveConfigurable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraTopModules";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/BasePerspectiveConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraTopModules";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "selectModule";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createModuleNodes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addConfigurableFor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "queryPlace";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "putNavigationPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

