/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.suggestions;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.issues.IssueRenderer;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsPath;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/gradle/structure/configurables/suggestions/SuggestionsViewIssueRenderer;", "Lcom/android/tools/idea/gradle/structure/configurables/issues/IssueRenderer;", "context", "Lcom/android/tools/idea/gradle/structure/configurables/PsContext;", "showParentPath", "", "(Lcom/android/tools/idea/gradle/structure/configurables/PsContext;Z)V", "getContext", "()Lcom/android/tools/idea/gradle/structure/configurables/PsContext;", "getShowParentPath", "()Z", "renderIssue", "", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "issue", "Lcom/android/tools/idea/gradle/structure/model/PsIssue;", "makeTextWrappable", "", "intellij.android.core"})
public final class SuggestionsViewIssueRenderer
implements IssueRenderer {
    @NotNull
    private final PsContext context;
    private final boolean showParentPath;

    @Override
    public void renderIssue(@NotNull StringBuilder buffer, @NotNull PsIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        PsPath issuePath = issue2.getPath();
        String issuePathHref = issuePath.getHyperlinkDestination(this.context);
        String string = issuePath.toText(PsPath.TexType.PLAIN_TEXT);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"issuePath.toText(PsPath.TexType.PLAIN_TEXT)");
        String issuePathText = this.makeTextWrappable(string);
        String string2 = issue2.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"issue.text");
        String issueText = this.makeTextWrappable(string2);
        buffer.append("<table width='100%'><tr><td width='32' valign='top'>");
        StringBuilder stringBuilder = new StringBuilder().append("<img width=16 height=16 src='");
        PsIssue.Severity severity = issue2.getSeverity();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)severity), (String)"issue.severity");
        buffer.append(stringBuilder.append(severity.getIcon()).append("'></img>").toString());
        buffer.append("</td><td valign='top'>");
        buffer.append("<b>");
        buffer.append(issuePathText);
        if (this.showParentPath) {
            PsPath psPath = issuePath;
            Intrinsics.checkExpressionValueIsNotNull((Object)psPath, (String)"issuePath");
            List<PsPath> list = psPath.getParents();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"issuePath.parents");
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                PsPath parentPath = (PsPath)element$iv;
                String parentPathHref = parentPath.getHyperlinkDestination(this.context);
                String string3 = parentPath.toText(PsPath.TexType.PLAIN_TEXT);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"parentPath.toText(PsPath.TexType.PLAIN_TEXT)");
                String parentPathText = this.makeTextWrappable(string3);
                buffer.append(" (<a href=\"" + parentPathHref + "\">" + parentPathText + "</a>)");
            }
        }
        buffer.append(" : ");
        buffer.append(issueText);
        buffer.append("</b>");
        if (issuePathHref != null) {
            buffer.append("<br/><a href='" + issuePathHref + "'>View usage</a>");
        }
        buffer.append("</td></tr></table>");
    }

    private final String makeTextWrappable(@NotNull String $receiver) {
        return StringsKt.replace$default((String)$receiver, (String)"(?<=\\<)/", (String)"/&#x200b;", (boolean)false, (int)4, null);
    }

    @NotNull
    public final PsContext getContext() {
        return this.context;
    }

    public final boolean getShowParentPath() {
        return this.showParentPath;
    }

    public SuggestionsViewIssueRenderer(@NotNull PsContext context, boolean showParentPath) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.showParentPath = showParentPath;
    }
}

