/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.structure.configurables.ui.ArtifactRepositorySearchForm;
import com.android.tools.idea.gradle.structure.configurables.ui.ArtifactRepositorySearchFormUi;
import com.android.tools.idea.gradle.structure.configurables.ui.AvailableVersionsPanel;
import com.android.tools.idea.gradle.structure.configurables.ui.FutureUtilsKt;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeEventDispatcher;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeListener;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepositorySearch;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepositorySearchResults;
import com.android.tools.idea.gradle.structure.model.repositories.search.FoundArtifact;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchResult;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.table.TableView;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.StatusText;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u00012B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00070*2\u0006\u0010+\u001a\u00020,J\b\u0010-\u001a\u00020(H\u0002J\u0012\u0010.\u001a\u00020(2\b\u0010/\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u00100\u001a\u00020(H\u0002J\b\u00101\u001a\u00020(H\u0002R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R8\u0010\u001e\u001a\f\u0012\b\u0012\u00060\u001cj\u0002`\u001d0\u00032\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u00060\u001cj\u0002`\u001d0\u0003@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\u0005R\u0013\u0010\"\u001a\u0004\u0018\u00010\u001a8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/android/tools/idea/gradle/structure/configurables/ui/ArtifactRepositorySearchForm;", "Lcom/android/tools/idea/gradle/structure/configurables/ui/ArtifactRepositorySearchFormUi;", "repositories", "", "Lcom/android/tools/idea/gradle/structure/model/repositories/search/ArtifactRepository;", "(Ljava/util/List;)V", "artifactName", "", "getArtifactName", "()Ljava/lang/String;", "eventDispatcher", "Lcom/android/tools/idea/gradle/structure/configurables/ui/SelectionChangeEventDispatcher;", "groupId", "getGroupId", "panel", "Ljavax/swing/JPanel;", "getPanel", "()Ljavax/swing/JPanel;", "preferredFocusedComponent", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "()Ljavax/swing/JComponent;", "repositorySearch", "Lcom/android/tools/idea/gradle/structure/model/repositories/search/ArtifactRepositorySearch;", "resultsTable", "Lcom/intellij/ui/table/TableView;", "Lcom/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact;", "<set-?>", "Ljava/lang/Exception;", "Lkotlin/Exception;", "searchErrors", "getSearchErrors", "()Ljava/util/List;", "setSearchErrors", "selection", "getSelection", "()Lcom/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact;", "versionsPanel", "Lcom/android/tools/idea/gradle/structure/configurables/ui/AvailableVersionsPanel;", "add", "", "listener", "Lcom/android/tools/idea/gradle/structure/configurables/ui/SelectionChangeListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "clearResults", "notifyVersionSelectionChanged", "version", "performSearch", "showSearchStopped", "ResultsTableModel", "intellij.android.core"})
public final class ArtifactRepositorySearchForm
extends ArtifactRepositorySearchFormUi {
    private final ArtifactRepositorySearch repositorySearch;
    private final TableView<FoundArtifact> resultsTable;
    private final AvailableVersionsPanel versionsPanel;
    private final SelectionChangeEventDispatcher<String> eventDispatcher;
    @NotNull
    private List<? extends Exception> searchErrors;

    private final String getArtifactName() {
        JBTextField jBTextField = this.myArtifactNameTextField;
        Intrinsics.checkExpressionValueIsNotNull((Object)jBTextField, (String)"myArtifactNameTextField");
        String string = jBTextField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"myArtifactNameTextField.text");
        String $receiver$iv = string;
        CharSequence $receiver$iv$iv = $receiver$iv;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $receiver$iv$iv.charAt(index$iv$iv);
            boolean bl = match$iv$iv = it <= ' ';
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
    }

    private final String getGroupId() {
        JBTextField jBTextField = this.myGroupIdTextField;
        Intrinsics.checkExpressionValueIsNotNull((Object)jBTextField, (String)"myGroupIdTextField");
        String string = jBTextField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"myGroupIdTextField.text");
        String $receiver$iv = string;
        CharSequence $receiver$iv$iv = $receiver$iv;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $receiver$iv$iv.charAt(index$iv$iv);
            boolean bl = match$iv$iv = it <= ' ';
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return StringKt.nullize$default((String)((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), (boolean)false, (int)1, null);
    }

    @Nullable
    public final FoundArtifact getSelection() {
        Collection collection = this.resultsTable.getSelection();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"resultsTable.selection");
        return (FoundArtifact)CollectionsKt.singleOrNull((Iterable)collection);
    }

    @NotNull
    public final JPanel getPanel() {
        JPanel jPanel = this.myPanel;
        Intrinsics.checkExpressionValueIsNotNull((Object)jPanel, (String)"myPanel");
        return jPanel;
    }

    @NotNull
    public final JComponent getPreferredFocusedComponent() {
        JBTextField jBTextField = this.myArtifactNameTextField;
        Intrinsics.checkExpressionValueIsNotNull((Object)jBTextField, (String)"myArtifactNameTextField");
        return (JComponent)jBTextField;
    }

    @NotNull
    public final List<Exception> getSearchErrors() {
        return this.searchErrors;
    }

    private final void setSearchErrors(List<? extends Exception> list) {
        this.searchErrors = list;
    }

    private final void notifyVersionSelectionChanged(String version2) {
        String string;
        FoundArtifact foundArtifact = this.getSelection();
        if (foundArtifact != null) {
            StringBuilder stringBuilder;
            String string2;
            FoundArtifact foundArtifact2;
            FoundArtifact selection = foundArtifact2 = foundArtifact;
            String groupId = selection.getGroupId();
            String name = selection.getName();
            String string3 = version2;
            if (string3 == null) {
                List<GradleVersion> list = selection.getVersions();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"selection.versions");
                GradleVersion gradleVersion = (GradleVersion)CollectionsKt.firstOrNull(list);
                string3 = string2 = gradleVersion != null ? gradleVersion.toString() : null;
            }
            if (string3 == null) {
                string2 = "";
            }
            String adjustedVersion = string2;
            StringBuilder $receiver = stringBuilder = new StringBuilder();
            $receiver.append(groupId + ":" + name);
            if (StringUtil.isNotEmpty((String)adjustedVersion)) {
                $receiver.append(":" + adjustedVersion);
            }
            String string4 = stringBuilder.toString();
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        } else {
            string = null;
        }
        String selected = string;
        this.eventDispatcher.selectionChanged(selected);
    }

    private final void performSearch() {
        JButton jButton = this.mySearchButton;
        Intrinsics.checkExpressionValueIsNotNull((Object)jButton, (String)"mySearchButton");
        jButton.setEnabled(false);
        this.versionsPanel.setEmptyText("Searching...");
        StatusText statusText = this.resultsTable.getEmptyText();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusText, (String)"resultsTable.emptyText");
        statusText.setText("Searching...");
        this.resultsTable.setPaintBusy(true);
        this.clearResults();
        SearchRequest request = new SearchRequest(this.getArtifactName(), this.getGroupId(), 50, 0);
        ListenableFuture<ArtifactRepositorySearchResults> listenableFuture = this.repositorySearch.search(request);
        Intrinsics.checkExpressionValueIsNotNull(listenableFuture, (String)"repositorySearch.search(request)");
        FutureUtilsKt.continueOnEdt(listenableFuture, (Function1)new Function1<ArtifactRepositorySearchResults, Unit>(this){
            final /* synthetic */ ArtifactRepositorySearchForm this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ArtifactRepositorySearchResults results) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)results, (String)"results");
                List<Exception> errors = results.getErrors();
                Collection collection = errors;
                if (!collection.isEmpty()) {
                    ArtifactRepositorySearchForm.access$showSearchStopped(this.this$0);
                    ArtifactRepositorySearchForm.access$setSearchErrors$p(this.this$0, errors);
                    return;
                }
                Iterable iterable = $receiver$iv = (Iterable)results.getResults();
                Collection destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    SearchResult it = (SearchResult)element$iv$iv;
                    Iterable list$iv$iv = it.getArtifacts();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List foundArtifacts = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
                ListTableModel listTableModel = ArtifactRepositorySearchForm.access$getResultsTable$p(this.this$0).getListTableModel();
                Intrinsics.checkExpressionValueIsNotNull((Object)listTableModel, (String)"resultsTable.listTableModel");
                listTableModel.setItems(foundArtifacts);
                ArtifactRepositorySearchForm.access$getResultsTable$p(this.this$0).updateColumnSizes();
                ArtifactRepositorySearchForm.access$showSearchStopped(this.this$0);
                Collection collection2 = foundArtifacts;
                if (!collection2.isEmpty()) {
                    ArtifactRepositorySearchForm.access$getResultsTable$p(this.this$0).changeSelection(0, 0, false, false);
                }
                ArtifactRepositorySearchForm.access$getResultsTable$p(this.this$0).requestFocusInWindow();
            }
            {
                this.this$0 = artifactRepositorySearchForm;
                super(1);
            }
        });
    }

    private final void clearResults() {
        List list;
        ListTableModel listTableModel = this.resultsTable.getListTableModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)listTableModel, (String)"resultsTable.listTableModel");
        listTableModel.setItems(CollectionsKt.emptyList());
        ArtifactRepositorySearchForm artifactRepositorySearchForm = this;
        artifactRepositorySearchForm.searchErrors = list = CollectionsKt.emptyList();
        this.versionsPanel.clear();
    }

    private final void showSearchStopped() {
        JButton jButton = this.mySearchButton;
        Intrinsics.checkExpressionValueIsNotNull((Object)jButton, (String)"mySearchButton");
        jButton.setEnabled(this.getArtifactName().length() >= 3);
        this.resultsTable.setPaintBusy(false);
        StatusText statusText = this.resultsTable.getEmptyText();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusText, (String)"resultsTable.emptyText");
        statusText.setText("Nothing to show");
        this.versionsPanel.clear();
        this.versionsPanel.setEmptyText("Nothing to show");
    }

    public final void add(@NotNull SelectionChangeListener<String> listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkParameterIsNotNull(listener2, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        this.eventDispatcher.addListener(listener2, parentDisposable);
    }

    public ArtifactRepositorySearchForm(@NotNull List<? extends ArtifactRepository> repositories) {
        List list;
        Intrinsics.checkParameterIsNotNull(repositories, (String)"repositories");
        this.repositorySearch = new ArtifactRepositorySearch(repositories);
        this.eventDispatcher = new SelectionChangeEventDispatcher();
        ArtifactRepositorySearchForm artifactRepositorySearchForm = this;
        artifactRepositorySearchForm.searchErrors = list = CollectionsKt.emptyList();
        JBTextField jBTextField = this.myArtifactNameTextField;
        Intrinsics.checkExpressionValueIsNotNull((Object)jBTextField, (String)"myArtifactNameTextField");
        jBTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.clearResults();
                this.showSearchStopped();
            }
        });
        ActionListener actionListener2 = new ActionListener(this){
            final /* synthetic */ ArtifactRepositorySearchForm this$0;

            public final void actionPerformed(ActionEvent it) {
                JButton jButton = this.this$0.mySearchButton;
                Intrinsics.checkExpressionValueIsNotNull((Object)jButton, (String)"mySearchButton");
                if (jButton.isEnabled()) {
                    ArtifactRepositorySearchForm.access$performSearch(this.this$0);
                }
            }
            {
                this.this$0 = artifactRepositorySearchForm;
            }
        };
        this.mySearchButton.addActionListener(actionListener2);
        JBLabel jBLabel = this.myArtifactNameLabel;
        Intrinsics.checkExpressionValueIsNotNull((Object)jBLabel, (String)"myArtifactNameLabel");
        jBLabel.setLabelFor((Component)this.myArtifactNameTextField);
        this.myArtifactNameTextField.addActionListener(actionListener2);
        JBTextField jBTextField2 = this.myArtifactNameTextField;
        Intrinsics.checkExpressionValueIsNotNull((Object)jBTextField2, (String)"myArtifactNameTextField");
        StatusText statusText = jBTextField2.getEmptyText();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusText, (String)"myArtifactNameTextField.emptyText");
        statusText.setText("Example: \"guava\"");
        JBLabel jBLabel2 = this.myGroupIdLabel;
        Intrinsics.checkExpressionValueIsNotNull((Object)jBLabel2, (String)"myGroupIdLabel");
        jBLabel2.setLabelFor((Component)this.myGroupIdTextField);
        this.myGroupIdTextField.addActionListener(actionListener2);
        JBTextField jBTextField3 = this.myGroupIdTextField;
        Intrinsics.checkExpressionValueIsNotNull((Object)jBTextField3, (String)"myGroupIdTextField");
        StatusText statusText2 = jBTextField3.getEmptyText();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusText2, (String)"myGroupIdTextField.emptyText");
        statusText2.setText("Example: \"com.google.guava\"");
        this.resultsTable = new TableView((ListTableModel)new ResultsTableModel());
        this.resultsTable.setPreferredSize(new Dimension(520, 320));
        this.resultsTable.setSelectionMode(0);
        this.resultsTable.setAutoCreateRowSorter(true);
        this.resultsTable.setShowGrid(false);
        JTableHeader jTableHeader = this.resultsTable.getTableHeader();
        Intrinsics.checkExpressionValueIsNotNull((Object)jTableHeader, (String)"resultsTable.tableHeader");
        jTableHeader.setReorderingAllowed(false);
        this.versionsPanel = new AvailableVersionsPanel(new Consumer<String>(){

            @Override
            public final void accept(@Nullable String it) {
                this.notifyVersionSelectionChanged(it);
            }
        });
        this.resultsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public final void valueChanged(ListSelectionEvent it) {
                FoundArtifact artifact = this.getSelection();
                if (artifact != null) {
                    AvailableVersionsPanel availableVersionsPanel = versionsPanel;
                    List<GradleVersion> list = artifact.getVersions();
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"artifact.versions");
                    availableVersionsPanel.setVersions(list);
                } else {
                    this.notifyVersionSelectionChanged(null);
                }
            }
        });
        OnePixelSplitter splitter = new OnePixelSplitter(false, 0.7f);
        splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Component)this.resultsTable)));
        splitter.setSecondComponent((JComponent)this.versionsPanel);
        this.myResultsPanel.add((Component)splitter, "Center");
        new TableSpeedSearch((JTable)this.resultsTable);
    }

    @NotNull
    public static final /* synthetic */ List access$getSearchErrors$p(ArtifactRepositorySearchForm $this) {
        return $this.searchErrors;
    }

    public static final /* synthetic */ void access$setSearchErrors$p(ArtifactRepositorySearchForm $this, @NotNull List list) {
        $this.searchErrors = list;
    }

    @NotNull
    public static final /* synthetic */ TableView access$getResultsTable$p(ArtifactRepositorySearchForm $this) {
        return $this.resultsTable;
    }

    public static final /* synthetic */ void access$performSearch(ArtifactRepositorySearchForm $this) {
        $this.performSearch();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/gradle/structure/configurables/ui/ArtifactRepositorySearchForm$ResultsTableModel;", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact;", "()V", "createAndSetColumnInfos", "", "intellij.android.core"})
    private static final class ResultsTableModel
    extends ListTableModel<FoundArtifact> {
        private final void createAndSetColumnInfos() {
            createAndSetColumnInfos.1 column$ = createAndSetColumnInfos.1.INSTANCE;
            this.setColumnInfos(new ResultsTableModel.createAndSetColumnInfos.1[]{column$.invoke("Group ID", "abcdefghijklmno", (Function1<? super FoundArtifact, String>)((Function1)createAndSetColumnInfos.2.INSTANCE)), column$.invoke("Artifact Name", "abcdefg", (Function1<? super FoundArtifact, String>)((Function1)createAndSetColumnInfos.3.INSTANCE)), createAndSetColumnInfos.1.invoke$default(column$, "Repository", null, createAndSetColumnInfos.4.INSTANCE, 2, null)});
        }

        public ResultsTableModel() {
            super(new ColumnInfo[0]);
            this.createAndSetColumnInfos();
            this.setSortable(true);
        }
    }
}

