/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.daemon.AvailableLibraryUpdateStorage;
import com.android.tools.idea.gradle.structure.daemon.PsAnalyzerDaemon;
import com.android.tools.idea.gradle.structure.daemon.PsAnalyzerDaemonKt;
import com.android.tools.idea.gradle.structure.daemon.PsDaemon;
import com.android.tools.idea.gradle.structure.daemon.PsLibraryUpdateCheckerDaemon;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsAndroidModuleAnalyzer;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsJavaModuleAnalyzer;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsModuleAnalyzer;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueCollection;
import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.java.PsJavaDependency;
import com.android.tools.idea.gradle.structure.model.java.PsJavaModule;
import com.android.tools.idea.gradle.structure.navigation.PsLibraryDependencyNavigationPath;
import com.android.tools.idea.gradle.structure.quickfix.PsLibraryDependencyVersionQuickFixPath;
import com.intellij.openapi.Disposable;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.Arrays;
import java.util.EventListener;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003123B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020 0\"2\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020 H\u0002J\u0010\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020#H\u0002J\u000e\u0010,\u001a\u00020 2\u0006\u0010+\u001a\u00020#J\u0006\u0010-\u001a\u00020 J\u000e\u0010.\u001a\u00020 2\u0006\u0010/\u001a\u000200R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR2\u0010\u000e\u001a&\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010 \u0011*\u0012\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R&\u0010\u0016\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0018\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u00190\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u0013X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0015R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon;", "Lcom/android/tools/idea/gradle/structure/daemon/PsDaemon;", "context", "Lcom/android/tools/idea/gradle/structure/configurables/PsContext;", "libraryUpdateCheckerDaemon", "Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon;", "(Lcom/android/tools/idea/gradle/structure/configurables/PsContext;Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon;)V", "isRunning", "", "()Z", "issues", "Lcom/android/tools/idea/gradle/structure/model/PsIssueCollection;", "getIssues", "()Lcom/android/tools/idea/gradle/structure/model/PsIssueCollection;", "issuesUpdatedEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon$IssuesUpdatedListener;", "kotlin.jvm.PlatformType", "mainQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "getMainQueue", "()Lcom/intellij/util/ui/update/MergingUpdateQueue;", "modelAnalyzers", "", "Ljava/lang/Class;", "Lcom/android/tools/idea/gradle/structure/daemon/analysis/PsModuleAnalyzer;", "Lcom/android/tools/idea/gradle/structure/model/PsModule;", "resultsUpdaterQueue", "getResultsUpdaterQueue", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "add", "", "listener", "Lkotlin/Function1;", "Lcom/android/tools/idea/gradle/structure/model/PsModel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "addApplicableUpdatesAsIssues", "checkForUpdates", "dependency", "Lcom/android/tools/idea/gradle/structure/model/PsLibraryDependency;", "doCheck", "model", "queueCheck", "recreateUpdateIssues", "removeIssues", "type", "Lcom/android/tools/idea/gradle/structure/model/PsIssueType;", "AnalyzeStructure", "IssuesComputed", "IssuesUpdatedListener", "intellij.android.core"})
public final class PsAnalyzerDaemon
extends PsDaemon {
    @NotNull
    private final MergingUpdateQueue mainQueue;
    @NotNull
    private final MergingUpdateQueue resultsUpdaterQueue;
    @NotNull
    private final PsIssueCollection issues;
    private final Map<Class<?>, PsModuleAnalyzer<? extends PsModule>> modelAnalyzers;
    private final AtomicBoolean running;
    private final EventDispatcher<IssuesUpdatedListener> issuesUpdatedEventDispatcher;

    @Override
    @NotNull
    protected MergingUpdateQueue getMainQueue() {
        return this.mainQueue;
    }

    @Override
    @NotNull
    protected MergingUpdateQueue getResultsUpdaterQueue() {
        return this.resultsUpdaterQueue;
    }

    @NotNull
    public final PsIssueCollection getIssues() {
        return this.issues;
    }

    public final void recreateUpdateIssues() {
        PsIssueType psIssueType = PsIssueType.LIBRARY_UPDATES_AVAILABLE;
        Intrinsics.checkExpressionValueIsNotNull((Object)psIssueType, (String)"LIBRARY_UPDATES_AVAILABLE");
        this.removeIssues(psIssueType);
        this.addApplicableUpdatesAsIssues();
    }

    private final void addApplicableUpdatesAsIssues() {
        PsContext context = this.getContext();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(this, context){
            final /* synthetic */ PsAnalyzerDaemon this$0;
            final /* synthetic */ PsContext $context;

            public final void run() {
                this.$context.getProject().forEachModule(new Consumer<PsModule>(this){
                    final /* synthetic */ addApplicableUpdatesAsIssues.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final void accept(PsModule module) {
                        void updatesFound;
                        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
                        booleanRef.element = false;
                        if (module instanceof PsAndroidModule) {
                            ((PsAndroidModule)module).getDependencies().forEach((Function1<? super PsAndroidDependency, Unit>)((Function1)new Function1<PsAndroidDependency, Unit>(this, (Ref.BooleanRef)updatesFound){
                                final /* synthetic */ addApplicableUpdatesAsIssues.1 this$0;
                                final /* synthetic */ Ref.BooleanRef $updatesFound;

                                public final void invoke(@NotNull PsAndroidDependency dependency) {
                                    boolean found;
                                    Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
                                    if (dependency instanceof PsLibraryDependency && (found = PsAnalyzerDaemon.access$checkForUpdates(this.this$0.this$0.this$0, (PsLibraryDependency)((Object)dependency)))) {
                                        this.$updatesFound.element = true;
                                    }
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$updatesFound = booleanRef;
                                    super(1);
                                }
                            }));
                        } else if (module instanceof PsJavaModule) {
                            ((PsJavaModule)module).forEachDeclaredDependency((Function1<? super PsJavaDependency, Unit>)((Function1)new Function1<PsJavaDependency, Unit>(this, (Ref.BooleanRef)updatesFound){
                                final /* synthetic */ addApplicableUpdatesAsIssues.1 this$0;
                                final /* synthetic */ Ref.BooleanRef $updatesFound;

                                public final void invoke(@NotNull PsJavaDependency dependency) {
                                    boolean found;
                                    Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
                                    if (dependency instanceof PsLibraryDependency && (found = PsAnalyzerDaemon.access$checkForUpdates(this.this$0.this$0.this$0, (PsLibraryDependency)((Object)dependency)))) {
                                        this.$updatesFound.element = true;
                                    }
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$updatesFound = booleanRef;
                                    super(1);
                                }
                            }));
                        }
                        if (updatesFound.element) {
                            MergingUpdateQueue mergingUpdateQueue = this.this$0.this$0.getResultsUpdaterQueue();
                            PsAnalyzerDaemon psAnalyzerDaemon = this.this$0.this$0;
                            PsModule psModule = module;
                            Intrinsics.checkExpressionValueIsNotNull((Object)psModule, (String)"module");
                            mergingUpdateQueue.queue((Update)psAnalyzerDaemon.new IssuesComputed(psModule));
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = psAnalyzerDaemon;
                this.$context = psContext;
            }
        });
    }

    private final boolean checkForUpdates(PsLibraryDependency dependency) {
        PsArtifactDependencySpec spec;
        PsContext context = this.getContext();
        AvailableLibraryUpdateStorage.AvailableLibraryUpdates results = context.getLibraryUpdateCheckerDaemon().getAvailableUpdates();
        AvailableLibraryUpdateStorage.AvailableLibraryUpdate update2 = results.findUpdateFor(spec = dependency.getSpec());
        if (update2 != null) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Newer version available: <b>%1$s</b> (%2$s)";
            Object[] objectArray = new Object[]{update2.version, update2.repository};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String text = string2;
            PsLibraryDependencyNavigationPath mainPath = new PsLibraryDependencyNavigationPath(dependency);
            PsIssue issue2 = new PsIssue(text, mainPath, PsIssueType.LIBRARY_UPDATES_AVAILABLE, PsIssue.Severity.UPDATE);
            PsLibraryDependencyVersionQuickFixPath quickFix = new PsLibraryDependencyVersionQuickFixPath(dependency, update2.version, "[Update]");
            issue2.setQuickFixPath(quickFix);
            this.issues.add(issue2);
            return true;
        }
        return false;
    }

    public final void add(@NotNull Function1<? super PsModel, Unit> listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkParameterIsNotNull(listener2, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        this.issuesUpdatedEventDispatcher.addListener((EventListener)new IssuesUpdatedListener(listener2){
            final /* synthetic */ Function1 $listener;

            public void issuesUpdated(@NotNull PsModel model) {
                Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
                this.$listener.invoke((Object)model);
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        }, parentDisposable);
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    public final void queueCheck(@NotNull PsModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        this.getMainQueue().queue((Update)new AnalyzeStructure(model));
    }

    private final void doCheck(PsModel model) {
        this.running.set(true);
        PsModuleAnalyzer<? extends PsModule> analyzer = this.modelAnalyzers.get(model.getClass());
        if (analyzer == null) {
            PsAnalyzerDaemonKt.access$getLOG$p().info("Failed to find analyzer for model of type " + model.getClass().getName());
            return;
        }
        if (!this.isStopped()) {
            analyzer.analyze(model, this.issues);
        }
        this.getResultsUpdaterQueue().queue((Update)new IssuesComputed(model));
    }

    public final void removeIssues(@NotNull PsIssueType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        this.issues.remove(type);
        this.getResultsUpdaterQueue().queue((Update)new IssuesComputed(this.getContext().getProject()));
    }

    public PsAnalyzerDaemon(@NotNull PsContext context, @NotNull PsLibraryUpdateCheckerDaemon libraryUpdateCheckerDaemon) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)libraryUpdateCheckerDaemon, (String)"libraryUpdateCheckerDaemon");
        super(context);
        this.mainQueue = this.createQueue("Project Structure Daemon Analyzer", null);
        this.resultsUpdaterQueue = this.createQueue("Project Structure Analysis Results Updater", MergingUpdateQueue.ANY_COMPONENT);
        this.issues = new PsIssueCollection(context);
        this.modelAnalyzers = PsAnalyzerDaemonKt.access$analyzersMapOf(new PsAndroidModuleAnalyzer(context), new PsJavaModuleAnalyzer(context));
        this.running = new AtomicBoolean(true);
        this.issuesUpdatedEventDispatcher = EventDispatcher.create(IssuesUpdatedListener.class);
        libraryUpdateCheckerDaemon.add((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.addApplicableUpdatesAsIssues();
            }
        }), this);
    }

    public static final /* synthetic */ boolean access$checkForUpdates(PsAnalyzerDaemon $this, @NotNull PsLibraryDependency dependency) {
        return $this.checkForUpdates(dependency);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon$AnalyzeStructure;", "Lcom/intellij/util/ui/update/Update;", "myModel", "Lcom/android/tools/idea/gradle/structure/model/PsModel;", "(Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon;Lcom/android/tools/idea/gradle/structure/model/PsModel;)V", "run", "", "intellij.android.core"})
    private final class AnalyzeStructure
    extends Update {
        private final PsModel myModel;

        public void run() {
            try {
                PsAnalyzerDaemon.this.doCheck(this.myModel);
            }
            catch (Throwable e) {
                PsAnalyzerDaemonKt.access$getLOG$p().error("Failed to analyze " + this.myModel, e);
            }
        }

        public AnalyzeStructure(PsModel myModel) {
            Intrinsics.checkParameterIsNotNull((Object)myModel, (String)"myModel");
            super((Object)myModel);
            this.myModel = myModel;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon$IssuesComputed;", "Lcom/intellij/util/ui/update/Update;", "myModel", "Lcom/android/tools/idea/gradle/structure/model/PsModel;", "(Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon;Lcom/android/tools/idea/gradle/structure/model/PsModel;)V", "run", "", "intellij.android.core"})
    private final class IssuesComputed
    extends Update {
        private final PsModel myModel;

        public void run() {
            if (PsAnalyzerDaemon.this.isStopped()) {
                PsAnalyzerDaemon.this.running.set(false);
                return;
            }
            EventDispatcher eventDispatcher = PsAnalyzerDaemon.this.issuesUpdatedEventDispatcher;
            Intrinsics.checkExpressionValueIsNotNull((Object)eventDispatcher, (String)"issuesUpdatedEventDispatcher");
            ((IssuesUpdatedListener)eventDispatcher.getMulticaster()).issuesUpdated(this.myModel);
            PsAnalyzerDaemon.this.running.set(false);
        }

        public IssuesComputed(PsModel myModel) {
            Intrinsics.checkParameterIsNotNull((Object)myModel, (String)"myModel");
            super((Object)myModel);
            this.myModel = myModel;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon$IssuesUpdatedListener;", "Ljava/util/EventListener;", "issuesUpdated", "", "model", "Lcom/android/tools/idea/gradle/structure/model/PsModel;", "intellij.android.core"})
    private static interface IssuesUpdatedListener
    extends EventListener {
        public void issuesUpdated(@NotNull PsModel var1);
    }
}

