/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.daemon.AvailableLibraryUpdateStorage;
import com.android.tools.idea.gradle.structure.daemon.LibraryUpdateId;
import com.android.tools.idea.gradle.structure.daemon.PsDaemon;
import com.android.tools.idea.gradle.structure.daemon.PsLibraryUpdateCheckerDaemon;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.FoundArtifact;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchResult;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003$%&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0015J\b\u0010\u001d\u001a\u00020\u0015H\u0002J$\u0010\u001e\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0 H\u0002R2\u0010\u0005\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon;", "Lcom/android/tools/idea/gradle/structure/daemon/PsDaemon;", "context", "Lcom/android/tools/idea/gradle/structure/configurables/PsContext;", "(Lcom/android/tools/idea/gradle/structure/configurables/PsContext;)V", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon$AvailableUpdatesListener;", "kotlin.jvm.PlatformType", "isRunning", "", "()Z", "mainQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "getMainQueue", "()Lcom/intellij/util/ui/update/MergingUpdateQueue;", "resultsUpdaterQueue", "getResultsUpdaterQueue", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "add", "", "listener", "Lkotlin/Function0;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "getAvailableUpdates", "Lcom/android/tools/idea/gradle/structure/daemon/AvailableLibraryUpdateStorage$AvailableLibraryUpdates;", "queueAutomaticUpdateCheck", "queueUpdateCheck", "search", "repositories", "", "Lcom/android/tools/idea/gradle/structure/model/repositories/search/ArtifactRepository;", "ids", "Lcom/android/tools/idea/gradle/structure/daemon/LibraryUpdateId;", "AvailableUpdatesListener", "SearchForAvailableUpdates", "UpdatesAvailable", "intellij.android.core"})
public final class PsLibraryUpdateCheckerDaemon
extends PsDaemon {
    @NotNull
    private final MergingUpdateQueue mainQueue;
    @NotNull
    private final MergingUpdateQueue resultsUpdaterQueue;
    private final AtomicBoolean running;
    private final EventDispatcher<AvailableUpdatesListener> eventDispatcher;

    @Override
    @NotNull
    protected MergingUpdateQueue getMainQueue() {
        return this.mainQueue;
    }

    @Override
    @NotNull
    protected MergingUpdateQueue getResultsUpdaterQueue() {
        return this.resultsUpdaterQueue;
    }

    @NotNull
    public final AvailableLibraryUpdateStorage.AvailableLibraryUpdates getAvailableUpdates() {
        AvailableLibraryUpdateStorage.AvailableLibraryUpdates availableLibraryUpdates = AvailableLibraryUpdateStorage.getInstance(this.getContext().getProject().getResolvedModel()).getState();
        Intrinsics.checkExpressionValueIsNotNull((Object)availableLibraryUpdates, (String)"AvailableLibraryUpdateSt\u2026resolvedModel).getState()");
        return availableLibraryUpdates;
    }

    public final void queueAutomaticUpdateCheck() {
        long elapsed;
        long daysPastSinceLastUpdate;
        long searchTimeMillis = this.getAvailableUpdates().lastSearchTimeMillis;
        if (searchTimeMillis > 0L && (daysPastSinceLastUpdate = TimeUnit.MILLISECONDS.toDays(elapsed = System.currentTimeMillis() - searchTimeMillis)) < (long)3) {
            this.getResultsUpdaterQueue().queue((Update)new UpdatesAvailable());
            return;
        }
        this.queueUpdateCheck();
    }

    private final void queueUpdateCheck() {
        this.getMainQueue().queue((Update)new SearchForAvailableUpdates());
    }

    public final void add(@NotNull Function0<Unit> listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkParameterIsNotNull(listener2, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        this.eventDispatcher.addListener((EventListener)new AvailableUpdatesListener(listener2){
            final /* synthetic */ Function0 $listener;

            public void availableUpdates() {
                this.$listener.invoke();
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        }, parentDisposable);
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    private final void search(Collection<? extends ArtifactRepository> repositories, Collection<? extends LibraryUpdateId> ids) {
        this.running.set(true);
        this.getAvailableUpdates().clear();
        int resultCount = repositories.size() * ids.size();
        ArrayList jobs = Lists.newArrayListWithExpectedSize((int)resultCount);
        HashSet requests = Sets.newHashSet();
        Iterable $receiver$iv = ids;
        for (Object element$iv : $receiver$iv) {
            LibraryUpdateId id = (LibraryUpdateId)element$iv;
            String string = id.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id.name");
            SearchRequest request = new SearchRequest(string, id.getGroupId(), 1, 0);
            requests.add(request);
        }
        HashSet results = Sets.newHashSet();
        ArrayList errors = Lists.newArrayList();
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(new Runnable(this, repositories, requests, jobs, application, results, errors){
            final /* synthetic */ PsLibraryUpdateCheckerDaemon this$0;
            final /* synthetic */ Collection $repositories;
            final /* synthetic */ HashSet $requests;
            final /* synthetic */ ArrayList $jobs;
            final /* synthetic */ Application $application;
            final /* synthetic */ HashSet $results;
            final /* synthetic */ ArrayList $errors;

            public final void run() {
                List<FoundArtifact> artifacts;
                for (ArtifactRepository repository : this.$repositories) {
                    for (SearchRequest request : this.$requests) {
                        this.$jobs.add(this.$application.executeOnPooledThread((Callable)new Callable<SearchResult>(repository, request){
                            final /* synthetic */ ArtifactRepository $repository;
                            final /* synthetic */ SearchRequest $request;

                            @NotNull
                            public final SearchResult call() {
                                return this.$repository.search(this.$request);
                            }
                            {
                                this.$repository = artifactRepository;
                                this.$request = searchRequest;
                            }
                        }));
                    }
                }
                for (Future job : this.$jobs) {
                    try {
                        FoundArtifact artifact;
                        SearchResult result2;
                        SearchResult searchResult = result2 = (SearchResult)Futures.getChecked((Future)job, Exception.class);
                        Intrinsics.checkExpressionValueIsNotNull((Object)searchResult, (String)"result");
                        artifacts = searchResult.getArtifacts();
                        if (artifacts.size() != 1) continue;
                        FoundArtifact foundArtifact = artifact = artifacts.get(0);
                        Intrinsics.checkExpressionValueIsNotNull((Object)foundArtifact, (String)"artifact");
                        if (foundArtifact.getVersions().isEmpty()) continue;
                        this.$results.add(result2);
                    }
                    catch (Exception e) {
                        this.$errors.add(e);
                    }
                }
                AvailableLibraryUpdateStorage.AvailableLibraryUpdates updates = this.this$0.getAvailableUpdates();
                Iterator<E> iterator = this.$results.iterator();
                while (iterator.hasNext()) {
                    SearchResult result3;
                    SearchResult searchResult = result3 = (SearchResult)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)searchResult, (String)"result");
                    artifacts = searchResult.getArtifacts();
                    updates.add(artifacts.get(0));
                }
                updates.lastSearchTimeMillis = System.currentTimeMillis();
                this.this$0.getResultsUpdaterQueue().queue((Update)this.this$0.new UpdatesAvailable());
            }
            {
                this.this$0 = psLibraryUpdateCheckerDaemon;
                this.$repositories = collection;
                this.$requests = hashSet;
                this.$jobs = arrayList;
                this.$application = application;
                this.$results = hashSet2;
                this.$errors = arrayList2;
            }
        });
    }

    public PsLibraryUpdateCheckerDaemon(@NotNull PsContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.mainQueue = this.createQueue("Project Structure Daemon Update Checker", null);
        this.resultsUpdaterQueue = this.createQueue("Project Structure Available Update Results Updater", MergingUpdateQueue.ANY_COMPONENT);
        this.running = new AtomicBoolean(true);
        this.eventDispatcher = EventDispatcher.create(AvailableUpdatesListener.class);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon$SearchForAvailableUpdates;", "Lcom/intellij/util/ui/update/Update;", "(Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon;)V", "run", "", "intellij.android.core"})
    private final class SearchForAvailableUpdates
    extends Update {
        public void run() {
            Set repositories = new LinkedHashSet();
            Set ids = new LinkedHashSet();
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(this, repositories, ids){
                final /* synthetic */ SearchForAvailableUpdates this$0;
                final /* synthetic */ Set $repositories;
                final /* synthetic */ Set $ids;

                public final void run() {
                    this.this$0.PsLibraryUpdateCheckerDaemon.this.getContext().getProject().forEachModule(new Consumer<PsModule>(this){
                        final /* synthetic */ run.1 this$0;

                        public final void accept(PsModule module) {
                            this.this$0.$repositories.addAll((Collection)module.getArtifactRepositories());
                            if (module instanceof PsAndroidModule) {
                                ((PsAndroidModule)module).getDependencies().forEach((Function1<? super PsAndroidDependency, Unit>)((Function1)new Function1<PsAndroidDependency, Unit>(this){
                                    final /* synthetic */ SearchForAvailableUpdates.run.1 this$0;

                                    public final void invoke(@NotNull PsAndroidDependency dependency) {
                                        PsLibraryDependency libraryDependency;
                                        PsArtifactDependencySpec spec;
                                        Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
                                        if (dependency instanceof PsLibraryDependency && StringUtil.isNotEmpty((String)(spec = (libraryDependency = (PsLibraryDependency)((Object)dependency)).getSpec()).getVersion())) {
                                            GradleVersion version2;
                                            String string = spec.getVersion();
                                            if (string == null) {
                                                Intrinsics.throwNpe();
                                            }
                                            if ((version2 = GradleVersion.tryParse((String)string)) != null) {
                                                this.this$0.this$0.$ids.add(new LibraryUpdateId(spec.getName(), spec.getGroup()));
                                            }
                                        }
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(1);
                                    }
                                }));
                            }
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = searchForAvailableUpdates;
                    this.$repositories = set;
                    this.$ids = set2;
                }
            });
            if (!repositories.isEmpty() && !ids.isEmpty()) {
                PsLibraryUpdateCheckerDaemon.this.search(repositories, ids);
            } else {
                PsLibraryUpdateCheckerDaemon.this.getResultsUpdaterQueue().queue((Update)new UpdatesAvailable());
            }
        }

        public SearchForAvailableUpdates() {
            super((Object)PsLibraryUpdateCheckerDaemon.this.getContext().getProject());
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon$UpdatesAvailable;", "Lcom/intellij/util/ui/update/Update;", "(Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon;)V", "run", "", "intellij.android.core"})
    private final class UpdatesAvailable
    extends Update {
        public void run() {
            EventDispatcher eventDispatcher = PsLibraryUpdateCheckerDaemon.this.eventDispatcher;
            Intrinsics.checkExpressionValueIsNotNull((Object)eventDispatcher, (String)"eventDispatcher");
            ((AvailableUpdatesListener)eventDispatcher.getMulticaster()).availableUpdates();
            PsLibraryUpdateCheckerDaemon.this.running.set(false);
        }

        public UpdatesAvailable() {
            super((Object)PsLibraryUpdateCheckerDaemon.this.getContext().getProject());
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon$AvailableUpdatesListener;", "Ljava/util/EventListener;", "availableUpdates", "", "intellij.android.core"})
    private static interface AvailableUpdatesListener
    extends EventListener {
        public void availableUpdates();
    }
}

