/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon.analysis;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsAndroidModuleAnalyzerKt;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsModuleAnalyzer;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueCollection;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.navigation.PsLibraryDependencyNavigationPath;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/analysis/PsAndroidModuleAnalyzer;", "Lcom/android/tools/idea/gradle/structure/daemon/analysis/PsModuleAnalyzer;", "Lcom/android/tools/idea/gradle/structure/model/android/PsAndroidModule;", "context", "Lcom/android/tools/idea/gradle/structure/configurables/PsContext;", "(Lcom/android/tools/idea/gradle/structure/configurables/PsContext;)V", "supportedModelType", "Ljava/lang/Class;", "getSupportedModelType", "()Ljava/lang/Class;", "doAnalyze", "", "model", "issueCollection", "Lcom/android/tools/idea/gradle/structure/model/PsIssueCollection;", "intellij.android.core"})
public final class PsAndroidModuleAnalyzer
extends PsModuleAnalyzer<PsAndroidModule> {
    @NotNull
    private final Class<PsAndroidModule> supportedModelType;

    @Override
    @NotNull
    public Class<PsAndroidModule> getSupportedModelType() {
        return this.supportedModelType;
    }

    @Override
    protected void doAnalyze(@NotNull PsAndroidModule model, @NotNull PsIssueCollection issueCollection) {
        Collection syncIssues;
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)issueCollection, (String)"issueCollection");
        ArrayListMultimap issuesByData = ArrayListMultimap.create();
        AndroidModuleModel gradleModel = model.getResolvedModel();
        AndroidModuleModel androidModuleModel = gradleModel;
        Collection collection = syncIssues = androidModuleModel != null && (androidModuleModel = androidModuleModel.getAndroidProject()) != null ? androidModuleModel.getSyncIssues() : null;
        if (collection != null) {
            Iterable $receiver$iv = collection;
            for (Object element$iv : $receiver$iv) {
                SyncIssue syncIssue;
                SyncIssue syncIssue2 = syncIssue = (SyncIssue)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)syncIssue2, (String)"syncIssue");
                String data = Strings.nullToEmpty((String)syncIssue2.getData());
                issuesByData.put((Object)data, (Object)syncIssue);
            }
        }
        model.getDependencies().forEach((Function1<? super PsAndroidDependency, Unit>)((Function1)new Function1<PsAndroidDependency, Unit>(issuesByData, issueCollection){
            final /* synthetic */ ArrayListMultimap $issuesByData;
            final /* synthetic */ PsIssueCollection $issueCollection;

            public final void invoke(@NotNull PsAndroidDependency dependency) {
                Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
                if (dependency instanceof PsLibraryDependency && dependency.isDeclared()) {
                    PsLibraryDependency libraryDependency = (PsLibraryDependency)((Object)dependency);
                    PsLibraryDependencyNavigationPath path = new PsLibraryDependencyNavigationPath(libraryDependency);
                    PsArtifactDependencySpec resolvedSpec = libraryDependency.getSpec();
                    String issueKey = resolvedSpec.getGroup() + ":" + resolvedSpec.getName();
                    List librarySyncIssues = this.$issuesByData.get((Object)issueKey);
                    Iterator<E> iterator = librarySyncIssues.iterator();
                    while (iterator.hasNext()) {
                        SyncIssue syncIssue;
                        SyncIssue syncIssue2 = syncIssue = (SyncIssue)iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)syncIssue2, (String)"syncIssue");
                        PsIssue issue2 = PsAndroidModuleAnalyzerKt.createIssueFrom(syncIssue2, path);
                        this.$issueCollection.add(issue2);
                    }
                }
            }
            {
                this.$issuesByData = arrayListMultimap;
                this.$issueCollection = psIssueCollection;
                super(1);
            }
        }));
    }

    public PsAndroidModuleAnalyzer(@NotNull PsContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.supportedModelType = PsAndroidModule.class;
    }
}

