/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon.analysis;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsModelAnalyzer;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueCollection;
import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsResolvedLibraryDependency;
import com.android.tools.idea.gradle.structure.navigation.PsLibraryDependencyNavigationPath;
import com.android.tools.idea.gradle.structure.quickfix.PsLibraryDependencyVersionQuickFixPath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0004R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/analysis/PsModuleAnalyzer;", "T", "Lcom/android/tools/idea/gradle/structure/model/PsModule;", "Lcom/android/tools/idea/gradle/structure/daemon/analysis/PsModelAnalyzer;", "context", "Lcom/android/tools/idea/gradle/structure/configurables/PsContext;", "(Lcom/android/tools/idea/gradle/structure/configurables/PsContext;)V", "getContext", "()Lcom/android/tools/idea/gradle/structure/configurables/PsContext;", "analyzeDeclaredDependency", "", "dependency", "Lcom/android/tools/idea/gradle/structure/model/PsResolvedLibraryDependency;", "issueCollection", "Lcom/android/tools/idea/gradle/structure/model/PsIssueCollection;", "intellij.android.core"})
public abstract class PsModuleAnalyzer<T extends PsModule>
extends PsModelAnalyzer<T> {
    @NotNull
    private final PsContext context;

    protected final void analyzeDeclaredDependency(@NotNull PsResolvedLibraryDependency dependency, @NotNull PsIssueCollection issueCollection) {
        String message;
        Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
        Intrinsics.checkParameterIsNotNull((Object)issueCollection, (String)"issueCollection");
        PsArtifactDependencySpec resolvedSpec = dependency.getSpec();
        PsLibraryDependencyNavigationPath path = new PsLibraryDependencyNavigationPath(dependency);
        PsArtifactDependencySpec declaredSpec = dependency.getSpec();
        String declaredVersion = declaredSpec.getVersion();
        if (declaredVersion != null && StringsKt.endsWith$default((String)declaredVersion, (String)"+", (boolean)false, (int)2, null)) {
            message = "Avoid using '+' in version numbers; can lead to unpredictable and unrepeatable builds.";
            PsIssue issue2 = new PsIssue(message, "", path, PsIssueType.PROJECT_ANALYSIS, PsIssue.Severity.WARNING);
            PsLibraryDependencyVersionQuickFixPath quickFix = new PsLibraryDependencyVersionQuickFixPath(dependency, "[Fix]");
            issue2.setQuickFixPath(quickFix);
            issueCollection.add(issue2);
        }
        if (dependency.hasPromotedVersion()) {
            message = "Gradle promoted library version from " + declaredVersion + " to " + resolvedSpec.getVersion();
            String description = "To resolve version conflicts, Gradle by default uses the newest version of a dependency. <a href='https://docs.gradle.org/current/userguide/dependency_management.html'>Open Gradle documentation</a>";
            PsIssue issue3 = new PsIssue(message, description, path, PsIssueType.PROJECT_ANALYSIS, PsIssue.Severity.INFO);
            issueCollection.add(issue3);
        }
    }

    @NotNull
    protected final PsContext getContext() {
        return this.context;
    }

    protected PsModuleAnalyzer(@NotNull PsContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

