/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.dependencies;

import com.android.tools.idea.gradle.structure.configurables.ui.ToolWindowHeader;
import com.android.tools.idea.gradle.structure.configurables.ui.ToolWindowPanel;
import com.android.tools.idea.gradle.structure.dependencies.AbstractDependencyScopesPanel;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyScopesPanel
extends AbstractDependencyScopesPanel {
    @NotNull
    private final ToolWindowPanel myToolWindowPanel;
    @NotNull
    private final JBList<String> myConfigurationsList;
    private JPanel myContentsPanel;
    private JPanel myMainPanel;

    public DependencyScopesPanel(@NotNull PsModule module) {
        if (module == null) {
            DependencyScopesPanel.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        ArrayList configurations = Lists.newArrayList(module.getConfigurations());
        String selected = null;
        if (!configurations.isEmpty()) {
            selected = (String)configurations.get(0);
        }
        this.myConfigurationsList = new JBList((Collection)configurations);
        if (selected != null) {
            this.myConfigurationsList.setSelectedValue((Object)selected, true);
        }
        new ListSpeedSearch(this.myConfigurationsList);
        this.myToolWindowPanel = new ToolWindowPanel("Configurations", AndroidIcons.Android, null){};
        ToolWindowHeader header = this.myToolWindowPanel.getHeader();
        header.setPreferredFocusedComponent((JComponent)this.myConfigurationsList);
        header.setBorder(IdeBorderFactory.createBorder((int)7));
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(this.myConfigurationsList);
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)13));
        this.myToolWindowPanel.add((Component)scrollPane, "Center");
        this.myContentsPanel.add((Component)this.myToolWindowPanel, "Center");
        this.setUpContents(this.myMainPanel, DependencyScopesPanel.getInstructions());
    }

    @NotNull
    private static String getInstructions() {
        if ("Assign a scope to the new dependency by selecting the configurations below.<br/><a href='https://docs.gradle.org/current/userguide/artifact_dependencies_tutorial.html'>Open Documentation</a>" == null) {
            DependencyScopesPanel.$$$reportNull$$$0(1);
        }
        return "Assign a scope to the new dependency by selecting the configurations below.<br/><a href='https://docs.gradle.org/current/userguide/artifact_dependencies_tutorial.html'>Open Documentation</a>";
    }

    @Override
    @Nullable
    public ValidationInfo validateInput() {
        if (this.getSelectedScopeNames().isEmpty()) {
            return new ValidationInfo("Please select at least one configuration", this.myConfigurationsList);
        }
        return null;
    }

    @Override
    @NotNull
    public List<String> getSelectedScopeNames() {
        ImmutableList immutableList = ImmutableList.of((Object)this.myConfigurationsList.getSelectedValue());
        if (immutableList == null) {
            DependencyScopesPanel.$$$reportNull$$$0(2);
        }
        return immutableList;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myToolWindowPanel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/dependencies/DependencyScopesPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/dependencies/DependencyScopesPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstructions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedScopeNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myContentsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 7, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

