/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.dependencies.android;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.structure.configurables.ui.PsCheckBoxList;
import com.android.tools.idea.gradle.structure.configurables.ui.ToolWindowHeader;
import com.android.tools.idea.gradle.structure.configurables.ui.ToolWindowPanel;
import com.android.tools.idea.gradle.structure.dependencies.AbstractDependencyScopesPanel;
import com.android.tools.idea.gradle.structure.dependencies.android.BuildTypesPanel;
import com.android.tools.idea.gradle.structure.dependencies.android.Configuration;
import com.android.tools.idea.gradle.structure.dependencies.android.ConfigurationsPanel;
import com.android.tools.idea.gradle.structure.dependencies.android.ProductFlavorsPanel;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.android.tools.idea.gradle.structure.model.PsModelNameComparator;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsBuildType;
import com.android.tools.idea.gradle.structure.model.android.PsProductFlavor;
import com.android.tools.idea.gradle.structure.model.android.dependency.PsNewDependencyScopes;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jdesktop.swingx.JXLabel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDependencyScopesPanel
extends AbstractDependencyScopesPanel {
    @NonNls
    private static final String DEBUG_BUILD_TYPE = "debug";
    @NotNull
    private final ConfigurationsPanel myConfigurationsPanel;
    @NotNull
    private final BuildTypesPanel myBuildTypesPanel;
    @NotNull
    private final ProductFlavorsPanel myProductFlavorsPanel;
    @NotNull
    private final List<PsBuildType> myAllBuildTypes;
    @NotNull
    private final List<PsProductFlavor> myAllProductFlavors;
    @NotNull
    private final List<String> mySelectedScopeNames;
    @NotNull
    private final List<ToolWindowPanel> myToolWindowPanels;
    private final GradleVersion myModelVersion;
    private JPanel myMainPanel;
    private JPanel myContentsPanel;
    private JXLabel myScopesLabel;

    public AndroidDependencyScopesPanel(@NotNull PsAndroidModule module) {
        if (module == null) {
            AndroidDependencyScopesPanel.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.myAllBuildTypes = Lists.newArrayList();
        this.myAllProductFlavors = Lists.newArrayList();
        this.mySelectedScopeNames = Lists.newArrayList();
        this.myToolWindowPanels = Lists.newArrayList();
        this.myModelVersion = module.getResolvedModel().getModelVersion();
        this.myScopesLabel.setBorder((Border)BorderFactory.createCompoundBorder(UIUtil.getTextFieldBorder(), JBUI.Borders.empty((int)2)));
        this.myScopesLabel.setBackground(UIUtil.getTextFieldBackground());
        this.myScopesLabel.setText(" ");
        ScopesPanel scopesPanel = new ScopesPanel();
        this.myConfigurationsPanel = new ConfigurationsPanel();
        this.myConfigurationsPanel.add((List<Configuration> newSelection) -> this.updateScopes(), this);
        scopesPanel.createAndAddToolWindowPanel("Configurations", this.myConfigurationsPanel, this.myConfigurationsPanel.getPreferredFocusedComponent());
        this.myAllBuildTypes.addAll(module.getBuildTypes());
        Collections.sort(this.myAllBuildTypes, new PsModelNameComparator());
        this.myBuildTypesPanel = new BuildTypesPanel(this.myAllBuildTypes);
        this.myBuildTypesPanel.add((List<PsBuildType> newSelection) -> this.updateScopes(), this);
        scopesPanel.createAndAddToolWindowPanel("Build Types", this.myBuildTypesPanel, this.myBuildTypesPanel.getPreferredFocusedComponent());
        this.myAllProductFlavors.addAll(module.getProductFlavors());
        Collections.sort(this.myAllProductFlavors, new PsModelNameComparator());
        this.myProductFlavorsPanel = new ProductFlavorsPanel(this.myAllProductFlavors);
        this.myProductFlavorsPanel.add((List<PsProductFlavor> newSelection) -> this.updateScopes(), this);
        scopesPanel.createAndAddToolWindowPanel("Product Flavors", this.myProductFlavorsPanel, this.myProductFlavorsPanel.getPreferredFocusedComponent());
        this.myContentsPanel.add((Component)scopesPanel, "Center");
        this.updateScopes();
        this.setUpContents(this.myMainPanel, AndroidDependencyScopesPanel.getInstructions());
    }

    @NotNull
    private static String getInstructions() {
        if ("Assign a scope to the new dependency by selecting the scopes, build types and product flavors where the dependency will be used.<br/><a href='https://developer.android.com/studio/build/dependencies.html'>Open Documentation</a>" == null) {
            AndroidDependencyScopesPanel.$$$reportNull$$$0(1);
        }
        return "Assign a scope to the new dependency by selecting the scopes, build types and product flavors where the dependency will be used.<br/><a href='https://developer.android.com/studio/build/dependencies.html'>Open Documentation</a>";
    }

    private void updateScopes() {
        List<Configuration> configurations = this.myConfigurationsPanel.getSelectedConfigurations();
        List<PsBuildType> buildTypes = this.myBuildTypesPanel.getSelectedBuildTypes();
        List<PsProductFlavor> productFlavors = this.myProductFlavorsPanel.getSelectedProductFlavors();
        boolean allBuildTypesSelected = buildTypes.size() == this.myAllBuildTypes.size();
        boolean allProductFlavorsSelected = productFlavors.size() == this.myAllProductFlavors.size();
        this.mySelectedScopeNames.clear();
        List<String> scopes = AndroidDependencyScopesPanel.deduceScopes(configurations, buildTypes, productFlavors, allBuildTypesSelected, allProductFlavorsSelected);
        ArrayList mapped = Lists.newArrayListWithCapacity((int)scopes.size());
        for (String scope : scopes) {
            String configurationName = GradleUtil.mapConfigurationName(scope, this.myModelVersion, false);
            mapped.add(configurationName);
        }
        this.mySelectedScopeNames.addAll(mapped);
        String text = "";
        int count = this.mySelectedScopeNames.size();
        if (count == 1) {
            text = this.mySelectedScopeNames.get(0);
        } else if (this.mySelectedScopeNames.size() > 1) {
            Collections.sort(this.mySelectedScopeNames);
            text = Joiner.on((String)", ").join(this.mySelectedScopeNames);
        }
        if (text.isEmpty()) {
            text = " ";
        }
        this.myScopesLabel.setText(text);
    }

    @VisibleForTesting
    static List<String> deduceScopes(@NotNull List<Configuration> configurations, @NotNull List<PsBuildType> buildTypes, @NotNull List<PsProductFlavor> productFlavors, boolean allBuildTypesSelected, boolean allProductFlavorsSelected) {
        if (configurations == null) {
            AndroidDependencyScopesPanel.$$$reportNull$$$0(2);
        }
        if (buildTypes == null) {
            AndroidDependencyScopesPanel.$$$reportNull$$$0(3);
        }
        if (productFlavors == null) {
            AndroidDependencyScopesPanel.$$$reportNull$$$0(4);
        }
        if (configurations.contains(Configuration.MAIN)) {
            if (allBuildTypesSelected && allProductFlavorsSelected) {
                return Collections.singletonList("compile");
            }
            ArrayList scopes = Lists.newArrayList();
            if (!allBuildTypesSelected) {
                scopes.addAll(AndroidDependencyScopesPanel.deduceCompileScopes(buildTypes));
            }
            if (!allProductFlavorsSelected) {
                scopes.addAll(AndroidDependencyScopesPanel.deduceCompileScopes(productFlavors));
            }
            return scopes;
        }
        ArrayList scopes = Lists.newArrayList();
        if (configurations.contains(Configuration.ANDROID_TEST)) {
            boolean debugBuildTypeChecked = false;
            for (PsBuildType buildType : buildTypes) {
                if (!buildType.getName().equals(DEBUG_BUILD_TYPE)) continue;
                debugBuildTypeChecked = true;
                break;
            }
            if (debugBuildTypeChecked) {
                if (allProductFlavorsSelected) {
                    scopes.add("androidTestCompile");
                } else {
                    scopes.addAll(AndroidDependencyScopesPanel.deduceScopes(productFlavors, "androidTest", "Compile"));
                }
            }
        }
        if (configurations.contains(Configuration.UNIT_TEST)) {
            if (allBuildTypesSelected && allProductFlavorsSelected) {
                scopes.add("testCompile");
            } else {
                if (!allBuildTypesSelected) {
                    scopes.addAll(AndroidDependencyScopesPanel.deduceUnitTestScopes(buildTypes));
                }
                if (!allProductFlavorsSelected) {
                    scopes.addAll(AndroidDependencyScopesPanel.deduceUnitTestScopes(productFlavors));
                }
            }
        }
        return scopes;
    }

    @NotNull
    private static List<String> deduceCompileScopes(@NotNull List<? extends PsModel> models) {
        if (models == null) {
            AndroidDependencyScopesPanel.$$$reportNull$$$0(5);
        }
        List<String> list = AndroidDependencyScopesPanel.deduceScopes(models, "", "Compile");
        if (list == null) {
            AndroidDependencyScopesPanel.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static List<String> deduceUnitTestScopes(@NotNull List<? extends PsModel> models) {
        if (models == null) {
            AndroidDependencyScopesPanel.$$$reportNull$$$0(7);
        }
        List<String> list = AndroidDependencyScopesPanel.deduceScopes(models, "test", "Compile");
        if (list == null) {
            AndroidDependencyScopesPanel.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private static List<String> deduceScopes(@NotNull List<? extends PsModel> models, @NotNull String prefix, @NotNull String suffix) {
        if (models == null) {
            AndroidDependencyScopesPanel.$$$reportNull$$$0(9);
        }
        if (prefix == null) {
            AndroidDependencyScopesPanel.$$$reportNull$$$0(10);
        }
        if (suffix == null) {
            AndroidDependencyScopesPanel.$$$reportNull$$$0(11);
        }
        ArrayList configurationNames = Lists.newArrayList();
        for (PsModel psModel : models) {
            StringBuilder buffer = new StringBuilder();
            if (prefix.isEmpty()) {
                buffer.append(psModel.getName());
            } else {
                buffer.append(prefix).append(StringUtil.capitalize((String)psModel.getName()));
            }
            buffer.append(suffix);
            configurationNames.add(buffer.toString());
        }
        ArrayList arrayList = configurationNames;
        if (arrayList == null) {
            AndroidDependencyScopesPanel.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public ValidationInfo validateInput() {
        List<Configuration> configurations = this.myConfigurationsPanel.getSelectedConfigurations();
        if (configurations.isEmpty()) {
            return new ValidationInfo("Please select at least one configuration", (JComponent)this.myConfigurationsPanel);
        }
        List<PsBuildType> buildTypes = this.myBuildTypesPanel.getSelectedBuildTypes();
        if (buildTypes.isEmpty()) {
            return new ValidationInfo("Please select at least one build type", (JComponent)this.myBuildTypesPanel);
        }
        if (this.mySelectedScopeNames.isEmpty() && configurations.size() == 1 && configurations.contains(Configuration.ANDROID_TEST)) {
            boolean hasDebugBuildType = false;
            for (PsBuildType buildType : buildTypes) {
                if (!buildType.getName().equals(DEBUG_BUILD_TYPE)) continue;
                hasDebugBuildType = true;
                break;
            }
            if (!hasDebugBuildType) {
                return new ValidationInfo("For 'Android Tests', the 'debug' build type must be selected", (JComponent)this.myBuildTypesPanel);
            }
        }
        return null;
    }

    @Nullable
    public PsNewDependencyScopes getNewScopes() {
        if (!this.mySelectedScopeNames.isEmpty()) {
            ArrayList artifactNames = Lists.newArrayList();
            this.myConfigurationsPanel.getSelectedConfigurations().forEach(configuration -> artifactNames.add(configuration.getArtifactName()));
            return new PsNewDependencyScopes(this.myBuildTypesPanel.getSelectedBuildTypes(), this.myProductFlavorsPanel.getSelectedProductFlavors(), artifactNames);
        }
        return null;
    }

    @Override
    @NotNull
    public List<String> getSelectedScopeNames() {
        List<String> list = this.mySelectedScopeNames;
        if (list == null) {
            AndroidDependencyScopesPanel.$$$reportNull$$$0(13);
        }
        return list;
    }

    public void dispose() {
        this.myToolWindowPanels.forEach(Disposer::dispose);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/dependencies/android/AndroidDependencyScopesPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildTypes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "productFlavors";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/dependencies/android/AndroidDependencyScopesPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstructions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "deduceCompileScopes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "deduceUnitTestScopes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "deduceScopes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedScopeNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 12: 
            case 13: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deduceScopes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deduceCompileScopes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deduceUnitTestScopes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JXLabel jXLabel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Scope:");
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myScopesLabel = jXLabel = new JXLabel();
        jXLabel.setLineWrap(true);
        jPanel2.add((Component)jXLabel, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myContentsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 7, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private class ScopesPanel
    extends JPanel {
        ScopesPanel() {
            super(new GridLayout(1, 0));
        }

        void createAndAddToolWindowPanel(@NotNull String title, @NotNull JPanel contents, @Nullable JComponent preferredFocusedComponent) {
            if (title == null) {
                ScopesPanel.$$$reportNull$$$0(0);
            }
            if (contents == null) {
                ScopesPanel.$$$reportNull$$$0(1);
            }
            ToolWindowPanel panel = new ToolWindowPanel(title, AndroidIcons.Android, null){};
            ToolWindowHeader header = panel.getHeader();
            int borders = 4;
            if (AndroidDependencyScopesPanel.this.myToolWindowPanels.isEmpty()) {
                borders = 1 | borders;
            }
            header.setBorder(IdeBorderFactory.createBorder((int)borders));
            header.setPreferredFocusedComponent(preferredFocusedComponent);
            if (preferredFocusedComponent instanceof PsCheckBoxList) {
                PsCheckBoxList checkBoxList = (PsCheckBoxList)((Object)preferredFocusedComponent);
                header.setAdditionalActions(checkBoxList.createSelectAllAction(), checkBoxList.createUnselectAllAction());
            }
            panel.add((Component)contents, "Center");
            this.add(panel);
            AndroidDependencyScopesPanel.this.myToolWindowPanels.add(panel);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "contents";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/structure/dependencies/android/AndroidDependencyScopesPanel$ScopesPanel";
            objectArray[2] = "createAndAddToolWindowPanel";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

