/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesByTypeAndTextComparator;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsModulePath;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.android.tools.idea.gradle.structure.navigation.PsLibraryDependencyNavigationPath;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsIssueCollection {
    @NotNull
    private final Object myLock;
    @GuardedBy(value="myLock")
    @NotNull
    private final Multimap<PsPath, PsIssue> myIssues;
    @NotNull
    private final PsContext myContext;

    public PsIssueCollection(@NotNull PsContext context) {
        if (context == null) {
            PsIssueCollection.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myIssues = HashMultimap.create();
        this.myContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull PsIssue issue2) {
        if (issue2 == null) {
            PsIssueCollection.$$$reportNull$$$0(1);
        }
        PsPath path = issue2.getPath();
        Object object = this.myLock;
        synchronized (object) {
            this.myIssues.put((Object)path, (Object)issue2);
            for (PsPath parent : path.getParents()) {
                this.myIssues.put((Object)parent, (Object)issue2);
            }
        }
    }

    @NotNull
    public List<PsIssue> findIssues(@NotNull PsModel model, @Nullable Comparator<PsIssue> comparator2) {
        if (model == null) {
            PsIssueCollection.$$$reportNull$$$0(2);
        }
        PsPath path = null;
        if (model instanceof PsModule) {
            PsModule module = (PsModule)model;
            path = new PsModulePath(module);
        }
        if (model instanceof PsLibraryDependency) {
            PsLibraryDependency dependency = (PsLibraryDependency)((Object)model);
            path = new PsLibraryDependencyNavigationPath(dependency);
        }
        if (path != null) {
            List<PsIssue> list = this.findIssues(path, comparator2);
            if (list == null) {
                PsIssueCollection.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<PsIssue> list = Collections.emptyList();
        if (list == null) {
            PsIssueCollection.$$$reportNull$$$0(4);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<PsIssue> findIssues(@NotNull PsPath path, @Nullable Comparator<PsIssue> comparator2) {
        ArrayList<PsIssue> issueList;
        if (path == null) {
            PsIssueCollection.$$$reportNull$$$0(5);
        }
        Object object = this.myLock;
        synchronized (object) {
            issueList = new ArrayList<PsIssue>(this.myIssues.get((Object)path));
        }
        if (comparator2 != null && issueList.size() > 1) {
            Collections.sort(issueList, comparator2);
        }
        ArrayList<PsIssue> arrayList = issueList;
        if (arrayList == null) {
            PsIssueCollection.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<PsIssue> getValues() {
        Object object = this.myLock;
        // MONITORENTER : object
        ArrayList<PsIssue> arrayList = new ArrayList<PsIssue>(this.myIssues.values());
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        PsIssueCollection.$$$reportNull$$$0(7);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<PsIssue> getValues(@NotNull Class<? extends PsPath> pathType) {
        if (pathType == null) {
            PsIssueCollection.$$$reportNull$$$0(8);
        }
        HashSet issues = new HashSet();
        Object object = this.myLock;
        synchronized (object) {
            for (PsPath path : this.myIssues.keySet()) {
                if (!pathType.isInstance(path)) continue;
                issues.addAll(this.myIssues.get((Object)path));
            }
        }
        ArrayList<PsIssue> arrayList = new ArrayList<PsIssue>(issues);
        if (arrayList == null) {
            PsIssueCollection.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myIssues.isEmpty();
        }
    }

    @Nullable
    public static String getTooltipText(@NotNull List<PsIssue> issues, boolean includePath) {
        if (issues == null) {
            PsIssueCollection.$$$reportNull$$$0(10);
        }
        if (issues.isEmpty()) {
            return null;
        }
        ArrayList<PsIssue> sorted = new ArrayList<PsIssue>(issues);
        Collections.sort(sorted, IssuesByTypeAndTextComparator.INSTANCE);
        boolean useBullets = issues.size() > 1;
        LinkedHashSet<String> lines = new LinkedHashSet<String>();
        for (PsIssue issue2 : sorted) {
            String path;
            String line = issue2.getText();
            if (includePath && !(path = issue2.getPath().toText(PsPath.TexType.PLAIN_TEXT)).isEmpty()) {
                line = path + ": " + line;
            }
            if (useBullets) {
                line = "<li>" + line + "</li>";
            }
            lines.add(line);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("<html><body>");
        if (useBullets) {
            buffer.append("<ul>");
        }
        int issueCount = lines.size();
        int problems = 0;
        int count = 0;
        boolean tooManyMessages = false;
        for (String line : lines) {
            buffer.append(line);
            if (!useBullets) {
                buffer.append("<br>");
            }
            ++problems;
            if (count++ <= 9 || issueCount <= 12) continue;
            if (useBullets) {
                buffer.append("</ul>");
            }
            buffer.append(issueCount - problems).append(" more messages...<br>");
            tooManyMessages = true;
            break;
        }
        if (useBullets && !tooManyMessages) {
            buffer.append("</ul>");
        }
        buffer.append("</body></html>");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@NotNull PsIssueType type) {
        if (type == null) {
            PsIssueCollection.$$$reportNull$$$0(11);
        }
        Object object = this.myLock;
        synchronized (object) {
            Set paths = this.myIssues.keySet();
            ArrayList<Pair> toRemove = new ArrayList<Pair>();
            for (PsPath path : paths) {
                Collection issues = this.myIssues.get((Object)path);
                for (PsIssue issue2 : issues) {
                    if (!issue2.getType().equals(type)) continue;
                    toRemove.add(Pair.create((Object)path, (Object)issue2));
                }
            }
            for (Pair pair : toRemove) {
                this.myIssues.remove(pair.getFirst(), pair.getSecond());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/model/PsIssueCollection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issues";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/model/PsIssueCollection";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findIssues";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findIssues";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTooltipText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

