/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model;

import com.android.tools.idea.gradle.dsl.api.GradleModelProvider;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsModuleCollection;
import com.android.tools.idea.gradle.structure.model.PsPomDependencies;
import com.android.tools.idea.gradle.structure.model.PsPomDependencyCache;
import com.android.tools.idea.gradle.structure.model.PsVariables;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsProject
extends PsModel {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectBuildModel myParsedModel;
    @NotNull
    private final PsVariables myVariables;
    @NotNull
    private final PsPomDependencyCache myPomDependencyCache;
    @NotNull
    private final PsModuleCollection myModuleCollection;
    private boolean myModified;

    public PsProject(@NotNull Project project) {
        if (project == null) {
            PsProject.$$$reportNull$$$0(0);
        }
        this.myPomDependencyCache = new PsPomDependencies();
        this.myProject = project;
        this.myParsedModel = GradleModelProvider.get().getProjectModel(project);
        this.myVariables = new PsVariables(this, "Project: " + this.getName(), Objects.requireNonNull(this.myParsedModel.getProjectBuildModel()).ext(), null);
        this.myModuleCollection = new PsModuleCollection(this);
    }

    @Nullable
    public PsModule findModuleByName(@NotNull String moduleName) {
        if (moduleName == null) {
            PsProject.$$$reportNull$$$0(1);
        }
        return this.myModuleCollection.items().stream().filter(it -> {
            if (moduleName == null) {
                PsProject.$$$reportNull$$$0(10);
            }
            return Objects.equals(it.getName(), moduleName);
        }).findFirst().orElse(null);
    }

    @Nullable
    public PsModule findModuleByGradlePath(@NotNull String gradlePath) {
        if (gradlePath == null) {
            PsProject.$$$reportNull$$$0(2);
        }
        return this.myModuleCollection.items().stream().filter(it -> {
            if (gradlePath == null) {
                PsProject.$$$reportNull$$$0(9);
            }
            return Objects.equals(it.getGradlePath(), gradlePath);
        }).findFirst().orElse(null);
    }

    @NotNull
    public Project getResolvedModel() {
        Project project = this.myProject;
        if (project == null) {
            PsProject.$$$reportNull$$$0(3);
        }
        return project;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myProject.getName();
        if (string == null) {
            PsProject.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void forEachModule(@NotNull Consumer<PsModule> consumer) {
        if (consumer == null) {
            PsProject.$$$reportNull$$$0(5);
        }
        this.myModuleCollection.items().stream().sorted(Comparator.comparing(v -> v.getName().toLowerCase())).forEachOrdered(consumer);
    }

    @Override
    @Nullable
    public PsModel getParent() {
        return null;
    }

    @Override
    public boolean isDeclared() {
        return true;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return null;
    }

    public int getModelCount() {
        return this.myModuleCollection.items().size();
    }

    public void applyChanges() {
        if (this.isModified()) {
            new WriteCommandAction(this.getResolvedModel(), "Applying changes to the project structure.", new PsiFile[0]){

                protected void run(@NotNull Result result2) {
                    if (result2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    PsProject.this.myParsedModel.applyChanges();
                    PsProject.this.setModified(false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/structure/model/PsProject$1", "run"));
                }
            }.execute();
        }
    }

    @NotNull
    public PsVariables getVariables() {
        PsVariables psVariables = this.myVariables;
        if (psVariables == null) {
            PsProject.$$$reportNull$$$0(6);
        }
        return psVariables;
    }

    @NotNull
    public PsPomDependencyCache getPomDependencyCache() {
        PsPomDependencyCache psPomDependencyCache = this.myPomDependencyCache;
        if (psPomDependencyCache == null) {
            PsProject.$$$reportNull$$$0(7);
        }
        return psPomDependencyCache;
    }

    @NotNull
    public ProjectBuildModel getParsedModel() {
        ProjectBuildModel projectBuildModel = this.myParsedModel;
        if (projectBuildModel == null) {
            PsProject.$$$reportNull$$$0(8);
        }
        return projectBuildModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/model/PsProject";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/model/PsProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariables";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPomDependencyCache";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParsedModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findModuleByName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findModuleByGradlePath";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forEachModule";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findModuleByGradlePath$1";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findModuleByName$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

