/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.helpers;

import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.dsl.api.util.LanguageLevelUtil;
import com.android.tools.idea.gradle.structure.model.meta.Annotated;
import com.android.tools.idea.gradle.structure.model.meta.DslText;
import com.android.tools.idea.gradle.structure.model.meta.ParsedValue;
import com.android.tools.idea.gradle.structure.model.meta.ParsedValueKt;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001d\u0010\u0006\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\b\u001a\"\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\f\u001a\"\u0010\u000f\u001a\u00020\n2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u0001\u001a$\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00120\u00112\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u0001\u001a;\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00150\u00120\u0011\"\u0006\b\u0000\u0010\u0015\u0018\u00012\u0006\u0010\u0013\u001a\u00020\u00012\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00150\u0017H\u0086\b\u001a$\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00120\u00112\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u0001\u001a$\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00120\u00112\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u0001\u001a$\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u00120\u00112\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u0001\u001a$\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00120\u00112\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u0001\u001a$\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00120\u00112\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u0001\u001a$\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00120\u00112\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u0001\u00a8\u0006\u001f"}, d2={"formatLanguageLevel", "", "context", "", "value", "Lcom/intellij/pom/java/LanguageLevel;", "formatUnit", "", "(Ljava/lang/Object;Lkotlin/Unit;)Ljava/lang/String;", "matchFiles", "", "rootDir", "Ljava/io/File;", "parsed", "resolved", "matchHashStrings", "parseBoolean", "Lcom/android/tools/idea/gradle/structure/model/meta/Annotated;", "Lcom/android/tools/idea/gradle/structure/model/meta/ParsedValue;", "text", "parseEnum", "T", "parser", "Lkotlin/Function1;", "parseFile", "parseHashString", "parseInt", "", "parseLanguageLevel", "parseReferenceOnly", "parseString", "intellij.android.core"})
public final class InputParsersKt {
    @NotNull
    public static final Annotated<ParsedValue<String>> parseString(@Nullable Object context, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return Intrinsics.areEqual((Object)text, (Object)"") ? ParsedValueKt.annotated(ParsedValue.NotSet.INSTANCE) : ParsedValueKt.annotated(new ParsedValue.Set.Parsed<String>(text, DslText.Literal.INSTANCE));
    }

    @NotNull
    public static final Annotated<ParsedValue<File>> parseFile(@Nullable Object context, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return Intrinsics.areEqual((Object)text, (Object)"") ? ParsedValueKt.annotated(ParsedValue.NotSet.INSTANCE) : ParsedValueKt.annotated(new ParsedValue.Set.Parsed<File>(new File(text), DslText.Literal.INSTANCE));
    }

    private static final <T> Annotated<ParsedValue<T>> parseEnum(String text, Function1<? super String, ? extends T> parser) {
        Annotated<ParsedValue<T>> annotated;
        if (Intrinsics.areEqual((Object)text, (Object)"")) {
            annotated = ParsedValueKt.annotated(ParsedValue.NotSet.INSTANCE);
        } else {
            Object parsed = parser.invoke((Object)text);
            if (parsed != null) {
                annotated = ParsedValueKt.annotated(new ParsedValue.Set.Parsed<Object>(parsed, DslText.Literal.INSTANCE));
            } else {
                ParsedValue.Set.Parsed<Object> parsed2 = new ParsedValue.Set.Parsed<Object>(null, new DslText.OtherUnparsedDslText(text));
                StringBuilder stringBuilder = new StringBuilder().append('\'').append(text).append("' is not a valid value of type ");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                annotated = ParsedValueKt.annotateWithError(parsed2, stringBuilder.append(Reflection.getOrCreateKotlinClass(Object.class).getSimpleName()).toString());
            }
        }
        return annotated;
    }

    @NotNull
    public static final Annotated<ParsedValue<Boolean>> parseBoolean(@Nullable Object context, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return Intrinsics.areEqual((Object)text, (Object)"") ? ParsedValueKt.annotated(ParsedValue.NotSet.INSTANCE) : (StringsKt.equals((String)text, (String)"true", (boolean)true) ? ParsedValueKt.annotated(new ParsedValue.Set.Parsed<Boolean>(true, DslText.Literal.INSTANCE)) : (StringsKt.equals((String)text, (String)"false", (boolean)true) ? ParsedValueKt.annotated(new ParsedValue.Set.Parsed<Boolean>(false, DslText.Literal.INSTANCE)) : ParsedValueKt.annotateWithError(new ParsedValue.Set.Parsed<Object>(null, new DslText.OtherUnparsedDslText(text)), "Unknown boolean value: '" + text + "'. Expected 'true' or 'false'")));
    }

    @NotNull
    public static final Annotated<ParsedValue<Integer>> parseInt(@Nullable Object context, @NotNull String text) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        if (Intrinsics.areEqual((Object)text, (Object)"")) {
            object = ParsedValueKt.annotated(ParsedValue.NotSet.INSTANCE);
        } else {
            Annotated<ParsedValue.Set.Parsed<Object>> annotated;
            try {
                ParsedValue.Set.Parsed<Integer> parsed;
                annotated = text;
                ParsedValue.Set.Parsed<Integer> parsed2 = parsed;
                ParsedValue.Set.Parsed<Integer> parsed3 = parsed;
                int n = Integer.parseInt((String)((Object)annotated));
                parsed2(n, DslText.Literal.INSTANCE);
                annotated = ParsedValueKt.annotated(parsed3);
            }
            catch (NumberFormatException ex) {
                annotated = ParsedValueKt.annotateWithError(new ParsedValue.Set.Parsed<Object>(null, new DslText.OtherUnparsedDslText(text)), '\'' + text + "' is not a valid integer value");
            }
            object = annotated;
        }
        return object;
    }

    @NotNull
    public static final Annotated<ParsedValue<LanguageLevel>> parseLanguageLevel(@Nullable Object context, @NotNull String text) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        if (Intrinsics.areEqual((Object)text, (Object)"")) {
            object = ParsedValueKt.annotated(ParsedValue.NotSet.INSTANCE);
        } else {
            LanguageLevel languageLevel;
            LanguageLevel it;
            object = LanguageLevelUtil.parseFromGradleString(text);
            if (object == null || (object = ParsedValueKt.annotated(new ParsedValue.Set.Parsed<LanguageLevel>(it = (languageLevel = object), DslText.Literal.INSTANCE))) == null) {
                object = ParsedValueKt.annotateWithError(new ParsedValue.Set.Parsed<Object>(null, new DslText.OtherUnparsedDslText(text)), '\'' + text + "' is not a valid language level");
            }
        }
        return object;
    }

    @NotNull
    public static final Annotated<ParsedValue<String>> parseHashString(@Nullable Object context, @NotNull String text) {
        Object object;
        block3: {
            block4: {
                CharSequence charSequence;
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                    charSequence = text;
                    if (!(charSequence.length() == 0)) break block2;
                    object = ParsedValueKt.annotated(ParsedValue.NotSet.INSTANCE);
                    break block3;
                }
                object = AndroidTargetHash.getPlatformVersion((String)text);
                if (object == null) break block4;
                CharSequence it = charSequence = object;
                object = ParsedValueKt.annotated(new ParsedValue.Set.Parsed<String>(text, DslText.Literal.INSTANCE));
                if (object != null) break block3;
            }
            object = ParsedValueKt.annotateWithError(new ParsedValue.Set.Parsed<String>(text, DslText.Literal.INSTANCE), "Invalid hash string");
        }
        return object;
    }

    @NotNull
    public static final Annotated<ParsedValue<Unit>> parseReferenceOnly(@Nullable Object context, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return Intrinsics.areEqual((Object)text, (Object)"") ? ParsedValueKt.annotated(ParsedValue.NotSet.INSTANCE) : ParsedValueKt.annotateWithError(new ParsedValue.Set.Parsed<Object>(null, new DslText.OtherUnparsedDslText(text)), "A signing config reference should be in a form of '$configName'");
    }

    @NotNull
    public static final String formatLanguageLevel(@Nullable Object context, @NotNull LanguageLevel value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = value.toJavaVersion().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value.toJavaVersion().toString()");
        return string;
    }

    @NotNull
    public static final String formatUnit(@Nullable Object context, @NotNull Unit value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return "";
    }

    public static final boolean matchHashStrings(@Nullable Object context, @Nullable String parsed, @NotNull String resolved) {
        Intrinsics.checkParameterIsNotNull((Object)resolved, (String)"resolved");
        String string = parsed;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        AndroidVersion androidVersion = AndroidTargetHash.getPlatformVersion((String)string2);
        AndroidVersion androidVersion2 = AndroidTargetHash.getPlatformVersion((String)resolved);
        return Intrinsics.areEqual((Object)(androidVersion != null ? Integer.valueOf(androidVersion.getFeatureLevel()) : null), (Object)(androidVersion2 != null ? Integer.valueOf(androidVersion2.getFeatureLevel()) : null));
    }

    public static final boolean matchFiles(@Nullable File rootDir, @Nullable File parsed, @NotNull File resolved) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)resolved, (String)"resolved");
        File file2 = parsed;
        if (file2 != null) {
            File file3;
            File it = file3 = file2;
            File file4 = rootDir;
            file = file4 != null ? FilesKt.resolve((File)file4, (File)parsed) : null;
        } else {
            file = null;
        }
        return Intrinsics.areEqual(file, (Object)resolved);
    }
}

