/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.repositories.search;

import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepositorySearchResults;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepositorySearchService;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchRequest;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import net.jcip.annotations.NotThreadSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

@NotThreadSafe
public class ArtifactRepositorySearch
implements ArtifactRepositorySearchService {
    @NotNull
    private final List<ArtifactRepository> myRepositories;
    @NotNull
    ListeningExecutorService executor;

    public ArtifactRepositorySearch(@NotNull List<ArtifactRepository> repositories) {
        if (repositories == null) {
            ArtifactRepositorySearch.$$$reportNull$$$0(0);
        }
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE);
        this.myRepositories = repositories;
    }

    @Override
    @NotNull
    public ListenableFuture<ArtifactRepositorySearchResults> search(@NotNull SearchRequest request) {
        if (request == null) {
            ArtifactRepositorySearch.$$$reportNull$$$0(1);
        }
        ArrayList jobs = Lists.newArrayListWithExpectedSize((int)this.myRepositories.size());
        ArrayList results = Lists.newArrayList();
        ArrayList errors = Lists.newArrayList();
        for (ArtifactRepository repository : this.myRepositories) {
            jobs.add(this.executor.submit(() -> {
                if (request == null) {
                    ArtifactRepositorySearch.$$$reportNull$$$0(3);
                }
                return repository.search(request);
            }));
        }
        ListenableFuture listenableFuture = Futures.whenAllComplete((Iterable)jobs).call(() -> {
            for (Future job : jobs) {
                try {
                    results.add(Futures.getChecked((Future)job, Exception.class));
                }
                catch (Exception e) {
                    errors.add(e);
                }
            }
            return new ArtifactRepositorySearchResults(results, errors);
        });
        if (listenableFuture == null) {
            ArtifactRepositorySearch.$$$reportNull$$$0(2);
        }
        return listenableFuture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/model/repositories/search/ArtifactRepositorySearch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/model/repositories/search/ArtifactRepositorySearch";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "search";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "search";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$search$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

