/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.repositories.search;

import com.android.ide.common.repository.GradleVersion;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class FoundArtifact
implements Comparable<FoundArtifact> {
    @NotNull
    private final String myRepositoryName;
    @NotNull
    private final String myGroupId;
    @NotNull
    private final String myName;
    @NotNull
    private final List<GradleVersion> myVersions;

    public FoundArtifact(@NotNull String repositoryName, @NotNull String groupId, @NotNull String name, @NotNull GradleVersion version2) {
        if (repositoryName == null) {
            FoundArtifact.$$$reportNull$$$0(0);
        }
        if (groupId == null) {
            FoundArtifact.$$$reportNull$$$0(1);
        }
        if (name == null) {
            FoundArtifact.$$$reportNull$$$0(2);
        }
        if (version2 == null) {
            FoundArtifact.$$$reportNull$$$0(3);
        }
        this(repositoryName, groupId, name);
        this.myVersions.add(version2);
        this.sortVersionsFromNewestToOldest();
    }

    public FoundArtifact(@NotNull String repositoryName, @NotNull String groupId, @NotNull String name, @NotNull List<GradleVersion> versions) {
        if (repositoryName == null) {
            FoundArtifact.$$$reportNull$$$0(4);
        }
        if (groupId == null) {
            FoundArtifact.$$$reportNull$$$0(5);
        }
        if (name == null) {
            FoundArtifact.$$$reportNull$$$0(6);
        }
        if (versions == null) {
            FoundArtifact.$$$reportNull$$$0(7);
        }
        this(repositoryName, groupId, name);
        this.myVersions.addAll(versions);
        this.sortVersionsFromNewestToOldest();
    }

    private void sortVersionsFromNewestToOldest() {
        if (this.myVersions.size() > 1) {
            Collections.sort(this.myVersions, Collections.reverseOrder());
        }
    }

    private FoundArtifact(@NotNull String repositoryName, @NotNull String groupId, @NotNull String name) {
        if (repositoryName == null) {
            FoundArtifact.$$$reportNull$$$0(8);
        }
        if (groupId == null) {
            FoundArtifact.$$$reportNull$$$0(9);
        }
        if (name == null) {
            FoundArtifact.$$$reportNull$$$0(10);
        }
        this.myVersions = Lists.newArrayList();
        this.myRepositoryName = repositoryName;
        this.myGroupId = groupId;
        this.myName = name;
    }

    @NotNull
    public String getRepositoryName() {
        String string = this.myRepositoryName;
        if (string == null) {
            FoundArtifact.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public String getGroupId() {
        String string = this.myGroupId;
        if (string == null) {
            FoundArtifact.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            FoundArtifact.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public List<GradleVersion> getVersions() {
        List<GradleVersion> list = this.myVersions;
        if (list == null) {
            FoundArtifact.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Override
    public int compareTo(FoundArtifact other) {
        int compare = FoundArtifact.comparePrioritizedStrings(this.myRepositoryName, other.myRepositoryName, FoundArtifact::getRepositoryPriority);
        if (compare != 0) {
            return compare;
        }
        compare = FoundArtifact.comparePrioritizedStrings(this.myGroupId, other.myGroupId, FoundArtifact::getPackagePriority);
        if (compare != 0) {
            return compare;
        }
        return this.myName.compareTo(other.myName);
    }

    private static int comparePrioritizedStrings(@NotNull String s1, @NotNull String s2, @NotNull Function<String, Integer> getPriority) {
        if (s1 == null) {
            FoundArtifact.$$$reportNull$$$0(15);
        }
        if (s2 == null) {
            FoundArtifact.$$$reportNull$$$0(16);
        }
        if (getPriority == null) {
            FoundArtifact.$$$reportNull$$$0(17);
        }
        if (s1.equals(s2)) {
            return 0;
        }
        int relativePriority = getPriority.apply(s1) - getPriority.apply(s2);
        if (relativePriority == 0) {
            return s1.compareTo(s2);
        }
        return relativePriority;
    }

    private static int getPackagePriority(@NotNull String packageName) {
        if (packageName == null) {
            FoundArtifact.$$$reportNull$$$0(18);
        }
        if (packageName.startsWith("com.android")) {
            return 0;
        }
        if (packageName.startsWith("com.google")) {
            return 1;
        }
        return 2;
    }

    private static int getRepositoryPriority(@NotNull String repositoryName) {
        if (repositoryName == null) {
            FoundArtifact.$$$reportNull$$$0(19);
        }
        if (repositoryName.startsWith("Android Repository")) {
            return 0;
        }
        if (repositoryName.startsWith("Google Repository")) {
            return 1;
        }
        return 2;
    }

    @NotNull
    public List<String> getCoordinates() {
        String groupIdAndName = this.myGroupId + ":" + this.myName;
        List<String> list = this.myVersions.stream().map(version2 -> groupIdAndName + ":" + version2).collect(Collectors.toList());
        if (list == null) {
            FoundArtifact.$$$reportNull$$$0(20);
        }
        return list;
    }

    public String toString() {
        return "{repository='" + this.myRepositoryName + '\'' + ", group='" + this.myGroupId + '\'' + ", name='" + this.myName + '\'' + ", versions=" + this.myVersions + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryName";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versions";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getPriority";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersions";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoordinates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: {
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "comparePrioritizedStrings";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPackagePriority";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryPriority";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

