/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.navigation;

import com.android.tools.idea.gradle.structure.configurables.DependenciesPerspectiveConfigurable;
import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsModulePath;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.android.tools.idea.gradle.structure.navigation.Places;
import com.android.tools.idea.structure.dialog.ProjectStructureConfigurable;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.options.Configurable;
import com.intellij.ui.navigation.Place;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PsLibraryDependencyNavigationPath
implements PsPath {
    @NotNull
    private final PsModulePath myParent;
    @NotNull
    private final String myModuleName;
    @NotNull
    private final String myDependency;
    @NotNull
    private final String myNavigationText;

    public PsLibraryDependencyNavigationPath(@NotNull PsLibraryDependency dependency) {
        if (dependency == null) {
            PsLibraryDependencyNavigationPath.$$$reportNull$$$0(0);
        }
        this.myParent = new PsModulePath(dependency.getParent());
        this.myModuleName = dependency.getParent().getName();
        PsArtifactDependencySpec spec = dependency.getSpec();
        this.myNavigationText = dependency.toText(PsDependency.TextType.FOR_NAVIGATION);
        this.myDependency = spec.getName() + ":" + spec.getVersion();
    }

    @Override
    @NotNull
    public String toText(@NotNull PsPath.TexType type) {
        if (type == null) {
            PsLibraryDependencyNavigationPath.$$$reportNull$$$0(1);
        }
        switch (type) {
            case PLAIN_TEXT: {
                String string = this.myDependency;
                if (string == null) {
                    PsLibraryDependencyNavigationPath.$$$reportNull$$$0(2);
                }
                return string;
            }
            case FOR_COMPARE_TO: {
                String string = this.myDependency + " / " + this.myModuleName;
                if (string == null) {
                    PsLibraryDependencyNavigationPath.$$$reportNull$$$0(3);
                }
                return string;
            }
        }
        if ("" == null) {
            PsLibraryDependencyNavigationPath.$$$reportNull$$$0(4);
        }
        return "";
    }

    @Override
    @NotNull
    public String getHyperlinkDestination(@NotNull PsContext context) {
        if (context == null) {
            PsLibraryDependencyNavigationPath.$$$reportNull$$$0(5);
        }
        Place place = new Place();
        ProjectStructureConfigurable mainConfigurable = context.getMainConfigurable();
        DependenciesPerspectiveConfigurable target = mainConfigurable.findConfigurable(DependenciesPerspectiveConfigurable.class);
        assert (target != null);
        ProjectStructureConfigurable.putPath(place, (Configurable)target);
        target.putNavigationPath(place, this.myModuleName, this.myNavigationText);
        String string = "psdGoTo://" + Places.serialize(place);
        if (string == null) {
            PsLibraryDependencyNavigationPath.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public String getHtml(@NotNull PsContext context) {
        if (context == null) {
            PsLibraryDependencyNavigationPath.$$$reportNull$$$0(7);
        }
        String string = String.format("<a href='%1$s'>%2$s</a> (%3$s)", this.getHyperlinkDestination(context), this.myDependency, this.myModuleName);
        if (string == null) {
            PsLibraryDependencyNavigationPath.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public List<PsPath> getParents() {
        ImmutableList immutableList = ImmutableList.of((Object)this.myParent);
        if (immutableList == null) {
            PsLibraryDependencyNavigationPath.$$$reportNull$$$0(9);
        }
        return immutableList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsLibraryDependencyNavigationPath path = (PsLibraryDependencyNavigationPath)o;
        return Objects.equal((Object)this.myParent, (Object)path.myParent) && Objects.equal((Object)this.myModuleName, (Object)path.myModuleName) && Objects.equal((Object)this.myDependency, (Object)path.myDependency) && Objects.equal((Object)this.myNavigationText, (Object)path.myNavigationText);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myParent, this.myModuleName, this.myDependency, this.myNavigationText});
    }

    public String toString() {
        return this.toText(PsPath.TexType.FOR_COMPARE_TO);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/navigation/PsLibraryDependencyNavigationPath";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/navigation/PsLibraryDependencyNavigationPath";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHyperlinkDestination";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtml";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getParents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getHyperlinkDestination";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHtml";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

