/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.quickfix;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PsLibraryDependencyVersionQuickFixPath
implements PsPath {
    public static final String DEFAULT_QUICK_FIX_TEXT = "[Fix]";
    @NotNull
    private final String myModuleName;
    @NotNull
    private final String myDependency;
    @NotNull
    private final String myVersion;
    @NotNull
    private final String myQuickFixText;
    @NotNull
    private final String myConfigurationName;

    public PsLibraryDependencyVersionQuickFixPath(@NotNull PsLibraryDependency dependency, @NotNull String quickFixText) {
        if (dependency == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(0);
        }
        if (quickFixText == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(1);
        }
        this.myModuleName = dependency.getParent().getName();
        this.myDependency = PsLibraryDependencyVersionQuickFixPath.getCompactNotation(dependency);
        String version2 = dependency.getSpec().getVersion();
        assert (version2 != null);
        this.myConfigurationName = dependency.getJoinedConfigurationNames();
        this.myVersion = version2;
        this.myQuickFixText = quickFixText;
    }

    public PsLibraryDependencyVersionQuickFixPath(@NotNull PsLibraryDependency dependency, @NotNull String version2, @NotNull String quickFixText) {
        if (dependency == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(2);
        }
        if (version2 == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(3);
        }
        if (quickFixText == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(4);
        }
        this.myModuleName = dependency.getParent().getName();
        this.myDependency = PsLibraryDependencyVersionQuickFixPath.getCompactNotation(dependency);
        this.myConfigurationName = dependency.getJoinedConfigurationNames();
        this.myVersion = version2;
        this.myQuickFixText = quickFixText;
    }

    @NotNull
    private static String getCompactNotation(@NotNull PsLibraryDependency dependency) {
        if (dependency == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(5);
        }
        String string = dependency.getSpec().compactNotation();
        if (string == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public String toText(@NotNull PsPath.TexType type) {
        if (type == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(7);
        }
        String string = String.format("%s (%s)", this.myDependency, this.myConfigurationName);
        if (string == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public String getHyperlinkDestination(@NotNull PsContext context) {
        if (context == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(9);
        }
        String path = Joiner.on((char)'/').join((Object)"setLibraryDependency", (Object)this.myModuleName, new Object[]{this.myDependency, this.myConfigurationName, this.myVersion});
        String string = "psdFix://" + path;
        if (string == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @NotNull
    public String getHtml(@NotNull PsContext context) {
        if (context == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(11);
        }
        String string = String.format("<a href=\"%s\">%s</a>", this.getHyperlinkDestination(context), this.myQuickFixText);
        if (string == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @NotNull
    public List<PsPath> getParents() {
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(13);
        }
        return immutableList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsLibraryDependencyVersionQuickFixPath path = (PsLibraryDependencyVersionQuickFixPath)o;
        return Objects.equal((Object)this.myModuleName, (Object)path.myModuleName) && Objects.equal((Object)this.myDependency, (Object)path.myDependency) && Objects.equal((Object)this.myVersion, (Object)path.myVersion) && Objects.equal((Object)this.myConfigurationName, (Object)path.myConfigurationName) && Objects.equal((Object)this.myQuickFixText, (Object)path.myQuickFixText);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myModuleName, this.myDependency, this.myVersion, this.myConfigurationName, this.myQuickFixText});
    }

    public String toString() {
        return this.toText(PsPath.TexType.FOR_COMPARE_TO);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/quickfix/PsLibraryDependencyVersionQuickFixPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/quickfix/PsLibraryDependencyVersionQuickFixPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompactNotation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getHyperlinkDestination";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtml";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getParents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCompactNotation";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getHyperlinkDestination";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getHtml";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

