/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.AppBundleProjectBuildOutput;
import com.android.builder.model.AppBundleVariantBuildOutput;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.plugin.AndroidPluginVersionUpdater;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.run.PostBuildModel;
import com.android.tools.idea.gradle.run.PostBuildModelProvider;
import com.android.tools.idea.run.AndroidAppRunConfigurationBase;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.ApkFileUnit;
import com.android.tools.idea.run.ApkInfo;
import com.android.utils.HtmlBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicAppUtils {
    private static final int UPDATE_BUTTON_INDEX = 1;

    @NotNull
    public static List<Module> getDependentFeatureModules(@NotNull Module module) {
        AndroidModuleModel androidModule;
        if (module == null) {
            DynamicAppUtils.$$$reportNull$$$0(0);
        }
        if ((androidModule = AndroidModuleModel.get(module)) == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                DynamicAppUtils.$$$reportNull$$$0(1);
            }
            return immutableList;
        }
        List<Module> list = DynamicAppUtils.getDependentFeatureModules(module.getProject(), (AndroidProject)androidModule.getAndroidProject());
        if (list == null) {
            DynamicAppUtils.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public static Module getBaseFeature(@NotNull Module module) {
        String gradlePath;
        if (module == null) {
            DynamicAppUtils.$$$reportNull$$$0(3);
        }
        if ((gradlePath = DynamicAppUtils.getGradlePath(module)) == null) {
            return null;
        }
        return Arrays.stream(ModuleManager.getInstance((Project)module.getProject()).getModules()).filter(baseModule -> {
            AndroidModuleModel baseModel = AndroidModuleModel.get(baseModule);
            return baseModel != null && baseModel.getAndroidProject().getDynamicFeatures().contains(gradlePath);
        }).findFirst().orElse(null);
    }

    @NotNull
    public static List<Module> getDependentFeatureModules(@NotNull Project project, @NotNull AndroidProject androidProject) {
        if (project == null) {
            DynamicAppUtils.$$$reportNull$$$0(4);
        }
        if (androidProject == null) {
            DynamicAppUtils.$$$reportNull$$$0(5);
        }
        Map<String, Module> featureMap = DynamicAppUtils.getDynamicFeaturesMap(project);
        List<Module> list = androidProject.getDynamicFeatures().stream().map(featurePath -> (Module)featureMap.get(featurePath)).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            DynamicAppUtils.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public static List<Module> getModulesToBuild(@NotNull Module module) {
        if (module == null) {
            DynamicAppUtils.$$$reportNull$$$0(7);
        }
        List<Module> list = Stream.concat(Stream.of(module), DynamicAppUtils.getDependentFeatureModules(module).stream()).collect(Collectors.toList());
        if (list == null) {
            DynamicAppUtils.$$$reportNull$$$0(8);
        }
        return list;
    }

    public static boolean isInstantRunSupported(@NotNull Module module) {
        AndroidModuleModel androidModule;
        if (module == null) {
            DynamicAppUtils.$$$reportNull$$$0(9);
        }
        if ((androidModule = AndroidModuleModel.get(module)) == null) {
            return true;
        }
        return androidModule.getAndroidProject().getDynamicFeatures().isEmpty();
    }

    @NotNull
    public static List<Module> getModulesSupportingBundleTask(@NotNull Project project) {
        if (project == null) {
            DynamicAppUtils.$$$reportNull$$$0(10);
        }
        List<Module> list = ProjectStructure.getInstance(project).getAppModules().stream().filter(module -> DynamicAppUtils.supportsBundleTask(module)).collect(Collectors.toList());
        if (list == null) {
            DynamicAppUtils.$$$reportNull$$$0(11);
        }
        return list;
    }

    public static boolean supportsBundleTask(@NotNull Module module) {
        AndroidModuleModel androidModule;
        if (module == null) {
            DynamicAppUtils.$$$reportNull$$$0(12);
        }
        if ((androidModule = AndroidModuleModel.get(module)) == null) {
            return false;
        }
        return !StringUtil.isEmpty((String)androidModule.getSelectedVariant().getMainArtifact().getBundleTaskName());
    }

    public static boolean promptUserForGradleUpdate(@NotNull Project project) {
        if (project == null) {
            DynamicAppUtils.$$$reportNull$$$0(13);
        }
        HtmlBuilder builder = new HtmlBuilder();
        builder.openHtmlBody();
        builder.add("Building Android App Bundles requires you to update to the latest version of the Android Gradle Plugin.");
        builder.newline();
        builder.addLink("Learn More", "https://d.android.com/r/studio-ui/dynamic-delivery/overview.html");
        builder.newline();
        builder.newline();
        builder.add("App bundles allow you to support multiple device configurations from a single build artifact.");
        builder.newline();
        builder.add("App stores that support the bundle format use it to build and sign your APKs for you, and");
        builder.newline();
        builder.add("serve those APKs to users as needed.");
        builder.newline();
        builder.newline();
        builder.closeHtmlBody();
        int result2 = Messages.showDialog((Project)project, (String)builder.getHtml(), (String)"Update the Android Gradle Plugin", (String[])new String[]{Messages.CANCEL_BUTTON, "Update"}, (int)1, (Icon)AllIcons.General.WarningDialog);
        if (result2 == 1) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project == null) {
                    DynamicAppUtils.$$$reportNull$$$0(33);
                }
                GradleVersion gradleVersion = GradleVersion.parse((String)"4.6");
                GradleVersion pluginVersion = GradleVersion.parse((String)AndroidPluginGeneration.ORIGINAL.getLatestKnownVersion());
                AndroidPluginVersionUpdater updater = AndroidPluginVersionUpdater.getInstance(project);
                updater.updatePluginVersion(pluginVersion, gradleVersion);
            });
        }
        return result2 == 1;
    }

    @NotNull
    public static String getFeatureNameFromPathHack(@NotNull Path path) {
        String fileName;
        int separatorIndex;
        if (path == null) {
            DynamicAppUtils.$$$reportNull$$$0(14);
        }
        if ((separatorIndex = (fileName = path.getFileName().toString()).lastIndexOf(45)) < 0) {
            if ("" == null) {
                DynamicAppUtils.$$$reportNull$$$0(15);
            }
            return "";
        }
        String string = fileName.substring(0, separatorIndex);
        if (string == null) {
            DynamicAppUtils.$$$reportNull$$$0(16);
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static ApkInfo collectAppBundleOutput(@NotNull Module module, @NotNull PostBuildModelProvider outputModelProvider, @NotNull String pkgName) {
        AppBundleVariantBuildOutput variantBuildOutput;
        AndroidModuleModel androidModel;
        if (module == null) {
            DynamicAppUtils.$$$reportNull$$$0(17);
        }
        if (outputModelProvider == null) {
            DynamicAppUtils.$$$reportNull$$$0(18);
        }
        if (pkgName == null) {
            DynamicAppUtils.$$$reportNull$$$0(19);
        }
        if ((androidModel = AndroidModuleModel.get(module)) == null) {
            DynamicAppUtils.getLogger().warn("Android model is null. Sync might have failed");
            return null;
        }
        PostBuildModel model = outputModelProvider.getPostBuildModel();
        if (model == null) {
            DynamicAppUtils.getLogger().warn("Post build model is null. Build might have failed.");
            return null;
        }
        AppBundleProjectBuildOutput output = model.findAppBundleProjectBuildOutput(module);
        if (output == null) {
            DynamicAppUtils.getLogger().warn("Project output is null. Build may have failed.");
            return null;
        }
        Iterator iterator = output.getAppBundleVariantsBuildOutput().iterator();
        do {
            if (iterator.hasNext()) continue;
            DynamicAppUtils.getLogger().warn("Bundle variant build output model has no entries. Build may have failed.");
            return null;
        } while (!(variantBuildOutput = (AppBundleVariantBuildOutput)iterator.next()).getName().equals(androidModel.getSelectedVariant().getName()));
        File apkFolder = variantBuildOutput.getApkFolder();
        try (Stream<Path> stream = Files.list(apkFolder.toPath());){
            List<ApkFileUnit> apks = stream.map(path -> new ApkFileUnit(DynamicAppUtils.getFeatureNameFromPathHack(path), path.toFile())).collect(Collectors.toList());
            ApkInfo apkInfo = new ApkInfo(apks, pkgName);
            return apkInfo;
        }
        catch (IOException e) {
            DynamicAppUtils.getLogger().warn(String.format("Error reading list of APK files from bundle build output directory \"%s\".", apkFolder), (Throwable)e);
            return null;
        }
    }

    public static boolean useSelectApksFromBundleBuilder(@NotNull Module module, @NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> targetDevices) {
        if (module == null) {
            DynamicAppUtils.$$$reportNull$$$0(20);
        }
        if (configuration == null) {
            DynamicAppUtils.$$$reportNull$$$0(21);
        }
        if (targetDevices == null) {
            DynamicAppUtils.$$$reportNull$$$0(22);
        }
        if (configuration instanceof AndroidAppRunConfigurationBase) {
            AndroidAppRunConfigurationBase androidConfiguration = (AndroidAppRunConfigurationBase)configuration;
            if (androidConfiguration.DEPLOY_APK_FROM_BUNDLE) {
                Preconditions.checkArgument((boolean)androidConfiguration.DEPLOY);
                return true;
            }
        }
        return targetDevices.stream().anyMatch(device -> device.getVersion().getFeatureLevel() < 21) && !DynamicAppUtils.getDependentFeatureModules(module).isEmpty();
    }

    public static boolean shouldCollectListOfLanguages(@NotNull Module module, @NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> targetDevices) {
        if (module == null) {
            DynamicAppUtils.$$$reportNull$$$0(23);
        }
        if (configuration == null) {
            DynamicAppUtils.$$$reportNull$$$0(24);
        }
        if (targetDevices == null) {
            DynamicAppUtils.$$$reportNull$$$0(25);
        }
        if (!DynamicAppUtils.useSelectApksFromBundleBuilder(module, configuration, targetDevices)) {
            return false;
        }
        return targetDevices.stream().allMatch(device -> device.getVersion().getFeatureLevel() >= 21);
    }

    @NotNull
    private static Map<String, Module> getDynamicFeaturesMap(@NotNull Project project) {
        if (project == null) {
            DynamicAppUtils.$$$reportNull$$$0(26);
        }
        Map<String, Module> map2 = Arrays.stream(ModuleManager.getInstance((Project)project).getModules()).map(module -> {
            AndroidModuleModel model = AndroidModuleModel.get(module);
            if (model == null) {
                return null;
            }
            if (model.getAndroidProject().getProjectType() != 6) {
                return null;
            }
            String gradlePath = DynamicAppUtils.getGradlePath(module);
            if (gradlePath == null) {
                return null;
            }
            return Pair.create((Object)gradlePath, (Object)module);
        }).filter(Objects::nonNull).collect(Collectors.toMap(p -> (String)p.first, p -> (Module)p.second, DynamicAppUtils::handleModuleAmbiguity));
        if (map2 == null) {
            DynamicAppUtils.$$$reportNull$$$0(27);
        }
        return map2;
    }

    @Nullable
    private static String getGradlePath(@NotNull Module module) {
        GradleFacet facet;
        if (module == null) {
            DynamicAppUtils.$$$reportNull$$$0(28);
        }
        if ((facet = GradleFacet.getInstance(module)) == null) {
            return null;
        }
        GradleModuleModel gradleModel = facet.getGradleModuleModel();
        if (gradleModel == null) {
            return null;
        }
        return gradleModel.getGradlePath();
    }

    @NotNull
    private static Module handleModuleAmbiguity(@NotNull Module m1, @NotNull Module m2) {
        if (m1 == null) {
            DynamicAppUtils.$$$reportNull$$$0(29);
        }
        if (m2 == null) {
            DynamicAppUtils.$$$reportNull$$$0(30);
        }
        DynamicAppUtils.getLogger().warn(String.format("Unexpected ambiguity processing modules: %s - %s", m1.getName(), m2.getName()));
        Module module = m1;
        if (module == null) {
            DynamicAppUtils.$$$reportNull$$$0(31);
        }
        return module;
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(DynamicAppUtils.class);
        if (logger == null) {
            DynamicAppUtils.$$$reportNull$$$0(32);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 16: 
            case 27: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 16: 
            case 27: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 16: 
            case 27: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/util/DynamicAppUtils";
                break;
            }
            case 4: 
            case 10: 
            case 13: 
            case 26: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidProject";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputModelProvider";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkgName";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDevices";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m1";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/util/DynamicAppUtils";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentFeatureModules";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesToBuild";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesSupportingBundleTask";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatureNameFromPathHack";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDynamicFeaturesMap";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "handleModuleAmbiguity";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDependentFeatureModules";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 16: 
            case 27: 
            case 31: 
            case 32: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBaseFeature";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getModulesToBuild";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isInstantRunSupported";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getModulesSupportingBundleTask";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "supportsBundleTask";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "promptUserForGradleUpdate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFeatureNameFromPathHack";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "collectAppBundleOutput";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "useSelectApksFromBundleBuilder";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "shouldCollectListOfLanguages";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getDynamicFeaturesMap";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getGradlePath";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "handleModuleAmbiguity";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$promptUserForGradleUpdate$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 16: 
            case 27: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

