/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.sdklib.AndroidVersion;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmbeddedDistributionPaths {
    @NotNull
    public static EmbeddedDistributionPaths getInstance() {
        EmbeddedDistributionPaths embeddedDistributionPaths = (EmbeddedDistributionPaths)ServiceManager.getService(EmbeddedDistributionPaths.class);
        if (embeddedDistributionPaths == null) {
            EmbeddedDistributionPaths.$$$reportNull$$$0(0);
        }
        return embeddedDistributionPaths;
    }

    @NotNull
    public List<File> findAndroidStudioLocalMavenRepoPaths() {
        File defaultRootDirPath = EmbeddedDistributionPaths.getDefaultRootDirPath();
        if (defaultRootDirPath != null) {
            File repoPath = new File(defaultRootDirPath, "m2repository");
            ImmutableList immutableList = repoPath.isDirectory() ? ImmutableList.of((Object)repoPath) : ImmutableList.of();
            if (immutableList == null) {
                EmbeddedDistributionPaths.$$$reportNull$$$0(1);
            }
            return immutableList;
        }
        ArrayList<File> repoPaths = new ArrayList<File>();
        String studioCustomRepo = System.getenv("STUDIO_CUSTOM_REPO");
        if (studioCustomRepo != null) {
            File customRepoPath = new File(FileUtil.toCanonicalPath((String)FileUtil.toSystemDependentName((String)studioCustomRepo)));
            if (!customRepoPath.isDirectory()) {
                throw new IllegalArgumentException("Invalid path in STUDIO_CUSTOM_REPO environment variable");
            }
            repoPaths.add(customRepoPath);
        } else {
            File localGMaven = new File(PathManager.getHomePath() + FileUtil.toSystemDependentName((String)"/../../out/repo"));
            if (localGMaven.isDirectory()) {
                repoPaths.add(localGMaven);
            }
            File prebuiltOfflineM2 = new File(FileUtil.toCanonicalPath((String)(EmbeddedDistributionPaths.getIdeHomePath() + FileUtil.toSystemDependentName((String)"/../../prebuilts/tools/common/offline-m2"))));
            EmbeddedDistributionPaths.getLog().info("Looking for embedded Maven repo at '" + prebuiltOfflineM2.getPath() + "'");
            if (prebuiltOfflineM2.isDirectory()) {
                repoPaths.add(prebuiltOfflineM2);
            }
        }
        File localOfflineRepoPath = new File(PathManager.getHomePath() + FileUtil.toSystemDependentName((String)"/../../out/studio/repo"));
        if (localOfflineRepoPath.isDirectory()) {
            repoPaths.add(localOfflineRepoPath);
        }
        ArrayList<File> arrayList = repoPaths;
        if (arrayList == null) {
            EmbeddedDistributionPaths.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public File findEmbeddedProfilerTransform(@NotNull AndroidVersion version2) {
        File file;
        if (version2 == null) {
            EmbeddedDistributionPaths.$$$reportNull$$$0(3);
        }
        if ((file = new File(PathManager.getHomePath(), "plugins/android/resources/profilers-transform.jar")).exists()) {
            File file2 = file;
            if (file2 == null) {
                EmbeddedDistributionPaths.$$$reportNull$$$0(4);
            }
            return file2;
        }
        String relativePath = FileUtil.toSystemDependentName((String)"/../../bazel-genfiles/tools/base/profiler/transform/profilers-transform.jar");
        File file3 = new File(PathManager.getHomePath() + relativePath);
        if (file3 == null) {
            EmbeddedDistributionPaths.$$$reportNull$$$0(5);
        }
        return file3;
    }

    @Nullable
    public File findEmbeddedGradleDistributionPath() {
        File distributionPath = EmbeddedDistributionPaths.getDefaultRootDirPath();
        if (distributionPath != null) {
            Logger log = EmbeddedDistributionPaths.getLog();
            File embeddedPath = new File(distributionPath, "gradle-4.6");
            log.info("Looking for embedded Gradle distribution at '" + embeddedPath.getPath() + "'");
            if (embeddedPath.isDirectory()) {
                log.info("Found embedded Gradle 4.6");
                return embeddedPath;
            }
            log.info("Unable to find embedded Gradle 4.6");
            return null;
        }
        String ideHomePath = EmbeddedDistributionPaths.getIdeHomePath();
        String relativePath = FileUtil.toSystemDependentName((String)"/../../tools/external/gradle");
        distributionPath = new File(FileUtil.toCanonicalPath((String)(ideHomePath + relativePath)));
        if (distributionPath.isDirectory()) {
            return distributionPath;
        }
        String localDistributionPath = System.getProperty("local.gradle.distribution.path");
        if (localDistributionPath != null && (distributionPath = new File(FileUtil.toCanonicalPath((String)localDistributionPath))).isDirectory()) {
            return distributionPath;
        }
        return null;
    }

    @Nullable
    public File findEmbeddedGradleDistributionFile(@NotNull String gradleVersion) {
        File distributionPath;
        if (gradleVersion == null) {
            EmbeddedDistributionPaths.$$$reportNull$$$0(6);
        }
        if ((distributionPath = this.findEmbeddedGradleDistributionPath()) != null) {
            File allDistributionFile = new File(distributionPath, "gradle-" + gradleVersion + "-all.zip");
            if (allDistributionFile.isFile() && allDistributionFile.exists()) {
                return allDistributionFile;
            }
            File binDistributionFile = new File(distributionPath, "gradle-" + gradleVersion + "-bin.zip");
            if (binDistributionFile.isFile() && binDistributionFile.exists()) {
                return binDistributionFile;
            }
        }
        return null;
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(EmbeddedDistributionPaths.class);
        if (logger == null) {
            EmbeddedDistributionPaths.$$$reportNull$$$0(7);
        }
        return logger;
    }

    @Nullable
    private static File getDefaultRootDirPath() {
        String ideHomePath = EmbeddedDistributionPaths.getIdeHomePath();
        File rootDirPath = new File(ideHomePath, "gradle");
        return rootDirPath.isDirectory() ? rootDirPath : null;
    }

    @Nullable
    public File tryToGetEmbeddedJdkPath() {
        try {
            return this.getEmbeddedJdkPath();
        }
        catch (Throwable t) {
            Logger.getInstance(EmbeddedDistributionPaths.class).warn("Failed to find a valid embedded JDK", t);
            return null;
        }
    }

    @NotNull
    public File getEmbeddedJdkPath() {
        String ideHomePath = EmbeddedDistributionPaths.getIdeHomePath();
        File jdkRootPath = new File(ideHomePath, SystemInfo.isMac ? FileUtil.join((String[])new String[]{"jre", "jdk"}) : "jre");
        if (jdkRootPath.isDirectory()) {
            File file = EmbeddedDistributionPaths.getSystemSpecificJdkPath(jdkRootPath);
            if (file == null) {
                EmbeddedDistributionPaths.$$$reportNull$$$0(8);
            }
            return file;
        }
        if (System.getProperty("android.test.embedded.jdk") != null) {
            File jdkDir = new File(System.getProperty("android.test.embedded.jdk"));
            assert (jdkDir.exists());
            File file = jdkDir;
            if (file == null) {
                EmbeddedDistributionPaths.$$$reportNull$$$0(9);
            }
            return file;
        }
        String jdkDevPath = System.getProperty("studio.dev.jdk", ideHomePath + "/../../prebuilts/studio/jdk");
        String relativePath = FileUtil.toSystemDependentName((String)jdkDevPath);
        jdkRootPath = new File(FileUtil.toCanonicalPath((String)relativePath));
        if (SystemInfo.isWindows) {
            jdkRootPath = new File(jdkRootPath, "win64");
        } else if (SystemInfo.isLinux) {
            jdkRootPath = new File(jdkRootPath, "linux");
        } else if (SystemInfo.isMac) {
            jdkRootPath = new File(jdkRootPath, "mac");
        }
        File file = EmbeddedDistributionPaths.getSystemSpecificJdkPath(jdkRootPath);
        if (file == null) {
            EmbeddedDistributionPaths.$$$reportNull$$$0(10);
        }
        return file;
    }

    @NotNull
    private static File getSystemSpecificJdkPath(File jdkRootPath) {
        if (SystemInfo.isMac) {
            jdkRootPath = new File(jdkRootPath, "/Contents/Home");
        }
        if (!jdkRootPath.isDirectory()) {
            throw new Error(String.format("Incomplete or corrupted installation - \"%s\" directory does not exist", jdkRootPath.toString()));
        }
        File file = jdkRootPath;
        if (file == null) {
            EmbeddedDistributionPaths.$$$reportNull$$$0(11);
        }
        return file;
    }

    @NotNull
    private static String getIdeHomePath() {
        String string = FileUtil.toSystemDependentName((String)PathManager.getHomePath());
        if (string == null) {
            EmbeddedDistributionPaths.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/util/EmbeddedDistributionPaths";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findAndroidStudioLocalMavenRepoPaths";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/util/EmbeddedDistributionPaths";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findEmbeddedProfilerTransform";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmbeddedJdkPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemSpecificJdkPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeHomePath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findEmbeddedProfilerTransform";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findEmbeddedGradleDistributionFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

