/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.instantapp;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.instantapp.InstantAppSdks;
import com.android.tools.idea.instantapp.InstantAppUrlFinder;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantApps {
    @NotNull
    public static List<Module> findFeatureModules(@NotNull AndroidFacet facet) {
        if (facet == null) {
            InstantApps.$$$reportNull$$$0(0);
        }
        List<Module> list = AndroidProjectInfo.getInstance(facet.getModule().getProject()).getAllModulesOfProjectType(5);
        if (list == null) {
            InstantApps.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public static Module findBaseFeature(@NotNull AndroidFacet facet) {
        if (facet == null) {
            InstantApps.$$$reportNull$$$0(2);
        }
        return InstantApps.findBaseFeature(InstantApps.findFeatureModules(facet));
    }

    @Nullable
    public static Module findBaseFeature(@NotNull Project project) {
        if (project == null) {
            InstantApps.$$$reportNull$$$0(3);
        }
        return InstantApps.findBaseFeature(AndroidProjectInfo.getInstance(project).getAllModulesOfProjectType(5));
    }

    @Nullable
    public static String findMonolithicModuleName(@NotNull Project project) {
        List<Module> moduleList;
        if (project == null) {
            InstantApps.$$$reportNull$$$0(4);
        }
        return (moduleList = AndroidProjectInfo.getInstance(project).getAllModulesOfProjectType(0)).isEmpty() ? null : moduleList.get(0).getName();
    }

    @Nullable
    private static Module findBaseFeature(@NotNull List<Module> featureModules) {
        if (featureModules == null) {
            InstantApps.$$$reportNull$$$0(5);
        }
        Module baseFeature = null;
        for (Module module : featureModules) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(module);
            if (androidModel == null || !androidModel.getAndroidProject().isBaseSplit()) continue;
            baseFeature = module;
            break;
        }
        return baseFeature;
    }

    @NotNull
    public static String getDefaultInstantAppUrl(@NotNull AndroidFacet facet) {
        if (facet == null) {
            InstantApps.$$$reportNull$$$0(6);
        }
        String defaultUrl = "<<ERROR - NO URL SET>>";
        if (InstantAppSdks.getInstance().shouldUseSdkLibraryToRun()) {
            defaultUrl = "";
        }
        List<Module> featureModules = InstantApps.findFeatureModules(facet);
        for (Module module : featureModules) {
            String foundUrl = new InstantAppUrlFinder(module).getDefaultUrl();
            if (!StringUtil.isNotEmpty((String)foundUrl)) continue;
            defaultUrl = foundUrl;
            break;
        }
        String string = defaultUrl;
        if (string == null) {
            InstantApps.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static boolean isInstantAppSdkEnabled() {
        return InstantAppSdks.getInstance().isInstantAppSdkEnabled();
    }

    @NotNull
    public static File getInstantAppSdk() throws FileNotFoundException {
        File sdk = InstantAppSdks.getInstance().getInstantAppSdk(true);
        if (sdk == null) {
            throw new FileNotFoundException("Instant App SDK couldn't be found.");
        }
        File file = sdk;
        if (file == null) {
            InstantApps.$$$reportNull$$$0(8);
        }
        return file;
    }

    public static long getCompatApiMinVersion() {
        return InstantAppSdks.getInstance().getCompatApiMinVersion();
    }

    public static boolean isInstantAppApplicationModule(@NotNull Module module) {
        AndroidModuleModel model;
        if (module == null) {
            InstantApps.$$$reportNull$$$0(9);
        }
        return (model = AndroidModuleModel.get(module)) != null && model.getAndroidProject().getProjectType() == 4;
    }

    public static boolean isPostO(IDevice device) {
        AndroidVersion version2 = device.getVersion();
        return version2.compareTo(25, "O") >= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/instantapp/InstantApps";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureModules";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/instantapp/InstantApps";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findFeatureModules";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultInstantAppUrl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstantAppSdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFeatureModules";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findBaseFeature";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findMonolithicModuleName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultInstantAppUrl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isInstantAppApplicationModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

